/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class UnderlineDocumentMarkerPainter
implements Highlighter.HighlightPainter {
    private Color color;

    public UnderlineDocumentMarkerPainter(Color color) {
        this.color = color;
    }

    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        this.specialPaint(g, p0 - 1, p1 + 1, bounds, c);
    }

    private void specialPaint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        try {
            TextUI mapper = c.getUI();
            Rectangle p0 = mapper.modelToView(c, offs0);
            Rectangle p1 = mapper.modelToView(c, offs1);
            g.setColor(this.color);
            float[] dashPattern = new float[]{3.0f, 1.0f, 3.0f, 1.0f};
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, dashPattern, 0.0f));
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, dashPattern, 0.0f));
            if (p0.y == p1.y) {
                Rectangle r = p0.union(p1);
                g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            } else {
                for (int i = offs0; i <= offs1; ++i) {
                    Rectangle pc = mapper.modelToView(c, i);
                    g.drawLine(pc.x, pc.y + pc.height, pc.x + pc.width, pc.y + pc.height);
                }
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }
}

