/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.qedeq.base.trace.Trace;

public final class DataDictionary {
    private static final Class CLASS = DataDictionary.class;
    private final ResourceBundle bundle;
    private static volatile DataDictionary instance = null;

    public static DataDictionary getInstance() {
        if (instance == null) {
            throw new IllegalStateException(DataDictionary.class.getName() + " not initialized, call init before!");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String baseName) {
        if (instance != null) {
            throw new IllegalStateException(DataDictionary.class.getName() + " is already initialized!");
        }
        Class clazz = DataDictionary.class;
        synchronized (clazz) {
            if (instance != null) {
                throw new IllegalStateException(DataDictionary.class.getName() + " is already initialized!");
            }
            instance = new DataDictionary("org.qedeq.gui.se.util");
        }
    }

    private DataDictionary(String baseName) {
        this.bundle = ResourceBundle.getBundle(baseName);
    }

    public String getString(String key) {
        String value = null;
        try {
            value = this.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"getString", (String)("Couldn't find value for: " + key), (Throwable)e);
        }
        if (value == null) {
            value = "Could not find resource: " + key + "  ";
        }
        return value;
    }

    public final ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public final char getMnemonic(String key) {
        return this.getString(key).charAt(0);
    }
}

