/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.main.LowerTabbedView;
import org.qedeq.gui.se.main.UpperTabbedView;
import org.qedeq.gui.se.tree.NothingSelectedException;
import org.qedeq.gui.se.tree.QedeqTreeContextMenu;
import org.qedeq.gui.se.tree.QedeqTreeModel;
import org.qedeq.gui.se.tree.QedeqTreeNode;
import org.qedeq.gui.se.tree.QedeqTreeView;
import org.qedeq.kernel.bo.common.QedeqBo;

public final class QedeqTreeCtrl
implements TreeModelListener {
    private static final Class CLASS = QedeqTreeCtrl.class;
    private final QedeqTreeView treeView;
    private final QedeqTreeModel treeModel;
    private final QedeqTreeContextMenu contextMenu;
    private final UpperTabbedView pane;
    private final LowerTabbedView lower;

    public QedeqTreeCtrl(QedeqTreeView treeView, QedeqTreeModel treeModel, UpperTabbedView pane, LowerTabbedView lowerView, QedeqController controller) {
        this.treeView = treeView;
        this.treeModel = treeModel;
        this.treeModel.addTreeModelListener(this);
        this.contextMenu = new QedeqTreeContextMenu(controller);
        this.treeView.treeAddMouseListener(new QedeqMouseListener());
        this.treeView.addTreeSelectionListener(new SelectionChangedCommand());
        this.pane = pane;
        this.lower = lowerView;
    }

    public final QedeqBo[] getSelected() throws NothingSelectedException {
        String method = "getSelected";
        Trace.begin((Class)CLASS, (Object)this, (String)"getSelected");
        try {
            TreePath[] selected = this.treeView.getSelectionPaths();
            ArrayList<QedeqBo> list = new ArrayList<QedeqBo>();
            if (selected != null && selected.length > 0) {
                Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (Object)("selection=" + selected[selected.length - 1]));
                for (int i = 0; i < selected.length; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected[i].getLastPathComponent();
                    if (!(node instanceof QedeqTreeNode)) continue;
                    QedeqBo prop = (QedeqBo)node.getUserObject();
                    list.add(prop);
                }
            }
            if (list.size() <= 0) {
                throw new NothingSelectedException();
            }
            QedeqBo[] qedeqBoArray = list.toArray(new QedeqBo[0]);
            return qedeqBoArray;
        }
        catch (RuntimeException ex) {
            Trace.trace((Class)CLASS, (Object)this, (String)"getSelected", (Throwable)ex);
            throw new NothingSelectedException();
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"getSelected");
        }
    }

    public final String getEditedQedeq() {
        return this.pane.getEditedQedeq();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        Trace.param((Class)CLASS, (Object)this, (String)"treeNodesChanged", (String)"event", (Object)e);
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    QedeqTreeCtrl.this.pane.updateView();
                }
                catch (RuntimeException ex) {
                    Trace.fatal((Class)CLASS, (Object)this, (String)"treeNodesChanged", (String)"unexpected problem", (Throwable)ex);
                }
            }
        };
        SwingUtilities.invokeLater(runLater);
        Trace.end((Class)CLASS, (Object)this, (String)"treeNodesChanged");
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Trace.begin((Class)CLASS, (Object)this, (String)"treeNodesInserted");
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    if (((DefaultMutableTreeNode)QedeqTreeCtrl.this.treeModel.getRoot()).getChildCount() > 0) {
                        Trace.trace((Class)CLASS, (Object)this, (String)"treeNodesInserted", (Object)"expandPath");
                        QedeqTreeCtrl.this.treeView.expandPath(new TreePath(QedeqTreeCtrl.this.treeModel.getRoot()));
                    }
                }
                catch (RuntimeException ex) {
                    Trace.fatal((Class)CLASS, (Object)this, (String)"treeNodesInserted", (String)"unexpected problem", (Throwable)ex);
                }
            }
        };
        SwingUtilities.invokeLater(runLater);
        Trace.end((Class)CLASS, (Object)this, (String)"treeNodesInserted");
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        Trace.trace((Class)CLASS, (Object)this, (String)"treeNodeRemoved", (Object)node.getUserObject());
    }

    public void treeStructureChanged(TreeModelEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        Trace.trace((Class)CLASS, (Object)this, (String)"treeStructureChanged", (Object)node.getUserObject());
    }

    private class QedeqMouseListener
    extends MouseAdapter {
        private QedeqMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (SwingUtilities.isRightMouseButton(evt)) {
                block3: {
                    try {
                        QedeqTreeCtrl.this.getSelected();
                    }
                    catch (NothingSelectedException e) {
                        TreePath path = QedeqTreeCtrl.this.treeView.getPathForLocation(evt.getX(), evt.getY());
                        if (path == null) break block3;
                        QedeqTreeCtrl.this.treeView.setSelectionPath(path);
                    }
                }
                QedeqTreeCtrl.this.contextMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class SelectionChangedCommand
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent event) {
            Trace.trace((Class)CLASS, (Object)this, (String)"valueChanged", (Object)event);
            TreePath path = event.getPath();
            QedeqTreeNode treeNode = (QedeqTreeNode)path.getLastPathComponent();
            if (event.isAddedPath() && treeNode.getUserObject() instanceof QedeqBo) {
                QedeqBo prop = (QedeqBo)treeNode.getUserObject();
                QedeqTreeCtrl.this.pane.setQedeqModel(prop);
                QedeqTreeCtrl.this.lower.setQedeqModel(prop);
            } else {
                QedeqTreeCtrl.this.pane.setQedeqModel(null);
                QedeqTreeCtrl.this.lower.setQedeqModel(null);
            }
        }
    }
}

