/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.tree;

import furbelow.AnimatedIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.tree.ModuleElement;
import org.qedeq.gui.se.util.DecoratedIcon;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.Service;
import org.qedeq.kernel.se.state.AbstractState;
import org.qedeq.kernel.se.state.DependencyState;
import org.qedeq.kernel.se.state.FormallyProvedState;
import org.qedeq.kernel.se.state.LoadingImportsState;
import org.qedeq.kernel.se.state.LoadingState;
import org.qedeq.kernel.se.state.WellFormedState;

public final class QedeqTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Class CLASS = QedeqTreeCellRenderer.class;
    private static ImageIcon startIcon = QedeqTreeCellRenderer.createImageIcon("module_start.gif");
    private static ImageIcon loadedIcon = QedeqTreeCellRenderer.createImageIcon("module_loaded.gif");
    private static ImageIcon loadedImportsIcon = QedeqTreeCellRenderer.createImageIcon("module_loaded_required.gif");
    private static ImageIcon loadedRequiredIcon = QedeqTreeCellRenderer.createImageIcon("module_loaded_required.gif");
    private static ImageIcon wellFormedIcon = QedeqTreeCellRenderer.createImageIcon("module_checked.gif");
    private static ImageIcon formallyProvedIcon = QedeqTreeCellRenderer.createImageIcon("module_checked2.gif");
    private static AnimatedIcon startNextIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("next_module_start.gif"));
    private static AnimatedIcon startFlashIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("flash_module_start.gif"));
    private static AnimatedIcon loadedNextIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("next_module_loaded.gif"));
    private static AnimatedIcon loadedFlashIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("flash_module_loaded.gif"));
    private static AnimatedIcon loadedImportsNextIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("next_module_loaded_required.gif"));
    private static AnimatedIcon loadedImportsFlashIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("flash_module_loaded_required.gif"));
    private static AnimatedIcon loadedRequiredNextIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("next_module_loaded_required.gif"));
    private static AnimatedIcon loadedRequiredFlashIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("flash_module_loaded_required.gif"));
    private static AnimatedIcon wellFormedNextIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("next_module_checked.gif"));
    private static AnimatedIcon wellFormedFlashIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("flash_module_checked.gif"));
    private static AnimatedIcon formallyProvedFlashIcon = new AnimatedIcon(QedeqTreeCellRenderer.createImageIcon("flash_module_checked2.gif"));
    private static ImageIcon basicErrorOverlayIcon = GuiHelper.readImageIcon("eclipse/error_co_dl.gif");
    private static ImageIcon pluginErrorOverlayIcon = GuiHelper.readImageIcon("eclipse/error_co_ur.gif");
    private static ImageIcon pluginWarningOverlayIcon = GuiHelper.readImageIcon("eclipse/warning_co_ur.gif");

    static ImageIcon createImageIcon(String name) {
        return GuiHelper.readImageIcon("qedeq/16x16/" + name);
    }

    public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String method = "getTreeCellRendererComponent";
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " is selected"), (boolean)isSelected);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " is expanded"), (boolean)expanded);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " hasFocus"), (boolean)hasFocus);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " leaf"), (boolean)leaf);
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " maxSelectionRow"), (int)tree.getMaxSelectionRow());
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " selectionCount"), (int)tree.getSelectionCount());
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " rowCount"), (int)tree.getRowCount());
        Trace.param((Class)CLASS, (Object)this, (String)"getTreeCellRendererComponent", (String)(row + " tree path"), (Object)tree.getPathForRow(row));
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode) {
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof ModuleElement) {
                ModuleElement unit = (ModuleElement)((DefaultMutableTreeNode)value).getUserObject();
                this.setText(unit.getName());
            } else {
                QedeqBo prop = (QedeqBo)((DefaultMutableTreeNode)value).getUserObject();
                String text = prop.getName();
                this.setText(text);
                AbstractState currentState = prop.getCurrentState();
                Service service = prop.getCurrentlyRunningService();
                if (prop.isLoaded()) {
                    this.setToolTipText(prop.getUrl().toString());
                } else {
                    this.setToolTipText(GuiHelper.getToolTipText(prop.getStateDescription()));
                }
                if (currentState == LoadingState.STATE_DELETED) {
                    this.setIcon(null);
                } else if (currentState == LoadingState.STATE_UNDEFINED) {
                    if (service == null) {
                        this.setIcon(prop, startIcon);
                    } else {
                        this.setIcon(startFlashIcon);
                    }
                } else if (currentState == LoadingState.STATE_LOADED) {
                    if (service == null) {
                        this.setIcon(prop, loadedIcon);
                    } else {
                        this.setIcon(loadedFlashIcon);
                    }
                } else if (currentState instanceof LoadingState) {
                    if (currentState.isFailure()) {
                        if (service == null) {
                            this.setIcon(prop, startIcon);
                        } else {
                            this.setIcon(startFlashIcon);
                        }
                    } else {
                        this.setIcon(startNextIcon);
                    }
                } else if (currentState == LoadingImportsState.STATE_LOADED_IMPORTED_MODULES) {
                    if (service == null) {
                        this.setIcon(prop, loadedImportsIcon);
                    } else {
                        this.setIcon(loadedImportsFlashIcon);
                    }
                } else if (currentState instanceof LoadingImportsState) {
                    if (currentState.isFailure()) {
                        if (service == null) {
                            this.setIcon(prop, loadedImportsIcon);
                        } else {
                            this.setIcon(loadedImportsFlashIcon);
                        }
                    } else {
                        this.setIcon(loadedImportsNextIcon);
                    }
                } else if (currentState == DependencyState.STATE_LOADED_REQUIRED_MODULES) {
                    if (service == null) {
                        this.setIcon(prop, loadedRequiredIcon);
                    } else {
                        this.setIcon(loadedRequiredFlashIcon);
                    }
                } else if (currentState instanceof DependencyState) {
                    if (currentState.isFailure()) {
                        if (service == null) {
                            this.setIcon(prop, loadedIcon);
                        } else {
                            this.setIcon(loadedFlashIcon);
                        }
                    } else {
                        this.setIcon(loadedNextIcon);
                    }
                } else if (currentState == WellFormedState.STATE_CHECKED) {
                    if (service == null) {
                        this.setIcon(prop, wellFormedIcon);
                    } else {
                        this.setIcon(wellFormedFlashIcon);
                    }
                } else if (currentState instanceof WellFormedState) {
                    if (currentState.isFailure()) {
                        if (service == null) {
                            this.setIcon(prop, loadedRequiredIcon);
                        } else {
                            this.setIcon(loadedRequiredFlashIcon);
                        }
                    } else {
                        this.setIcon(loadedRequiredNextIcon);
                    }
                } else if (currentState == FormallyProvedState.STATE_CHECKED) {
                    if (service == null) {
                        this.setIcon(prop, formallyProvedIcon);
                    } else {
                        this.setIcon(formallyProvedFlashIcon);
                    }
                } else if (currentState instanceof FormallyProvedState) {
                    if (currentState.isFailure()) {
                        if (service == null) {
                            this.setIcon(prop, wellFormedIcon);
                        } else {
                            this.setIcon(wellFormedFlashIcon);
                        }
                    } else {
                        this.setIcon(wellFormedNextIcon);
                    }
                } else {
                    throw new IllegalStateException("unknown module state: " + currentState.getText());
                }
            }
        }
        return this;
    }

    public void paintttttt(Graphics g) {
        String method = "paint";
        Trace.param((Class)CLASS, (Object)this, (String)"paint", (String)"label", (Object)this.getText());
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            g.setColor(this.getBackground());
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }

    private void setIcon(QedeqBo qedeq, ImageIcon icon) {
        DecoratedIcon ic = new DecoratedIcon(icon);
        if (qedeq.hasBasicFailures()) {
            ic.decorate(basicErrorOverlayIcon);
        }
        if (qedeq.hasWarnings()) {
            ic.decorate(pluginWarningOverlayIcon);
        }
        this.setIcon(ic);
    }
}

