/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.element.CPTextPane;
import org.qedeq.gui.se.util.GuiHelper;

public class TextPaneWindow
extends JFrame {
    private static final Class CLASS = TextPaneWindow.class;
    private final SimpleAttributeSet attrs = new SimpleAttributeSet();
    private CPTextPane textPane;
    private boolean wordWrap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextPaneWindow(String title, ImageIcon icon, String text) {
        super(title);
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.setDefaultCloseOperation(2);
            this.setupView(text);
        }
        catch (Throwable e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"Initalization of TextPaneWindow failed.", (String)"Constructor", (Throwable)e);
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    public final void setupView(String text) {
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel allOptions = new JPanel();
        allOptions.setBorder(GuiHelper.getEmptyBorder());
        allOptions.setLayout(new BoxLayout(allOptions, 1));
        allOptions.add(this.createTextPanel(text));
        content.add(allOptions);
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPaneWindow.this.dispose();
            }
        });
        JButton increaseFontSize = new JButton("+1");
        increaseFontSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MutableAttributeSet attr = TextPaneWindow.this.textPane.getInputAttributes();
                int size = StyleConstants.getFontSize(attr);
                StyleConstants.setFontSize(attr, size + 1);
                StyledDocument doc = TextPaneWindow.this.textPane.getStyledDocument();
                doc.setCharacterAttributes(0, doc.getLength(), attr, true);
            }
        });
        JButton decreaseFontSize = new JButton("-1");
        decreaseFontSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MutableAttributeSet attr = TextPaneWindow.this.textPane.getInputAttributes();
                int size = StyleConstants.getFontSize(attr);
                if (size > 1) {
                    StyleConstants.setFontSize(attr, size - 1);
                    StyledDocument doc = TextPaneWindow.this.textPane.getStyledDocument();
                    doc.setCharacterAttributes(0, doc.getLength(), attr, true);
                }
            }
        });
        final JButton wrap = new JButton("wrap on");
        wrap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextPaneWindow.this.wordWrap = !TextPaneWindow.this.wordWrap;
                if (TextPaneWindow.this.wordWrap) {
                    wrap.setText("wrap on");
                } else {
                    wrap.setText("wrap off");
                }
                Dimension d = TextPaneWindow.this.textPane.getSize();
                d.setSize(d.height, d.width - 1);
                TextPaneWindow.this.textPane.setSize(d);
                d.setSize(d.height, d.width + 1);
                TextPaneWindow.this.textPane.setSize(d);
            }
        });
        bbuilder.addGriddedButtons(new JButton[]{wrap, decreaseFontSize, increaseFontSize, ok});
        JPanel buttons = bbuilder.getPanel();
        content.add(GuiHelper.addSpaceAndAlignRight(buttons));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = this.getHeight();
        int width = this.getWidth();
        if (screenSize.height - this.getHeight() < 50) {
            height = screenSize.height - 50;
        }
        if (screenSize.width - width < 40) {
            width = screenSize.width - 40;
        } else if (screenSize.width - width > 40) {
            width += 20;
        }
        this.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
    }

    private final JPanel createTextPanel(String text) {
        this.textPane = new CPTextPane(false){

            public boolean getScrollableTracksViewportWidth() {
                return TextPaneWindow.this.wordWrap;
            }
        };
        this.textPane.setFont(new Font("Monospaced", 0, this.textPane.getFont().getSize()));
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        try {
            doc.insertString(0, text, this.attrs);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        this.textPane.setDocument(doc);
        JPanel panel = new JPanel();
        this.textPane.setDragEnabled(true);
        this.textPane.setAutoscrolls(true);
        this.textPane.setCaretPosition(0);
        this.textPane.setEditable(false);
        this.textPane.getCaret().setVisible(false);
        this.textPane.setFocusable(true);
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.textPane);
        vp.setBackground(this.textPane.getBackground());
        panel.setLayout(new BorderLayout(1, 1));
        panel.add(scroller);
        return panel;
    }
}

