/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.io.File;
import java.io.IOException;
import org.qedeq.base.io.IoUtility;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.se.config.QedeqConfig;

public final class QedeqGuiConfig
extends QedeqConfig {
    private static QedeqGuiConfig instance = null;

    public static QedeqGuiConfig getInstance() {
        if (instance == null) {
            throw new IllegalStateException(QedeqGuiConfig.class.getName() + " not initialized, call init before!");
        }
        return instance;
    }

    public static void init(File configFile, File basisDirectory) throws IOException {
        instance = new QedeqGuiConfig(configFile, "This file is part of the project *Hilbert II* - http://www.qedeq.org", basisDirectory);
    }

    private QedeqGuiConfig(File configFile, String description, File basisDirectory) throws IOException {
        super(configFile, description, basisDirectory);
    }

    public final boolean isAutomaticLogScroll() {
        return "true".equals(this.getKeyValue("automaticLogScroll", "true"));
    }

    public final void setAutomaticLogScroll(boolean value) {
        this.setKeyValue("automaticLogScroll", value ? "true" : "false");
    }

    public final String getIconSize() {
        return this.getKeyValue("iconSize", "16x16");
    }

    public final void setIconSize(String value) {
        this.setKeyValue("iconSize", value);
    }

    public final String getLookAndFeel() {
        return this.getKeyValue("lookAndFeel", "PlasticXP");
    }

    public final void setLookAndFeel(String value) {
        this.setKeyValue("lookAndFeel", value);
    }

    public final boolean isAutoStartHtmlBrowser() {
        return "true".equals(this.getKeyValue("autoStartHtmlBrowser", "true"));
    }

    public final void setAutoStartHtmlBrowser(boolean mode) {
        this.setKeyValue("autoStartHtmlBrowser", mode ? "true" : "false");
    }

    public final boolean isDirectResponse() {
        return "true".equals(this.getKeyValue("directResponse", "true"));
    }

    public final void setDirectResponse(boolean mode) {
        this.setKeyValue("directResponse", mode ? "true" : "false");
    }

    public final File getFileBrowserStartDirecty() {
        File dflt = IoUtility.isWebStarted() ? KernelContext.getInstance().getConfig().getBasisDirectory() : new File("./sample");
        String dir = this.getKeyValue("fileBrowserStartDirectory");
        if (dir == null || dir.length() <= 0) {
            return dflt;
        }
        return new File(dir);
    }

    public final void setFileBrowserStartDirecty(File directory) {
        this.setKeyValue("fileBrowserStartDirectory", directory.toString());
    }
}

