/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.gui.se.pane.ProcessListModel;
import org.qedeq.gui.se.pane.TextPaneWindow;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.bo.common.QedeqBoSet;
import org.qedeq.kernel.bo.common.ServiceCall;
import org.qedeq.kernel.bo.common.ServiceProcess;

public class ProcessListPane
extends JPanel {
    private static final Class CLASS = ProcessListPane.class;
    private final Set selectedProcesses;
    private boolean automaticRefresh = true;
    private ProcessListModel model = new ProcessListModel();
    private final JTable list = new JTable(this.model){

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            try {
                ServiceProcess process = ProcessListPane.this.model.getServiceProcess(row);
                switch (col) {
                    case 0: {
                        if (process.isBlocked()) {
                            tip = "Process is waiting";
                            break;
                        }
                        if (process.isRunning()) {
                            tip = "Process is running";
                            break;
                        }
                        if (process.wasFailure()) {
                            tip = "Process was stopped.";
                            break;
                        }
                        if (process.wasSuccess()) {
                            tip = "Process has finished";
                        }
                        break;
                    }
                    case 1: {
                        tip = process.getServiceCall() != null ? process.getServiceCall().getService().getServiceDescription() : process.getExecutionActionDescription();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        tip = ProcessListPane.this.getUrlList(process.getCurrentlyProcessedModules());
                        break;
                    }
                    case 7: {
                        tip = GuiHelper.getToolTipText(process.getExecutionActionDescription());
                        break;
                    }
                    case 8: {
                        tip = GuiHelper.getToolTipText(process.getServiceCall() != null ? process.getServiceCall().getParametersString() + "; " + process.getServiceCall().getParametersString() : "");
                        break;
                    }
                    default: {
                        tip = "";
                        break;
                    }
                }
            }
            catch (RuntimeException ex) {
                return super.getToolTipText(e);
            }
            return tip;
        }
    };
    private final SimpleAttributeSet errorAttrs = new SimpleAttributeSet();
    private JScrollPane scrollPane;
    static /* synthetic */ Class class$java$lang$Thread;

    private String getUrlList(QedeqBo[] list) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(list[i].getUrl());
        }
        return result.toString();
    }

    public ProcessListPane() {
        super(false);
        this.selectedProcesses = new TreeSet();
        this.setupView();
    }

    private final void setupView() {
        this.list.setFont(new Font("Lucida Sans Unicode", 0, this.list.getFont().getSize()));
        this.list.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ProcessListPane.this.list.scrollRectToVisible(ProcessListPane.this.list.getCellRect(ProcessListPane.this.list.getRowCount() - 1, 0, true));
            }
        });
        FormLayout layout = new FormLayout("min:grow", "0:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setBorder(BorderFactory.createEmptyBorder());
        builder.setRowGroupingEnabled(true);
        CellConstraints cc = new CellConstraints();
        builder.appendRow(new RowSpec("0:grow"));
        this.list.setDefaultRenderer(Icon.class, new IconCellRenderer());
        final ListSelectionModel rowSM = this.list.getSelectionModel();
        rowSM.setSelectionMode(2);
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ProcessListPane.this.selectedProcesses.clear();
                if (!rowSM.isSelectionEmpty()) {
                    int minIndex = rowSM.getMinSelectionIndex();
                    int maxIndex = rowSM.getMaxSelectionIndex();
                    for (int i = minIndex; i <= maxIndex; ++i) {
                        ServiceProcess process;
                        if (!rowSM.isSelectedIndex(i) || (process = ProcessListPane.this.model.getServiceProcess(i)) == null) continue;
                        ProcessListPane.this.selectedProcesses.add(process);
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.list);
        builder.add((Component)this.scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 2, "fill, fill"));
        StyleConstants.setForeground(this.errorAttrs, Color.red);
        this.scrollPane.getViewport().setBackground(Color.white);
        StyleConstants.setBackground(this.errorAttrs, Color.white);
        JTableHeader header = this.list.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(2);
        header.setPreferredSize(new Dimension(this.list.getTableHeader().getWidth(), (int)(1.1 * (double)this.getFontMetrics(this.getFont()).getHeight())));
        this.changeHeaderWidth();
        Thread refresh = new Thread(){

            public void run() {
                while (ProcessListPane.this.automaticRefresh) {
                    ProcessListPane.this.updateView();
                    IoUtility.sleep((int)5000);
                }
            }
        };
        refresh.setDaemon(true);
        refresh.start();
    }

    private void changeHeaderWidth() {
        TableColumnModel columnModel = this.list.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(24);
        columnModel.getColumn(0).setMinWidth(24);
        columnModel.getColumn(1).setPreferredWidth(200);
        columnModel.getColumn(1).setMinWidth(150);
        columnModel.getColumn(2).setPreferredWidth(200);
        columnModel.getColumn(2).setMinWidth(150);
        columnModel.getColumn(3).setPreferredWidth(100);
        columnModel.getColumn(3).setMinWidth(100);
        columnModel.getColumn(4).setPreferredWidth(100);
        columnModel.getColumn(4).setMinWidth(100);
        columnModel.getColumn(5).setPreferredWidth(100);
        columnModel.getColumn(5).setMinWidth(100);
        columnModel.getColumn(6).setPreferredWidth(60);
        columnModel.getColumn(6).setMinWidth(60);
        columnModel.getColumn(7).setPreferredWidth(2000);
        columnModel.getColumn(7).setMinWidth(100);
        columnModel.getColumn(8).setPreferredWidth(200);
        columnModel.getColumn(8).setMinWidth(100);
    }

    public synchronized void updateView() {
        String method = "updateView";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        ((AbstractTableModel)this.list.getModel()).fireTableDataChanged();
        this.list.invalidate();
        this.revalidate();
    }

    public void refreshStates() {
        Runnable stateChanged = new Runnable(){

            public void run() {
                ProcessListPane.this.updateView();
            }
        };
        SwingUtilities.invokeLater(stateChanged);
    }

    public void setRunningOnly(boolean runningOnly) {
        this.model.setOnlyRunning(runningOnly);
        this.selectedProcesses.clear();
        this.list.getSelectionModel().clearSelection();
        this.refreshStates();
    }

    public void stopSelected() {
        Iterator iterator = this.selectedProcesses.iterator();
        while (iterator.hasNext()) {
            ServiceProcess process = (ServiceProcess)iterator.next();
            if (process == null || !process.isRunning()) continue;
            process.interrupt();
        }
    }

    public void stackTraceSelected() {
        if (!this.selectedProcesses.isEmpty()) {
            StringBuffer result = new StringBuffer();
            Iterator iterator = this.selectedProcesses.iterator();
            while (iterator.hasNext()) {
                ServiceProcess process = (ServiceProcess)iterator.next();
                if (process == null || !process.isRunning() || !YodaUtility.existsMethod((Class)(class$java$lang$Thread == null ? ProcessListPane.class$("java.lang.Thread") : class$java$lang$Thread), (String)"getStackTrace", (Class[])new Class[0])) continue;
                StackTraceElement[] trace = new StackTraceElement[]{};
                result.append("id ").append(process.getId());
                try {
                    trace = (StackTraceElement[])YodaUtility.executeMethod((Object)process.getThread(), (String)"getStackTrace", (Class[])new Class[0], (Object[])new Object[0]);
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                for (int i = 0; i < trace.length; ++i) {
                    result.append(trace[i]);
                    result.append("\n");
                }
                result.append("\n\n");
            }
            new TextPaneWindow("Stacktrace", GuiHelper.readImageIcon("tango/16x16/devices/video-display.png"), result.toString()).setVisible(true);
        }
    }

    public void detailsSelected() {
        if (!this.selectedProcesses.isEmpty()) {
            StringBuffer result = new StringBuffer();
            Iterator iterator = this.selectedProcesses.iterator();
            while (iterator.hasNext()) {
                ServiceProcess process = (ServiceProcess)iterator.next();
                if (process == null) continue;
                result.append("id ").append(process.getId());
                String tip = "";
                if (process.isBlocked()) {
                    tip = "Process is waiting";
                } else if (process.isRunning()) {
                    tip = "Process is running";
                } else if (process.wasFailure()) {
                    tip = "Process was stopped.";
                } else if (process.wasSuccess()) {
                    tip = "Process has finished";
                }
                result.append("\n\tStatus:     ").append(tip);
                result.append("\n\tAction:     ").append(process.getActionName());
                result.append("\n\tModule:     ").append(process.getQedeqName());
                result.append("\n\tURL:        ").append(process.getQedeqUrl());
                result.append("\n\tStart:      ").append(DateUtility.getIsoTime((long)process.getStart()));
                result.append("\n\tStop:       ").append(process.getStop() != 0L ? DateUtility.getIsoTime((long)process.getStop()) : "");
                result.append("\n\tPercentage: ").append(process.getExecutionPercentage());
                result.append("\n\tDescription:").append(process.getExecutionActionDescription());
                result.append("\n\tBlocked:   ");
                QedeqBoSet blocked = process.getBlockedModules();
                Iterator bIterator = blocked.iterator();
                while (bIterator.hasNext()) {
                    QedeqBo qedeq = (QedeqBo)bIterator.next();
                    result.append(" ").append(qedeq.getName());
                }
                result.append("\n\tCalls:   ");
                for (ServiceCall parent = process.getServiceCall(); parent != null; parent = parent.getParentServiceCall()) {
                    result.append("\n\t\t ").append(parent.getId());
                    tip = "";
                    tip = !parent.isRunning() ? "Call is finished" : (parent.isPaused() ? "Call is paused" : "Call is running");
                    result.append("\n\t\t Status:     ").append(tip);
                    result.append("\n\t\t Module:     ").append(parent.getQedeq().getName());
                    result.append("\n\t\t Plugin:     ").append(parent.getService().getServiceAction());
                    result.append("\n\t\t Begin:      ").append(DateUtility.getIsoTime((long)parent.getBeginTime()));
                    result.append("\n\t\t End:        ").append(!parent.isRunning() ? DateUtility.getIsoTime((long)parent.getEndTime()) : "");
                    result.append("\n\t\t Percentage: ").append(parent.getExecutionPercentage());
                    result.append("\n\t\t Description:").append(parent.getAction());
                    result.append("\n\t\t Config Par.:").append(parent.getConfigParametersString());
                    result.append("\n\t\t Parameter:  ").append(parent.getParametersString());
                }
                result.append("\n");
            }
            new TextPaneWindow("Service Process Details", GuiHelper.readImageIcon("tango/16x16/devices/video-display.png"), result.toString()).setVisible(true);
        }
    }

    private static class IconCellRenderer
    extends DefaultTableCellRenderer {
        private IconCellRenderer() {
        }

        protected void setValue(Object value) {
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                super.setValue(null);
            } else {
                this.setIcon(null);
                super.setValue(value);
            }
        }
    }
}

