/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.pane.ProofParserPane;
import org.qedeq.kernel.bo.parser.AsciiMathParser;
import org.qedeq.kernel.bo.parser.MathParser;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

class ProofTextParserAction
extends AbstractAction {
    private static final Class CLASS = ProofTextParserAction.class;
    private final QedeqController controller;

    ProofTextParserAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        String resourceName = "proofTextMathOperators.xml";
        try {
            ProofParserPane pane = new ProofParserPane("Proof Text", (MathParser)new AsciiMathParser(), "QEDEQ Proof Text Parser Sample", "proofTextMathOperators.xml", "     A -> A & A\n(1)  B -> (A -> (A & B))   Add axiom:AND-3\n(2)  A -> (A -> (A & A))   subpred B A 1\n(3)     A                  Hypothesis\n(4)     A -> (A & A)       MP 2, 3\n(5)    A & A               MP 4, 3\n(6) A -> (A & A)           Conclusion\n\n\n\n\n\n\n\n\n");
            pane.setVisible(true);
        }
        catch (SourceFileExceptionList xl) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"Parser Window can not be opened", (Throwable)xl);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Parser Window can not be opened. There is a problem with \"proofTextMathOperators.xml\"\n\nJust deleting this file in the config directory should fix the error.\n\n" + xl.toString(), "Error", 0);
        }
        catch (RuntimeException ex) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"unexpected problem", (Throwable)ex);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Parser Window can not be opened\n" + ex.toString(), "Error", 0);
        }
    }
}

