/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xframe.xsddoc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtil {
    private static final int COPY_BUFFER_SIZE = 8192;
    private static final String FILE_SEP = File.separator;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, File file) throws IOException {
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            FileUtil.copyFile(inputStream, fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            outputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
    }

    public static void copyFile(InputStream inputStream, String string) throws IOException {
        FileUtil.copyFile(inputStream, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            FileUtil.copyFile((InputStream)fileInputStream, string2);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static String getLocation(String string, String string2) {
        if (string == null || string2.indexOf(58) > 0) {
            return string2;
        }
        String string3 = new File(string).getParent();
        if (string3 == null) {
            return string2;
        }
        return string3 + FILE_SEP + string2;
    }
}

