/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.util;

public class RGB {
    public static final RGB MAGENTA = new RGB(255, 0, 255);
    public static final RGB GREEN = new RGB(0, 255, 0);
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB RED = new RGB(255, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    public static final RGB ORANGE = new RGB(255, 200, 0);
    public static final RGB CYAN = new RGB(0, 255, 255);
    public static final RGB BLUE = new RGB(0, 0, 255);
    public static final RGB LIGHT_GRAY = new RGB(192, 192, 192);
    public static final RGB GRAY = new RGB(128, 128, 128);
    public static final RGB DARK_GRAY = new RGB(64, 64, 64);
    public static final RGB YELLOW = new RGB(255, 255, 0);
    public static final RGB PINK = new RGB(255, 175, 175);
    private int red;
    private int green;
    private int blue;

    public RGB(int red, int green, int blue) {
        RGB.assertColorValueRange(red, green, blue);
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    private static void assertColorValueRange(int red, int green, int blue) {
        boolean rangeError = false;
        String badComponentString = "";
        if (red < 0 || red > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Red";
        }
        if (green < 0 || green > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Green";
        }
        if (blue < 0 || blue > 255) {
            rangeError = true;
            badComponentString = badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + badComponentString);
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RGB)) {
            return false;
        }
        RGB other = (RGB)obj;
        return other.getRed() == this.getRed() && other.getGreen() == this.getGreen() && other.getBlue() == this.getBlue();
    }

    public int hashCode() {
        return (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public String toString() {
        return "RGB {" + this.red + ", " + this.green + ", " + this.blue + "}";
    }
}

