/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.cenqua.clover.util.ByteSized;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizedLRUCacheMap<K, V extends ByteSized>
extends LinkedHashMap<K, V> {
    private long maxLength;
    private long currentLength;

    public SizedLRUCacheMap(long maxLength, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.maxLength = maxLength;
        this.currentLength = 0L;
    }

    long getCurrentSizeInBytes() {
        return this.currentLength;
    }

    @Override
    public V remove(Object key) {
        ByteSized removed = (ByteSized)super.remove(key);
        if (removed != null) {
            this.currentLength -= removed.sizeInBytes();
        }
        return (V)removed;
    }

    @Override
    public void clear() {
        this.currentLength = 0L;
        super.clear();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        ByteSized replaced = (ByteSized)super.put(key, value);
        if (replaced != null) {
            this.currentLength -= replaced.sizeInBytes();
        }
        this.currentLength += value.sizeInBytes();
        return (V)replaced;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        long eldestSize = ((ByteSized)eldest.getValue()).sizeInBytes();
        if (this.currentLength + eldestSize > this.maxLength) {
            this.currentLength -= eldestSize;
            return true;
        }
        return false;
    }

    @Override
    public /* synthetic */ Object remove(Object x0) {
        return this.remove(x0);
    }

    @Override
    public /* synthetic */ Object put(Object x0, Object x1) {
        return this.put((K)x0, (V)((ByteSized)x1));
    }
}

