/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.registry.StatementInfo;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MetricsFormatUtils {
    public static final String NO_METRICS_LABEL = "-";
    public static final String ERROR_METRICS_LABEL = "Error";

    public static String format100PcCoverage() {
        return MetricsFormatUtils.getPercentFormatter().format(1.0);
    }

    private static NumberFormat getPercentFormatter() {
        NumberFormat format = DecimalFormat.getPercentInstance();
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        return format;
    }

    private static NumberFormat getDecimalFormatter() {
        NumberFormat format = DecimalFormat.getNumberInstance();
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        return format;
    }

    private static NumberFormat getIntegerFormatter() {
        return DecimalFormat.getIntegerInstance();
    }

    public static String formatMetricsDecimal(double value) {
        if (value == -1.0 || Double.isNaN(value) || Double.isInfinite(value)) {
            return NO_METRICS_LABEL;
        }
        return MetricsFormatUtils.getDecimalFormatter().format(value);
    }

    public static String formatMetricsPercent(double value) {
        if (value == -1.0 || Double.isNaN(value) || Double.isInfinite(value)) {
            return NO_METRICS_LABEL;
        }
        return MetricsFormatUtils.getPercentFormatter().format(value);
    }

    public static String formatMetricsInteger(long value) {
        if (value == Long.MIN_VALUE) {
            return NO_METRICS_LABEL;
        }
        return MetricsFormatUtils.getIntegerFormatter().format(value);
    }

    public static float getAvgMethodComplexity(BlockMetrics metrics) {
        float complexity = -1.0f;
        if (metrics instanceof ClassMetrics) {
            complexity = ((ClassMetrics)metrics).getAvgMethodComplexity();
        }
        return complexity;
    }

    public static int getComplexity(BlockMetrics metrics) {
        return metrics.getComplexity();
    }

    public static float getComplexityDensity(BlockMetrics metrics) {
        return metrics.getComplexityDensity();
    }

    public static long getNumPackages(BlockMetrics metrics) {
        long numPackages = Long.MIN_VALUE;
        if (metrics instanceof ProjectMetrics) {
            numPackages = ((ProjectMetrics)metrics).getNumPackages();
        }
        return numPackages;
    }

    public static long getNumMethods(BlockMetrics metrics) {
        long numMethods = Long.MIN_VALUE;
        if (metrics instanceof ClassMetrics) {
            numMethods = ((ClassMetrics)metrics).getNumMethods();
        }
        return numMethods;
    }

    public static long getNumFiles(BlockMetrics metrics) {
        long numFiles = Long.MIN_VALUE;
        if (metrics instanceof PackageMetrics) {
            numFiles = ((PackageMetrics)metrics).getNumFiles();
        }
        return numFiles;
    }

    public static long getNcLineCount(BlockMetrics metrics) {
        long ncLineCount = Long.MIN_VALUE;
        if (metrics instanceof FileMetrics) {
            ncLineCount = ((FileMetrics)metrics).getNcLineCount();
        }
        return ncLineCount;
    }

    public static long getNumClasses(BlockMetrics metrics) {
        long numClasses = Long.MIN_VALUE;
        if (metrics instanceof FileMetrics) {
            numClasses = ((FileMetrics)metrics).getNumClasses();
        }
        return numClasses;
    }

    public static long getLineCount(BlockMetrics metrics) {
        long lineCount = Long.MIN_VALUE;
        if (metrics instanceof FileMetrics) {
            lineCount = ((FileMetrics)metrics).getLineCount();
        }
        return lineCount;
    }

    public static long getNumStatements(BlockMetrics metrics) {
        long numStatements = Long.MIN_VALUE;
        if (metrics != null) {
            numStatements = metrics.getNumStatements();
        }
        return numStatements;
    }

    public static long getNumBranches(BlockMetrics metrics) {
        long numBranches = Long.MIN_VALUE;
        if (metrics != null) {
            numBranches = metrics.getNumBranches();
        }
        return numBranches;
    }

    public static String textForCoverage(ElementInfo info) {
        if (info instanceof BranchInfo) {
            BranchInfo branchInfo = (BranchInfo)info;
            return "Line " + info.getStartLine() + ": Expression evaluated to true " + branchInfo.getTrueHitCount() + " time" + (branchInfo.getTrueHitCount() == 1 ? "" : "s") + ", false " + branchInfo.getFalseHitCount() + " time" + (branchInfo.getFalseHitCount() == 1 ? "" : "s") + ".";
        }
        if (info instanceof StatementInfo) {
            return "Line " + info.getStartLine() + ": Statement executed " + info.getHitCount() + " time" + (info.getHitCount() == 1 ? "" : "s") + ".";
        }
        return "Line " + info.getStartLine() + ": " + (((MethodInfo)info).isTest() ? "Test method" : "Method") + " executed " + info.getHitCount() + " time" + (info.getHitCount() == 1 ? "" : "s") + ".";
    }
}

