/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._StringBuffer;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.test.optimization.Snapshot;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CloverUtils {
    private static final Object FILE_SYSTEM_LOCK = new Object();
    public static final String SYNTH_TESTNAME_PREF = "__CLR3_1_10";
    private static final HashSet IGNORE_TRACE_LINES = new HashSet();

    public static boolean scrubCoverageData(String initString, boolean deleteDatabase) {
        return CloverUtils.scrubCoverageData(initString, deleteDatabase, false, false);
    }

    public static boolean scrubCoverageData(String initString, boolean deleteDatabase, boolean deleteSnapshot, boolean verbose) {
        String testSnapshotName;
        String baseName;
        String[] files;
        if (initString == null) {
            return false;
        }
        File cloverDb = new File(initString);
        File cloverDbDir = cloverDb.getParentFile();
        if (cloverDbDir != null && cloverDbDir.exists() && cloverDbDir.isDirectory() && (files = cloverDbDir.list(new FilenameFilter(baseName = cloverDb.getName(), deleteDatabase, testSnapshotName = Snapshot.fileNameForInitString(baseName), deleteSnapshot){
            final /* synthetic */ String val$baseName;
            final /* synthetic */ boolean val$deleteDatabase;
            final /* synthetic */ String val$testSnapshotName;
            final /* synthetic */ boolean val$deleteSnapshot;
            {
                this.val$baseName = string;
                this.val$deleteDatabase = bl;
                this.val$testSnapshotName = string2;
                this.val$deleteSnapshot = bl2;
            }

            public boolean accept(File dir, String name) {
                if (this.val$baseName.equals(name)) {
                    return this.val$deleteDatabase;
                }
                if (this.val$testSnapshotName.equals(name)) {
                    return this.val$deleteSnapshot;
                }
                return name.startsWith(this.val$baseName);
            }
        })) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String fname = files[i];
                File covFile = new File(cloverDbDir, fname);
                if (!covFile.exists() || covFile.isDirectory()) continue;
                if (verbose) {
                    Logger.getInstance().info("Deleting " + covFile.getAbsolutePath());
                }
                if (covFile.delete()) continue;
                Logger.getInstance().error("Unable to delete " + covFile.getAbsolutePath());
                return false;
            }
        }
        return true;
    }

    public static String cloverizeClassName(String className) {
        return className == null ? className : className.replace('$', '.').replaceAll("\\.[0-9]+", "");
    }

    public static File createOutFile(FileInfo finfo, String outname, File baseDir) throws IOException {
        BasePackageInfo pkg = finfo.getContainingPackage();
        File outdir = CloverUtils.createOutDir(pkg, baseDir);
        return new File(outdir, outname);
    }

    public static File createOutDir(BasePackageInfo pkg, File basePath) throws IOException {
        File outdir = new File(basePath, pkg.isDefault() ? pkg.getName() : pkg.getPath());
        CloverUtils.createDir(outdir);
        return outdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDir(File outdir) throws IOException {
        Object object = FILE_SYSTEM_LOCK;
        synchronized (object) {
            if (!outdir.mkdirs() && !outdir.isDirectory()) {
                throw new IOException("Failed to create directory " + outdir);
            }
        }
    }

    public static void logDeprecationWarning(String name) {
        Logger.getInstance().warn("WARNING: The " + name + " is deprecated. It will be ignored.");
    }

    public static String createSyntheticTestName(MethodInfo method) {
        return SYNTH_TESTNAME_PREF + Long.toString(Math.abs(method.getName().hashCode()), 36) + Integer.toString(method.getDataIndex(), 36);
    }

    public static String transformStackTrace(String trace, boolean filterTrace) {
        if (trace == null) {
            return null;
        }
        String FILE_REGEX = "(\\(.*\\))";
        String SYNTH_NAME_REGEXP = SYNTH_TESTNAME_PREF;
        Pattern synthPattern = Pattern.compile(SYNTH_TESTNAME_PREF);
        Pattern filePattern = Pattern.compile("(\\(.*\\))");
        StringBuffer buff = new StringBuffer();
        int nl = 10;
        LineNumberReader reader = new LineNumberReader(new StringReader(trace));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher synthMatcher = synthPattern.matcher(line);
                if (synthMatcher.find()) {
                    Matcher fileMatcher = filePattern.matcher(line);
                    if (fileMatcher.find()) {
                        String filePart = fileMatcher.group(1);
                        String nextLine = reader.readLine();
                        if (nextLine == null) {
                            buff.append(line);
                            return buff.toString();
                        }
                        Matcher nextMatcher = filePattern.matcher(nextLine);
                        if (nextMatcher.find()) {
                            _StringBuffer.append(buff, nextLine.subSequence(0, nextMatcher.start()));
                            buff.append(filePart);
                            buff.append('\n');
                            continue;
                        }
                        buff.append(line);
                        buff.append('\n');
                        buff.append(nextLine);
                        buff.append('\n');
                        continue;
                    }
                    buff.append(line);
                    buff.append('\n');
                    continue;
                }
                if (filterTrace) {
                    String fqmn;
                    int firstSpace = line.indexOf(" ");
                    int openParen = line.indexOf("(");
                    if (firstSpace >= 0 && openParen >= 0 && firstSpace < openParen && IGNORE_TRACE_LINES.contains(fqmn = line.substring(firstSpace + 1, openParen))) continue;
                }
                buff.append(line);
                buff.append('\n');
            }
        }
        catch (IOException e) {
            Logger.getInstance().error(e.getMessage() + " reading stack trace: " + trace);
        }
        return buff.toString().trim();
    }

    public static String packageNameToPath(String name, boolean isDefaultPkg) {
        String workingPath = "";
        if (!isDefaultPkg && name.length() > 0) {
            workingPath = name.replace('.', '/') + '/';
        }
        return workingPath;
    }

    static {
        IGNORE_TRACE_LINES.add("sun.reflect.NativeMethodAccessorImpl.invoke");
        IGNORE_TRACE_LINES.add("sun.reflect.DelegatingMethodAccessorImpl.invoke");
        IGNORE_TRACE_LINES.add("sun.reflect.NativeMethodAccessorImpl.invoke0");
        IGNORE_TRACE_LINES.add("java.lang.reflect.Method.invoke");
        IGNORE_TRACE_LINES.add("junit.framework.Assert.assertEquals");
        IGNORE_TRACE_LINES.add("junit.framework.TestCase.runTest");
        IGNORE_TRACE_LINES.add("junit.framework.TestCase.runBare");
        IGNORE_TRACE_LINES.add("junit.framework.TestResult$1.protect");
        IGNORE_TRACE_LINES.add("junit.framework.TestResult.runProtected");
        IGNORE_TRACE_LINES.add("junit.framework.TestResult.run");
        IGNORE_TRACE_LINES.add("junit.framework.TestCase.run");
        IGNORE_TRACE_LINES.add("junit.framework.TestSuite.runTest");
        IGNORE_TRACE_LINES.add("junit.framework.TestSuite.run");
        IGNORE_TRACE_LINES.add("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner.run");
        IGNORE_TRACE_LINES.add("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner.launch");
        IGNORE_TRACE_LINES.add("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner.main");
    }
}

