/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import java.io.Serializable;

class TestMethodCall
implements Serializable {
    private static final long serialVersionUID = 9075409289508758000L;
    private final String runtimeTypeName;
    private final String sourceMethodName;
    private final String runtimeMethodName;
    private final String packagePath;

    private TestMethodCall(String runtimeTypeName, String sourceMethodName, String packagePath) {
        this.runtimeTypeName = runtimeTypeName;
        this.sourceMethodName = sourceMethodName;
        this.runtimeMethodName = runtimeTypeName + "." + this.getSimpleMethodName(sourceMethodName);
        this.packagePath = packagePath;
    }

    public static TestMethodCall createFor(ProjectInfo project, TestCaseInfo tci) {
        String packagePathName = TestMethodCall.packagePathNameFor(tci, project);
        if (packagePathName != null && tci.getRuntimeTypeName() != null && tci.getSourceMethodName() != null) {
            return new TestMethodCall(tci.getRuntimeTypeName(), tci.getSourceMethodName(), packagePathName);
        }
        return null;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public String getRuntimeMethodName() {
        return this.runtimeMethodName;
    }

    public boolean isInheritedCall() {
        return !this.runtimeMethodName.equals(this.sourceMethodName);
    }

    public final String getSimpleMethodName(String methodName) {
        return methodName == null ? null : (methodName.indexOf(46) == -1 ? methodName : methodName.substring(Math.min(methodName.length() - 1, methodName.lastIndexOf(46) + 1)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestMethodCall that = (TestMethodCall)o;
        if (this.packagePath != null ? !this.packagePath.equals(that.packagePath) : that.packagePath != null) {
            return false;
        }
        if (this.runtimeTypeName != null ? !this.runtimeTypeName.equals(that.runtimeTypeName) : that.runtimeTypeName != null) {
            return false;
        }
        return !(this.sourceMethodName != null ? !this.sourceMethodName.equals(that.sourceMethodName) : that.sourceMethodName != null);
    }

    public int hashCode() {
        int result = this.runtimeTypeName != null ? this.runtimeTypeName.hashCode() : 0;
        result = 31 * result + (this.sourceMethodName != null ? this.sourceMethodName.hashCode() : 0);
        result = 31 * result + (this.packagePath != null ? this.packagePath.hashCode() : 0);
        return result;
    }

    public static String packagePathNameFor(TestCaseInfo tci, ProjectInfo project) {
        if (!tci.isResolved()) {
            tci.resolve(project);
        }
        if (tci.getRuntimeType() != null && tci.getRuntimeType().getContainingFile() != null) {
            return tci.getRuntimeType().getContainingFile().getPackagePath();
        }
        return tci.getRuntimeTypeName() == null ? null : tci.getRuntimeTypeName().replace('.', '/') + ".java";
    }

    public static String getSourceMethodNameFor(TestCaseInfo tci, ProjectInfo project) {
        if (!tci.isResolved()) {
            tci.resolve(project);
        }
        return tci.getSourceMethodName();
    }

    public String toString() {
        String sourceMethodName = this.getSourceMethodName();
        if (this.getRuntimeMethodName().equals(sourceMethodName)) {
            return this.getRuntimeMethodName();
        }
        return this.getRuntimeMethodName() + "/" + this.getSourceMethodName();
    }
}

