/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.test.optimization.Messages;
import com.cenqua.clover.test.optimization.OptimizationSession;
import com.cenqua.clover.test.optimization.Optimizer;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.test.optimization.SnapshotPrinter;
import com.cenqua.clover.test.optimization.TestMethodCall;
import com.cenqua.clover.util.collections.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalSnapshotOptimizer
implements Optimizer {
    private final Snapshot snapshot;
    private final Clover2Registry registry;
    private final OptimizationOptions options;

    public static <E extends Optimizable> List<E> optimize(Collection<E> optimizables, OptimizationOptions options) throws CloverException {
        return new LocalSnapshotOptimizer(options).optimize(optimizables);
    }

    public static <E extends Optimizable> List<E> optimize(Collection<E> mandatoryOptimizables, Collection<E> optionalOptimizables, OptimizationOptions options) throws CloverException {
        return new LocalSnapshotOptimizer(options).optimize(mandatoryOptimizables, optionalOptimizables);
    }

    private LocalSnapshotOptimizer(Pair<Snapshot, Clover2Registry> snapshotAndReg, OptimizationOptions options) {
        this.snapshot = (Snapshot)snapshotAndReg.first;
        this.registry = (Clover2Registry)snapshotAndReg.second;
        this.options = options;
        if (options.isDebug()) {
            Snapshot.setDebug(options.isDebug());
            SnapshotPrinter.prettyPrint(this.snapshot, Logger.getInstance(), 4);
        }
    }

    public LocalSnapshotOptimizer(Snapshot snapshot, Clover2Registry registry, OptimizationOptions options) {
        this(Pair.of(snapshot, registry), options);
    }

    public LocalSnapshotOptimizer(OptimizationOptions options) {
        this(LocalSnapshotOptimizer.snapshotAndRegistryFor(options), options);
    }

    private static Pair<Snapshot, Clover2Registry> snapshotAndRegistryFor(OptimizationOptions options) {
        File snapshotFile = options.getSnapshotFile();
        File registryFile = options.getInitString() == null ? null : new File(options.getInitString());
        Snapshot snapshot = null;
        Clover2Registry registry = null;
        try {
            Snapshot snapshot2 = snapshot = snapshotFile == null ? null : Snapshot.loadFrom(snapshotFile);
            if (snapshot != null) {
                StringBuffer tooStaleReason = new StringBuffer();
                if (snapshot.isTooStale(options.getMaxCompilesBeforeStaleSnapshot(), tooStaleReason)) {
                    Logger.getInstance().info(tooStaleReason.toString());
                    snapshot.delete();
                    snapshot = null;
                } else {
                    Clover2Registry clover2Registry = registry = registryFile == null ? null : Clover2Registry.fromFile(registryFile);
                    if (registry == null) {
                        snapshot = null;
                        Logger.getInstance().info(Messages.noOptimizationBecauseNoRegistryFound(snapshotFile.getAbsolutePath()));
                    }
                }
            }
        }
        catch (CloverException e) {
            Logger.getInstance().info(Messages.noOptimizationBecauseOfException(e));
        }
        return Pair.of(snapshot, registry);
    }

    @Override
    public <E extends Optimizable> boolean include(E optimizable, OptimizationSession session) {
        return !this.optimize(Collections.singleton(optimizable)).isEmpty();
    }

    @Override
    public <E extends Optimizable> List<E> optimize(Collection<E> optimizables) {
        return this.optimize(optimizables, new OptimizationSession(this.options));
    }

    @Override
    public <E extends Optimizable> List<E> optimize(Collection<E> optimizables, OptimizationSession session) {
        return this.optimize(Collections.EMPTY_SET, optimizables, session);
    }

    @Override
    public <E extends Optimizable> List<E> optimize(Collection<E> mandatoryOptimizables, Collection<E> optionalOptimizables) {
        return this.optimize(mandatoryOptimizables, optionalOptimizables, new OptimizationSession(this.options));
    }

    @Override
    public <E extends Optimizable> List<E> optimize(Collection<E> mandatoryOptimizables, Collection<E> optionalOptimizables, OptimizationSession session) {
        List<Optimizable> result;
        int totalInputsSize = mandatoryOptimizables.size() + optionalOptimizables.size();
        session.incOriginalOptimizableCount(totalInputsSize);
        if (this.canOptimize()) {
            Set<TestMethodCall> testCases;
            result = new ArrayList<E>(totalInputsSize);
            HashMap<Optimizable, Set<TestMethodCall>> testMethods = new HashMap<Optimizable, Set<TestMethodCall>>(totalInputsSize);
            for (Optimizable optimizable : optionalOptimizables) {
                boolean included;
                testCases = this.lookupTestMethods(optimizable);
                long totalTestRunTime = 0L;
                if (testCases != null) {
                    testMethods.put(optimizable, testCases);
                    session.incFoundOptimizableCount(1);
                    totalTestRunTime = this.snapshot.calculateDurationOf(testCases);
                    session.incTotalTime(totalTestRunTime);
                }
                if (included = this.maybeIncludeOptimizable(optimizable, testCases, session)) {
                    Logger.getInstance().verbose(new StringBuffer().append("Including ").append(optimizable.getName()).append(" in optimized test run").toString());
                    result.add(optimizable);
                    continue;
                }
                session.incSavings(totalTestRunTime);
                Logger.getInstance().verbose(new StringBuffer().append("Excluding ").append(optimizable.getName()).append(" from optimized test run").toString());
            }
            this.logModifiedFiles(session.getOptimizedPaths());
            for (Optimizable optimizable : mandatoryOptimizables) {
                testCases = this.lookupTestMethods(optimizable);
                if (testCases != null) {
                    testMethods.put(optimizable, testCases);
                }
                Logger.getInstance().verbose(new StringBuffer().append("Including ").append(optimizable.getName()).append(" in optimized test run").toString());
                result.add(optimizable);
            }
            result = this.performReordering(result, testMethods, this.snapshot, session);
            session.incOptimizedOptimizableCount(result.size());
            session.afterOptimizaion(true);
        } else {
            result = new ArrayList(totalInputsSize);
            result.addAll(mandatoryOptimizables);
            result.addAll(optionalOptimizables);
            session.incOptimizedOptimizableCount(totalInputsSize);
            session.afterOptimizaion(false);
        }
        return result;
    }

    private void logModifiedFiles(Set<String> modifiedFiles) {
        if (this.options.isDebug()) {
            if (!modifiedFiles.isEmpty()) {
                Logger.getInstance().info("For the current test set, Clover detected the following source files were modified: ");
                for (String fileName : modifiedFiles) {
                    Logger.getInstance().info(new StringBuffer().append("\t").append(fileName).toString());
                }
            } else {
                Logger.getInstance().info("For the current test set, Clover detected no modified source files.");
            }
        }
    }

    @Override
    public boolean canOptimize() {
        return this.options.isEnabled() && this.registry != null && this.snapshot != null && !this.isTooStale();
    }

    public boolean isTooStale() {
        return this.snapshot != null && this.snapshot.isTooStale(this.options.getMaxCompilesBeforeStaleSnapshot());
    }

    public String cannotOptimizeCause() {
        ArrayList<String> causes = new ArrayList<String>();
        if (!this.options.isEnabled()) {
            causes.add("optimization disabled");
        }
        if (this.registry == null) {
            causes.add("registry file not set");
        }
        if (this.snapshot == null) {
            causes.add("no snapshot file");
        } else {
            StringBuffer reason;
            int max = this.options.getMaxCompilesBeforeStaleSnapshot();
            if (this.snapshot.isTooStale(max, reason = new StringBuffer())) {
                causes.add(reason.toString());
            }
        }
        return ((Object)causes).toString();
    }

    private boolean containsDirty(Set<TestMethodCall> tests, OptimizationSession session) {
        for (TestMethodCall test : tests) {
            if (!this.snapshot.getFailingTests().contains(test) && !this.snapshot.isTestAffectedByChanges(test, this.registry, session)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailed(Set<TestMethodCall> tests) {
        for (TestMethodCall test : tests) {
            if (!this.snapshot.getFailingTests().contains(test)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAffected(Set<TestMethodCall> tests, OptimizationSession session) {
        for (TestMethodCall test : tests) {
            if (!this.snapshot.isTestAffectedByChanges(test, this.registry, session)) continue;
            return true;
        }
        return false;
    }

    private boolean maybeIncludeOptimizable(Optimizable optimizable, Set<TestMethodCall> testsForOptimizable, OptimizationSession session) {
        if (testsForOptimizable != null) {
            if (this.options.isMinimize()) {
                if (this.options.isDebug()) {
                    boolean include;
                    boolean includesFailingTest = this.containsFailed(testsForOptimizable);
                    boolean isTestNeedingRerun = this.containsAffected(testsForOptimizable, session);
                    boolean bl = include = includesFailingTest || isTestNeedingRerun;
                    if (include) {
                        Logger.getInstance().debug(new StringBuffer().append("Including '").append(optimizable.getName()).append("' in the test run because it [previously failed / was affected by a code change] [").append(includesFailingTest).append(" / ").append(isTestNeedingRerun).append("]").toString());
                    } else {
                        Logger.getInstance().debug(new StringBuffer().append("Excluding '").append(optimizable.getName()).append("' in the test run because it neither previously failed nor was affected by a code change").toString());
                    }
                    return include;
                }
                return this.containsDirty(testsForOptimizable, session);
            }
            if (this.options.isDebug()) {
                Logger.getInstance().debug(new StringBuffer().append("Including '").append(optimizable.getName()).append("' in the test run because test minimization has been turned off.").toString());
            }
            return true;
        }
        if (this.options.isDebug()) {
            Logger.getInstance().info(new StringBuffer().append("Including '").append(optimizable.getName()).append("' in the test run because Clover cannot correlate it with previously executed test method.").toString());
        }
        return true;
    }

    private Set<TestMethodCall> lookupTestMethods(Optimizable optimizable) {
        String[] structuredPath = optimizable.getName().split("/");
        int pathCount = structuredPath.length;
        if (pathCount == 1) {
            return this.snapshot.lookupTests(structuredPath[0]);
        }
        Set<TestMethodCall> tests = null;
        StringBuffer buffer = new StringBuffer(optimizable.getName());
        for (int i = 0; i < pathCount && (tests = this.snapshot.lookupTests(buffer.toString())) == null; ++i) {
            if (i >= pathCount - 1) continue;
            buffer.delete(0, structuredPath[i].length() + 1);
        }
        return tests;
    }

    private <E extends Optimizable> List<E> performReordering(List<E> optimizables, Map<E, Set<TestMethodCall>> testsPerOptimizable, Snapshot snapshot, OptimizationSession session) {
        List<E> result = optimizables;
        if (optimizables.size() > 1) {
            if (this.options.isReorderFailfast()) {
                Logger.getInstance().verbose("Sorting optimized tests for fail-fast behaviour");
                result = this.sort(optimizables, testsPerOptimizable, snapshot, session);
                if (this.options.isDebug()) {
                    Logger.getInstance().debug(new StringBuffer().append("Final order for tests after failfast sorting =\n").append(result).toString());
                }
            } else if (this.options.isReorderRandomly()) {
                Logger.getInstance().verbose("Randomly shuffling optimized tests");
                Collections.shuffle(optimizables);
                if (this.options.isDebug()) {
                    Logger.getInstance().debug(new StringBuffer().append("Final order for tests after randomized sorting =\n").append(result).toString());
                }
            }
        } else {
            Logger.getInstance().debug("Test reordering not proceeding as there is only one test");
        }
        return result;
    }

    private <E extends Optimizable> List<E> sort(List<E> optimizables, Map<E, Set<TestMethodCall>> testsPerOptimizable, Snapshot snapshot, OptimizationSession session) {
        ArrayList sortedTests = new ArrayList(optimizables.size());
        for (Optimizable optimizable : optimizables) {
            Set<TestMethodCall> set = testsPerOptimizable.get(optimizable);
            sortedTests.add(set != null ? new TestSortEntry(this, optimizable, snapshot.calculateDurationOf(set), !this.containsFailed(set), this.containsAffected(set, session)) : new TestSortEntry(this, optimizable, Long.MIN_VALUE, true, true));
        }
        Collections.sort(sortedTests);
        ArrayList<Optimizable> sortedOptimizables = new ArrayList<Optimizable>(sortedTests.size());
        for (TestSortEntry testSortEntry : sortedTests) {
            sortedOptimizables.add(testSortEntry.optimizable);
        }
        return sortedOptimizables;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestSortEntry<E extends Optimizable>
    implements Comparable<TestSortEntry<E>> {
        private E optimizable;
        private long duration;
        private boolean succeeded;
        private boolean affectedByChanges;
        final /* synthetic */ LocalSnapshotOptimizer this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private TestSortEntry(E e, long succeeded, boolean bl, boolean bl2) {
            void affectedByChanges;
            void optimizable;
            this.this$0 = (LocalSnapshotOptimizer)l;
            this.optimizable = optimizable;
            this.duration = duration;
            this.succeeded = succeeded;
            this.affectedByChanges = affectedByChanges;
        }

        @Override
        public int compareTo(TestSortEntry<E> other) {
            if (!(this.succeeded ^ other.succeeded)) {
                if (!(this.affectedByChanges ^ other.affectedByChanges)) {
                    long duration = this.duration == -1L ? Integer.MAX_VALUE : this.duration;
                    long otherDuration = other.duration == -1L ? Integer.MAX_VALUE : other.duration;
                    return (int)(duration - otherDuration);
                }
                if (this.affectedByChanges && !other.affectedByChanges) {
                    return -1;
                }
                return 1;
            }
            if (!this.succeeded && other.succeeded) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return new StringBuffer().append("[test='").append(this.optimizable.getName()).append("', duration=").append(this.duration).append("ms, passed=").append(this.succeeded).append(", affectedByChanges=").append(this.affectedByChanges).append("]").toString();
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((TestSortEntry)x0);
        }
    }
}

