/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AbstractCloverTask;
import com.cenqua.clover.test.optimization.Snapshot;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class CloverCanOptimizeTests
extends AbstractCloverTask
implements Condition {
    private int fullRunEvery = 10;
    private String property;
    private String value = "true";
    private File snapshotFile;

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setFullRunEvery(int fullRunEvery) {
        this.fullRunEvery = fullRunEvery;
    }

    public int getFullRunEvery() {
        return this.fullRunEvery;
    }

    public void setSnapshotFile(File snapshotFile) {
        this.snapshotFile = snapshotFile;
    }

    public boolean eval() throws BuildException {
        Snapshot snapshot;
        this.init();
        boolean result = false;
        Snapshot snapshot2 = snapshot = this.snapshotFile == null ? Snapshot.loadFor(this.config.resolveInitString()) : Snapshot.loadFromFile(this.snapshotFile);
        if (snapshot == null) {
            Logger.getInstance().info("Clover can't optimize test runs for this build because the snapshot file " + (this.snapshotFile == null ? Snapshot.fileNameForInitString(this.config.resolveInitString()) : this.snapshotFile.getAbsolutePath()) + " was not found.");
        } else {
            StringBuffer reason = new StringBuffer();
            result = !snapshot.isTooStale(this.fullRunEvery, reason);
            Logger.getInstance().info(result ? "Clover can optimize test runs for this build." : reason.toString());
        }
        return result;
    }

    public boolean validate() {
        if (this.property == null) {
            throw new BuildException("property is required");
        }
        return true;
    }

    public void cloverExecute() {
        if (this.eval() && this.property != null) {
            this.getProject().setProperty(this.property, this.value);
        }
    }
}

