/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.pdf;

import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.FontFactory;
import clover.com.lowagie.text.Phrase;
import clover.com.lowagie.text.pdf.DefaultFontMapper;
import clover.com.lowagie.text.pdf.PdfContentByte;
import clover.com.lowagie.text.pdf.PdfPTable;
import clover.com.lowagie.text.pdf.PdfPTableEvent;
import clover.com.lowagie.text.pdf.PdfTemplate;
import clover.org.jfree.chart.JFreeChart;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.pdf.PDFColours;
import com.cenqua.clover.reporters.util.CloverChartFactory;
import com.cenqua.clover.reporters.util.HistoricalReportDescriptor;
import com.cenqua.clover.reporters.util.MetricsDiffSummary;
import com.cenqua.clover.util.Formatting;
import com.cenqua.clover.util.format.PDFFormatter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RenderingSupport {
    private static final PdfPTable SPACER = new PdfPTable(1);

    public static PdfPTable createLicenseWarningBar(String font, int points, PDFColours colours) {
        PdfPTable warnTab = new PdfPTable(1);
        warnTab.getDefaultCell().setBorder(0);
        warnTab.getDefaultCell().setPadding(5.0f);
        warnTab.setWidthPercentage(100.0f);
        String stmt = CloverLicenseInfo.OWNER_STMT + " ";
        stmt = !CloverLicenseInfo.EXPIRED ? stmt + CloverLicenseInfo.PRE_EXPIRY_STMT : stmt + CloverLicenseInfo.POST_EXPIRY_STMT + " " + CloverLicenseInfo.CONTACT_INFO_STMT;
        Phrase warning = PDFFormatter.format(stmt, font, points, colours.COL_LINK_TEXT);
        warnTab.addCell(warning);
        return warnTab;
    }

    public static PdfPTable getSpacerRow() {
        return SPACER;
    }

    public static PdfPTable createReportHeader(ProjectInfo hasmetrics, long ts, String title, String titleAnchor, PDFColours colours) throws DocumentException {
        return RenderingSupport.createReportHeader(hasmetrics, ts, title, titleAnchor, true, colours);
    }

    public static PdfPTable createReportHeader(PackageInfo hasmetrics, long ts, String title, String titleAnchor, PDFColours colours) throws DocumentException {
        return RenderingSupport.createReportHeader(hasmetrics, ts, title, titleAnchor, false, colours);
    }

    public static PdfPTable createCoverageDataTable(CloverReportConfig cfg, String col0Title, List items, PDFColours colours) throws DocumentException {
        boolean bw = colours == PDFColours.BW_COLOURS;
        PdfPTable stats = RenderingSupport.createCoverageDataHeader(col0Title, colours);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            HasMetrics item = (HasMetrics)it.next();
            BlockMetrics met = item.getMetrics();
            if (!cfg.getFormat().getShowEmpty() && met.getNumElements() == 0) continue;
            stats.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
            stats.getDefaultCell().setBorder(15);
            stats.getDefaultCell().setHorizontalAlignment(0);
            stats.getDefaultCell().setVerticalAlignment(5);
            String name = item.getName();
            if (name == null) {
                name = "Project";
            }
            stats.addCell(new Phrase(name, FontFactory.getFont("Helvetica", 10.0f)));
            stats.getDefaultCell().setHorizontalAlignment(1);
            stats.addCell(new Phrase(Formatting.getPercentStr(met.getPcCoveredBranches()), FontFactory.getFont("Helvetica", 10.0f)));
            stats.addCell(new Phrase(Formatting.getPercentStr(met.getPcCoveredStatements()), FontFactory.getFont("Helvetica", 10.0f)));
            stats.addCell(new Phrase(Formatting.getPercentStr(((ClassMetrics)met).getPcCoveredMethods()), FontFactory.getFont("Helvetica", 10.0f)));
            stats.getDefaultCell().setBorder(3);
            stats.addCell(new Phrase(Formatting.getPercentStr(met.getPcCoveredElements()), FontFactory.getFont("Helvetica", 10.0f, 1)));
            stats.getDefaultCell().setBorder(11);
            stats.addCell(RenderingSupport.createPCBar(met.getPcCoveredElements(), 10.0f, colours));
        }
        return stats;
    }

    public static PdfPTable createChart(Historical.Chart chartCfg, Map data, PDFColours colours) {
        PdfPTable coverage = new PdfPTable(1);
        coverage.setWidthPercentage(100.0f);
        coverage.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        coverage.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        coverage.getDefaultCell().setPaddingLeft(2.0f);
        Phrase headerPhrase = new Phrase(" ", FontFactory.getFont("Helvetica", 12.0f, 1));
        coverage.addCell(headerPhrase);
        coverage.getDefaultCell().setBackgroundColor(Color.white);
        PdfPTable chartTable = new PdfPTable(1);
        chartTable.setWidthPercentage(100.0f);
        JFreeChart graph = CloverChartFactory.createJFreeChart(chartCfg, data);
        GraphRenderer renderer = new GraphRenderer(graph);
        chartTable.setTableEvent(renderer);
        chartTable.getDefaultCell().setBorder(0);
        chartTable.getDefaultCell().setMinimumHeight(chartCfg.getHeight());
        chartTable.addCell("");
        coverage.addCell(chartTable);
        return coverage;
    }

    private static PdfPTable createHeaderStats(PackageMetrics metrics, PDFColours colours) throws DocumentException {
        String level = metrics.getType();
        PdfPTable projStats = new PdfPTable(5);
        projStats.setWidths(new int[]{30, 17, 18, 20, 15});
        projStats.getDefaultCell().setBorder(0);
        projStats.getDefaultCell().setHorizontalAlignment(2);
        projStats.addCell(new Phrase(level + " stats:", FontFactory.getFont("Helvetica", 10.0f, 1)));
        projStats.addCell(new Phrase("LOC:", FontFactory.getFont("Helvetica", 10.0f, 1)));
        projStats.addCell(new Phrase(Formatting.formatInt(metrics.getLineCount()), FontFactory.getFont("Helvetica", 10.0f)));
        projStats.addCell(new Phrase("Methods:", FontFactory.getFont("Helvetica", 10.0f, 1)));
        projStats.addCell(new Phrase(Formatting.formatInt(metrics.getNumMethods()), FontFactory.getFont("Helvetica", 10.0f)));
        projStats.addCell("");
        projStats.addCell(new Phrase("NCLOC:", FontFactory.getFont("Helvetica", 10.0f, 1)));
        projStats.addCell(new Phrase(Formatting.formatInt(metrics.getNcLineCount()), FontFactory.getFont("Helvetica", 10.0f)));
        projStats.addCell(new Phrase("Classes:", FontFactory.getFont("Helvetica", 10.0f, 1)));
        projStats.addCell(new Phrase(Formatting.formatInt(metrics.getNumClasses()), FontFactory.getFont("Helvetica", 10.0f)));
        projStats.addCell("");
        projStats.addCell(new Phrase("Files:", FontFactory.getFont("Helvetica", 10.0f, 1)));
        projStats.addCell(new Phrase(Formatting.formatInt(metrics.getNumFiles()), FontFactory.getFont("Helvetica", 10.0f)));
        if (metrics instanceof ProjectMetrics) {
            projStats.addCell(new Phrase("Pkgs:", FontFactory.getFont("Helvetica", 10.0f, 1)));
            projStats.addCell(new Phrase(Formatting.formatInt(((ProjectMetrics)metrics).getNumPackages()), FontFactory.getFont("Helvetica", 10.0f)));
        } else {
            projStats.addCell("");
            projStats.addCell("");
        }
        return projStats;
    }

    public static PdfPTable createReportHeader(HasMetrics hasmetrics, long timestamp, String title, boolean isProject, PDFColours colours) throws DocumentException {
        return RenderingSupport.createReportHeader(hasmetrics, timestamp, title, null, isProject, colours);
    }

    public static PdfPTable createReportHeader(HasMetrics hasmetrics, long timestamp, String title, String titleAnchor, boolean isProject, PDFColours colours) throws DocumentException {
        PdfPTable titlebar = new PdfPTable(2);
        BlockMetrics metrics = hasmetrics.getMetrics();
        titlebar.setWidths(new int[]{50, 50});
        titlebar.setWidthPercentage(100.0f);
        titlebar.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        titlebar.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        titlebar.getDefaultCell().setPaddingLeft(2.0f);
        titlebar.getDefaultCell().setLeading(2.0f, 0.9f);
        Phrase titlePhrase = new Phrase(14.0f, "Clover Coverage Report", FontFactory.getFont("Helvetica", 14.0f, 1));
        if (title != null && title.trim().length() > 0) {
            if (titleAnchor != null && titleAnchor.trim().length() > 0) {
                titlePhrase.add(new Chunk("\n" + title, FontFactory.getFont("Helvetica", 12.0f, 1, colours.COL_LINK_TEXT)).setAnchor(titleAnchor));
            } else {
                titlePhrase.add(new Phrase("\n" + title, FontFactory.getFont("Helvetica", 12.0f, 1)));
            }
        }
        titlePhrase.add(new Phrase("\nCoverage timestamp: ", FontFactory.getFont("Helvetica", 10.0f, 1)));
        titlePhrase.add(new Phrase(Formatting.formatDate(new Date(timestamp)), FontFactory.getFont("Helvetica", 10.0f)));
        titlebar.addCell(titlePhrase);
        titlebar.addCell(RenderingSupport.createHeaderStats((PackageMetrics)metrics, colours));
        return titlebar;
    }

    public static PdfPTable createHistoricalPageHeader(String title, PDFColours colours) throws DocumentException {
        return RenderingSupport.createHistoricalPageHeader(title, null, colours);
    }

    public static PdfPTable createHistoricalPageHeader(String title, String titleAnchor, PDFColours colours) throws DocumentException {
        PdfPTable titlebar = new PdfPTable(1);
        titlebar.setWidths(new int[]{100});
        titlebar.setWidthPercentage(100.0f);
        titlebar.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        titlebar.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        PdfPTable leftTab = new PdfPTable(1);
        leftTab.setWidths(new int[]{100});
        leftTab.getDefaultCell().setBorder(0);
        leftTab.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        leftTab.getDefaultCell().setPaddingLeft(2.0f);
        leftTab.getDefaultCell().setLeading(2.0f, 0.9f);
        leftTab.getDefaultCell().setColspan(1);
        Phrase titlePhrase = new Phrase(14.0f, "Historical Coverage Report", FontFactory.getFont("Helvetica", 14.0f, 1));
        if (title != null && title.trim().length() > 0) {
            if (titleAnchor != null && titleAnchor.trim().length() > 0) {
                titlePhrase.add(new Chunk("\n" + title, FontFactory.getFont("Helvetica", 12.0f, 1, colours.COL_LINK_TEXT)).setAnchor(titleAnchor));
            } else {
                titlePhrase.add(new Phrase("\n" + title, FontFactory.getFont("Helvetica", 12.0f, 1)));
            }
        }
        leftTab.addCell(titlePhrase);
        titlebar.addCell(leftTab);
        return titlebar;
    }

    public static PdfPTable createHistoricalReportHeader(HasMetrics hasmetrics, long ts1, long ts2, String title, String titleAnchor, boolean isProject, PDFColours colours) throws DocumentException {
        PdfPTable titlebar = new PdfPTable(2);
        BlockMetrics metrics = hasmetrics.getMetrics();
        titlebar.setWidths(new int[]{50, 50});
        titlebar.setWidthPercentage(100.0f);
        titlebar.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        titlebar.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        PdfPTable leftTab = new PdfPTable(2);
        leftTab.setWidths(new int[]{15, 85});
        leftTab.getDefaultCell().setBorder(0);
        leftTab.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        leftTab.getDefaultCell().setPaddingLeft(2.0f);
        leftTab.getDefaultCell().setLeading(2.0f, 0.9f);
        leftTab.getDefaultCell().setColspan(2);
        Phrase titlePhrase = new Phrase(14.0f, "Historical Coverage Report", FontFactory.getFont("Helvetica", 14.0f, 1));
        if (title != null && title.trim().length() > 0) {
            if (titleAnchor != null && titleAnchor.trim().length() > 0) {
                titlePhrase.add(new Chunk("\n" + title, FontFactory.getFont("Helvetica", 12.0f, 1, colours.COL_LINK_TEXT)).setAnchor(titleAnchor));
            } else {
                titlePhrase.add(new Phrase("\n" + title, FontFactory.getFont("Helvetica", 12.0f, 1)));
            }
        }
        leftTab.addCell(titlePhrase);
        leftTab.getDefaultCell().setColspan(1);
        leftTab.getDefaultCell().setHorizontalAlignment(2);
        leftTab.addCell(new Phrase("From: ", FontFactory.getFont("Helvetica", 10.0f, 1)));
        leftTab.getDefaultCell().setHorizontalAlignment(0);
        leftTab.addCell(new Phrase(Formatting.formatDate(new Date(ts1)), FontFactory.getFont("Helvetica", 10.0f)));
        leftTab.getDefaultCell().setHorizontalAlignment(2);
        leftTab.addCell(new Phrase("To: ", FontFactory.getFont("Helvetica", 10.0f, 1)));
        leftTab.getDefaultCell().setHorizontalAlignment(0);
        leftTab.addCell(new Phrase(Formatting.formatDate(new Date(ts2)), FontFactory.getFont("Helvetica", 10.0f)));
        titlebar.addCell(leftTab);
        titlebar.addCell(RenderingSupport.createHeaderStats((PackageMetrics)metrics, colours));
        return titlebar;
    }

    public static PdfPTable createMoversTable(HistoricalReportDescriptor.MoversDescriptor moversDesc, PDFColours colours) throws DocumentException {
        float pcnow;
        float pcdiff;
        MetricsDiffSummary diff;
        Iterator it;
        List gainers = moversDesc.getGainers();
        List losers = moversDesc.getLosers();
        String requestedPeriod = moversDesc.getRequestedInterval().toSensibleString();
        String period = moversDesc.getActualInterval().toSensibleString();
        Percentage threshold = moversDesc.getThreshold();
        int range = moversDesc.getRange();
        PdfPTable movers = new PdfPTable(2);
        movers.setWidthPercentage(100.0f);
        movers.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        movers.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        movers.setWidths(new int[]{50, 50});
        movers.getDefaultCell().setColspan(2);
        Phrase title = new Phrase("Top movers over the last " + requestedPeriod, FontFactory.getFont("Helvetica", 12.0f, 1));
        title.add(new Phrase(" (Actual Interval: " + period + ", Range: " + range + ", Threshold: +/-" + threshold + ")", FontFactory.getFont("Helvetica", 8.0f, 2)));
        movers.addCell(title);
        movers.getDefaultCell().setBackgroundColor(Color.white);
        if (gainers.size() == 0 && losers.size() == 0) {
            movers.getDefaultCell().setColspan(2);
            movers.addCell(new Phrase("No changes in coverage are outside the specified threshold (+/-" + threshold + ")", FontFactory.getFont("Helvetica", 10.0f, 2)));
            return movers;
        }
        movers.getDefaultCell().setColspan(1);
        if (gainers.size() == 0) {
            movers.getDefaultCell().setColspan(2);
            movers.addCell(new Phrase("No classes have gained coverage over threshold (+" + threshold + ")", FontFactory.getFont("Helvetica", 10.0f, 2)));
        } else {
            it = gainers.iterator();
            while (it.hasNext()) {
                diff = (MetricsDiffSummary)it.next();
                pcdiff = diff.getPcDiff();
                pcnow = diff.getPc2float();
                movers.addCell(new Phrase(diff.getName(), FontFactory.getFont("Helvetica", 8.0f)));
                movers.addCell(RenderingSupport.createPCDiffBar(pcdiff, pcnow, 8.0f, colours));
            }
        }
        movers.getDefaultCell().setColspan(1);
        if (losers.size() == 0) {
            movers.getDefaultCell().setColspan(2);
            movers.addCell(new Phrase("No classes have lost coverage over threshold (-" + threshold + ")", FontFactory.getFont("Helvetica", 10.0f, 2)));
        } else {
            it = losers.iterator();
            while (it.hasNext()) {
                diff = (MetricsDiffSummary)it.next();
                pcdiff = diff.getPcDiff();
                pcnow = diff.getPc2float();
                movers.addCell(RenderingSupport.createPCDiffBar(pcdiff, pcnow, 8.0f, colours));
                movers.addCell(new Phrase(diff.getName(), FontFactory.getFont("Helvetica", 8.0f)));
            }
        }
        return movers;
    }

    public static PdfPTable createAddedTable(HistoricalReportDescriptor.AddedDescriptor addedDesc, PDFColours colours) throws DocumentException {
        List gainers = addedDesc.getGainers();
        List losers = addedDesc.getLosers();
        String requestedPeriod = addedDesc.getRequestedInterval().toSensibleString();
        String period = addedDesc.getActualInterval().toSensibleString();
        Percentage threshold = addedDesc.getThreshold();
        int range = addedDesc.getRange();
        PdfPTable movers = new PdfPTable(2);
        movers.setWidthPercentage(100.0f);
        movers.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        movers.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        movers.setWidths(new int[]{50, 50});
        movers.getDefaultCell().setColspan(2);
        Phrase title = new Phrase("Classes added over the last " + requestedPeriod, FontFactory.getFont("Helvetica", 12.0f, 1));
        title.add(new Phrase(" (Actual Interval: " + period + ", Range: " + range + ")", FontFactory.getFont("Helvetica", 8.0f, 2)));
        movers.addCell(title);
        movers.getDefaultCell().setBackgroundColor(Color.white);
        if (gainers.size() == 0) {
            movers.getDefaultCell().setColspan(2);
            movers.addCell(new Phrase("No new classes", FontFactory.getFont("Helvetica", 10.0f, 2)));
            return movers;
        }
        movers.getDefaultCell().setColspan(1);
        Iterator it = gainers.iterator();
        while (it.hasNext()) {
            MetricsDiffSummary diff = (MetricsDiffSummary)it.next();
            float pcdiff = diff.getPcDiff();
            float pcnow = diff.getPc2float();
            movers.addCell(new Phrase(diff.getName(), FontFactory.getFont("Helvetica", 8.0f)));
            movers.addCell(RenderingSupport.createPCDiffBar(pcdiff, pcnow, 8.0f, colours));
        }
        movers.getDefaultCell().setColspan(1);
        return movers;
    }

    private static PdfPTable createPCDiffBar(float pcdiff, float pcnow, float height, PDFColours colours) throws DocumentException {
        PdfPTable pcbar = new PdfPTable(2);
        pcbar.getDefaultCell().setBorder(0);
        pcdiff /= 100.0f;
        if (pcdiff < 0.0f) {
            PCBarRenderer renderer = new PCBarRenderer(1, 0.0f, height, colours, 0.0f);
            pcbar.setTableEvent(renderer);
            pcbar.setWidths(new float[]{20.0f + 80.0f * (1.0f - Math.abs(pcdiff)), 80.0f * Math.abs(pcdiff)});
            pcbar.getDefaultCell().setHorizontalAlignment(2);
            pcbar.addCell(new Phrase("(" + Formatting.getPercentStr(pcnow) + ") " + Formatting.format1d(pcdiff * 100.0f), FontFactory.getFont("Helvetica", height)));
            pcbar.addCell("");
        } else {
            PCBarRenderer renderer = new PCBarRenderer(0, 100.0f, height, colours, 0.0f);
            pcbar.setTableEvent(renderer);
            pcbar.setWidths(new float[]{80.0f * Math.abs(pcdiff), 20.0f + 80.0f * (1.0f - pcdiff)});
            pcbar.getDefaultCell().setHorizontalAlignment(0);
            pcbar.addCell("");
            pcbar.addCell(new Phrase("+" + Formatting.format1d(pcdiff * 100.0f) + " (" + Formatting.getPercentStr(pcnow) + ")", FontFactory.getFont("Helvetica", height)));
        }
        return pcbar;
    }

    private static PdfPTable createPCBar(float pc, float height, PDFColours colours) {
        return RenderingSupport.createPCBar(pc, height, colours, 0.01f);
    }

    private static PdfPTable createPCBar(float pc, float height, PDFColours colours, float padx) {
        PdfPTable pcbar = new PdfPTable(1);
        PCBarRenderer renderer = new PCBarRenderer(pc, height, colours, padx);
        pcbar.setTableEvent(renderer);
        pcbar.getDefaultCell().setBorder(0);
        pcbar.addCell("");
        return pcbar;
    }

    private static PdfPTable createCoverageDataHeader(String col0Title, PDFColours colours) throws DocumentException {
        PdfPTable header = new PdfPTable(6);
        header.setWidthPercentage(100.0f);
        header.getDefaultCell().setBorderColor(colours.COL_TABLE_BORDER);
        header.getDefaultCell().setBackgroundColor(colours.COL_HEADER_BG);
        header.setWidths(new int[]{50, 10, 10, 10, 7, 13});
        header.addCell(new Phrase(col0Title, FontFactory.getFont("Helvetica", 10.0f, 1)));
        header.getDefaultCell().setHorizontalAlignment(1);
        header.addCell(new Phrase("Branch", FontFactory.getFont("Helvetica", 10.0f, 1)));
        header.addCell(new Phrase("Stmt", FontFactory.getFont("Helvetica", 10.0f, 1)));
        header.addCell(new Phrase("Method", FontFactory.getFont("Helvetica", 10.0f, 1)));
        header.getDefaultCell().setColspan(2);
        header.getDefaultCell().setHorizontalAlignment(0);
        header.addCell(new Phrase("Total", FontFactory.getFont("Helvetica", 10.0f, 1)));
        header.getDefaultCell().setColspan(1);
        header.getDefaultCell().setBackgroundColor(Color.white);
        return header;
    }

    static {
        SPACER.getDefaultCell().setBorder(0);
        SPACER.setWidthPercentage(100.0f);
        SPACER.addCell(" ");
    }

    static class PCBarRenderer
    implements PdfPTableEvent {
        private float coveredpc;
        private float height;
        private float padx;
        private PDFColours colours;
        private int column = 0;

        public PCBarRenderer(float coveredpc, float height, PDFColours colours, float padx) {
            this(0, coveredpc, height, colours, padx);
        }

        public PCBarRenderer(int column, float coveredpc, float height, PDFColours colours, float padx) {
            this.column = column;
            this.coveredpc = coveredpc > 1.0f ? 1.0f : coveredpc;
            this.height = height - 2.0f;
            this.colours = colours;
            this.padx = padx;
        }

        public void tableLayout(PdfPTable table, float[][] width, float[] heights, int headerRows, int rowStart, PdfContentByte[] canvases) {
            float[] widths = width[0];
            PdfContentByte cb = canvases[3];
            cb.saveState();
            cb.setLineWidth(0.5f);
            float hmargin = (widths[this.column + 1] - widths[this.column]) * this.padx;
            float barx = widths[this.column] + hmargin;
            float bary = (heights[0] + heights[1] - this.height) / 2.0f;
            float barw = widths[this.column + 1] - widths[this.column] - 2.0f * hmargin;
            float barh = this.height;
            float coveredw = barw * this.coveredpc;
            if (this.coveredpc >= 0.0f) {
                cb.setColorFill(this.colours.COL_BAR_UNCOVERED);
                cb.rectangle(barx, bary, barw, barh);
                cb.fill();
                cb.setColorFill(this.colours.COL_BAR_COVERED);
                cb.rectangle(barx, bary, coveredw, barh);
                cb.fill();
                cb.setColorStroke(this.colours.COL_BAR_BORDER);
                cb.rectangle(barx, bary, coveredw, barh);
                cb.stroke();
            } else {
                cb.setColorFill(this.colours.COL_BAR_NA);
                cb.rectangle(barx, bary, barw, barh);
                cb.fill();
            }
            cb.setColorStroke(this.colours.COL_BAR_BORDER);
            cb.rectangle(barx, bary, barw, barh);
            cb.stroke();
            cb.restoreState();
        }
    }

    static class GraphRenderer
    implements PdfPTableEvent {
        private JFreeChart graph;

        public GraphRenderer(JFreeChart graph) {
            this.graph = graph;
        }

        public void tableLayout(PdfPTable table, float[][] width, float[] heights, int headerRows, int rowStart, PdfContentByte[] canvases) {
            float[] widths = width[0];
            PdfContentByte cb = canvases[3];
            float w = widths[1] - widths[0];
            float h = heights[0] - heights[1];
            float x = widths[0];
            float y = heights[1];
            cb.saveState();
            PdfTemplate tp = cb.createTemplate(w, h);
            tp.setWidth(w);
            tp.setHeight(h);
            Graphics2D g2 = tp.createGraphics(w, h, new DefaultFontMapper());
            this.graph.draw(g2, new Rectangle2D.Float(0.0f, 0.0f, (int)w, (int)h));
            g2.dispose();
            cb.addTemplate(tp, x, y);
            cb.restoreState();
        }
    }
}

