/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html.source;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import cloverantlr.TokenStreamException;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import com.atlassian.clover.spi.reporters.html.source.SourceRenderer;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupportImpl;
import com.cenqua.clover.reporters.html.JSONObjectFactory;
import com.cenqua.clover.reporters.html.source.SourceRendererManager;
import com.cenqua.clover.util.ChecksummingReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceRenderHelper {
    private CloverDatabase database;
    private CoverageDataProvider coverageProvider;
    private Current report;
    private HtmlRenderingSupportImpl renderingHelper;
    private boolean outOfDate;

    public SourceRenderHelper(CloverDatabase database, Current report, HtmlRenderingSupportImpl renderingHelper) {
        this.database = database;
        this.coverageProvider = database.getFullModel().getDataProvider();
        this.report = report;
        this.renderingHelper = renderingHelper;
    }

    public void insertLineInfosForFile(FileInfo fileInfo, VelocityContext context, ContextSet contextSet, String emptyChar, List[] testLineInfo) throws TokenStreamException {
        try {
            LineRenderInfo[] renderInfo = this.gatherSrcRenderInfo(context, fileInfo, contextSet, emptyChar, testLineInfo);
            context.put("renderInfo", renderInfo);
            context.put("jsonSrcFileLines", JSONObjectFactory.getJSONSrcFileLines(renderInfo, fileInfo.getName()));
            if (this.outOfDate) {
                this.addWarning(context, "The source file used to generate this report was changed after Clover generated coverage information. The coverage reported may not match the source lines. You should regenerate the coverage information and the report to ensure the files are in sync.");
                Logger.getInstance().warn(new StringBuffer().append("Source file ").append(fileInfo.getPhysicalFile()).append(" has changed since coverage information was").append(" generated").toString());
            }
        }
        catch (FileNotFoundException e) {
            Logger.getInstance().error(e);
            this.putErrorMessage(context, new StringBuffer().append("Clover could not read the source file \"").append(fileInfo.getPhysicalFile().getAbsolutePath()).append("\"").toString());
        }
        catch (Exception e) {
            Logger.getInstance().error(e);
            this.putErrorMessage(context, "Clover encountered a problem rendering the source for this file.");
        }
    }

    private void putErrorMessage(VelocityContext context, String message) {
        context.put("errormsg", message);
    }

    private void addWarning(VelocityContext context, String message) {
        ArrayList<String> warningMessages = (ArrayList<String>)context.get("warningMessages");
        if (warningMessages == null) {
            warningMessages = new ArrayList<String>();
        }
        warningMessages.add(message);
        context.put("warningMessages", warningMessages);
    }

    public LineRenderInfo[] gatherSrcRenderInfo(VelocityContext vc, FileInfo finfo, ContextSet contextSet, String emptyCoverageChar, List[] testLineInfo) throws Exception {
        ChecksummingReader csr;
        finfo.setDataProvider(this.coverageProvider);
        int lineCount = finfo.getLineCount();
        ArrayList<LineRenderInfo> renderedLines = new ArrayList<LineRenderInfo>(lineCount);
        String spaceChar = this.report.getFormat().getSpaceChar();
        if (spaceChar == null || spaceChar.length() == 0) {
            spaceChar = " ";
        }
        String tabStr = "";
        for (int j = 0; j < this.report.getFormat().getTabWidth(); ++j) {
            tabStr = new StringBuffer().append(tabStr).append(spaceChar).toString();
        }
        try {
            SourceRenderer renderer = SourceRendererManager.getRendererForFileExtension(this.extensionOf(finfo.getName()));
            if (renderer == null) {
                Logger.getInstance().debug(new StringBuffer().append("No renderer registered for files with extension \"").append(this.extensionOf(finfo.getName())).append("\". Using plaintext renderer for file ").append(finfo.getName()).toString());
                renderer = SourceRendererManager.getPlaintextRenderer();
            } else {
                Logger.getInstance().debug(new StringBuffer().append("Found source renderer ").append(renderer.getClass().getName()).append(" for file ").append(finfo.getName()).toString());
            }
            csr = this.render(finfo, renderedLines, emptyCoverageChar, tabStr, spaceChar, renderer);
        }
        catch (Throwable t) {
            Logger.getInstance().error(new StringBuffer().append("Failed to render syntax highlights for ").append(finfo.getPhysicalFile().getAbsolutePath()).append(": ").append(t.getMessage()).toString(), t);
            this.putErrorMessage(vc, "Clover encountered a problem rendering the source for this file. Syntax highlighting has been disabled.");
            renderedLines.clear();
            csr = this.render(finfo, renderedLines, emptyCoverageChar, tabStr, spaceChar, SourceRendererManager.getPlaintextRenderer());
        }
        LineInfo[] lines = finfo.getLineInfo(renderedLines.size() + 1);
        for (int i = 0; i < renderedLines.size(); ++i) {
            List testsForLine;
            LineInfo linfo;
            String ccstr;
            int headlineHits;
            String msg;
            ContextSet filteredCtx;
            boolean hilightBad;
            boolean hilightInfo;
            boolean hasSomeCoverage;
            block28: {
                hasSomeCoverage = false;
                hilightInfo = false;
                hilightBad = false;
                filteredCtx = null;
                msg = "";
                headlineHits = -1;
                ccstr = emptyCoverageChar;
                linfo = lines[i + 1];
                if (linfo != null) {
                    List<ElementInfo> lineElements = linfo.getColumnOrderedElementInfos();
                    for (ElementInfo lineElement : lineElements) {
                        if (filteredCtx != null || lineElement.isFiltered(contextSet)) {
                            filteredCtx = lineElement.getContext();
                            break block28;
                        }
                        if (lineElement.getHitCount() <= 0) continue;
                        hasSomeCoverage = true;
                        break;
                    }
                    for (ElementInfo lineElement : lineElements) {
                        String[] messages;
                        if (this.noHits(lineElement)) {
                            messages = this.calcCoverageMsg(lineElement, emptyCoverageChar);
                            msg = messages[0];
                            ccstr = messages[1];
                            headlineHits = this.hitCounts(lineElement);
                            hilightBad = true;
                            break;
                        }
                        messages = this.calcCoverageMsg(lineElement, emptyCoverageChar);
                        msg = messages[0];
                        ccstr = messages[1];
                        headlineHits = this.hitCounts(lineElement);
                    }
                }
            }
            if (headlineHits >= 0) {
                hilightInfo = true;
                if (ccstr.equals(emptyCoverageChar) && filteredCtx == null) {
                    ccstr = new StringBuffer().append("").append(headlineHits).toString();
                }
            }
            if (renderedLines.size() <= i || renderedLines.get(i) == null) {
                renderedLines.add(new LineRenderInfo(emptyCoverageChar));
            }
            LineRenderInfo thisLine = (LineRenderInfo)renderedLines.get(i);
            if (linfo != null && linfo.hasClassStarts()) {
                thisLine.setClassStart(linfo.getClassStarts()[0]);
            }
            if (linfo != null && linfo.hasMethodStarts()) {
                thisLine.setMethodStart(linfo.getMethodStarts()[0]);
            }
            if (linfo != null && linfo.hasFailStackEntries()) {
                thisLine.setFailedStackEntries(linfo.getFailStackEntries());
            }
            boolean classStart = thisLine.getClassStart() != null;
            String hitClass = "missedByTest";
            List list = testsForLine = testLineInfo == null || i + 1 >= testLineInfo.length ? null : testLineInfo[i + 1];
            if (testsForLine != null) {
                for (TestCaseInfo tci : testsForLine) {
                    if (!tci.isSuccess()) {
                        hitClass = "hitByFailedTest";
                        continue;
                    }
                    hitClass = "hitByTest";
                    break;
                }
            }
            if (filteredCtx != null) {
                thisLine.setLineNumberCSS("lineCount Filtered");
                thisLine.setCoverageCountCSS("coverageCount Filtered");
                thisLine.setTestHitCSS("missedByTest");
                thisLine.setSourceCSS("srcLineFiltered");
                thisLine.setFiltered(true);
                filteredCtx = filteredCtx.and(contextSet);
                String contextString = this.database.getContextStore().getContextsAsString(filteredCtx);
                msg = new StringBuffer().append("Filtered by: ").append(this.renderingHelper.htmlEscapeStr(contextString)).toString();
            } else if (hilightBad) {
                thisLine.setLineNumberCSS(new StringBuffer().append("lineCount ").append(hasSomeCoverage ? "Good" : "Bad").toString());
                thisLine.setCoverageCountCSS("coverageCount Bad");
                thisLine.setSourceCSS("srcLineHilight");
                thisLine.setTestHitCSS(hitClass);
            } else if (hilightInfo) {
                thisLine.setLineNumberCSS("lineCount Good");
                thisLine.setCoverageCountCSS("coverageCount Good");
                thisLine.setSourceCSS("srcLine");
                thisLine.setTestHitCSS(hitClass);
            } else {
                thisLine.setLineNumberCSS("lineCount NoHilight");
                thisLine.setCoverageCountCSS("coverageCount NoHilight");
                thisLine.setSourceCSS("srcLine");
            }
            if (this.outOfDate) {
                thisLine.setLineNumberCSS("lineWarning");
            }
            thisLine.setHilight(hilightInfo && filteredCtx == null);
            thisLine.setCoverageStr(ccstr);
            thisLine.setMsg(msg);
            thisLine.setTestHits(testsForLine != null ? testsForLine : Collections.EMPTY_LIST);
        }
        this.outOfDate = csr.getChecksum() != finfo.getChecksum();
        return renderedLines.toArray(new LineRenderInfo[renderedLines.size()]);
    }

    private String[] calcCoverageMsg(ElementInfo lineElement, String emptyCoverageChar) {
        if (lineElement instanceof BranchInfo && !((BranchInfo)lineElement).isInstrumented()) {
            return new String[]{new StringBuffer().append(SourceRenderHelper.getRegionStartStr(lineElement)).append("coverage not measured due to assignment in expression.").toString(), "?"};
        }
        return new String[]{lineElement.getConstruct().calcCoverageMsg(lineElement, lineElement.getHitCount(), lineElement instanceof BranchInfo ? ((BranchInfo)lineElement).getFalseHitCount() : 0, Locale.US), emptyCoverageChar};
    }

    private boolean noHits(ElementInfo lineElement) {
        return lineElement instanceof BranchInfo ? ((BranchInfo)lineElement).getTrueHitCount() == 0 || ((BranchInfo)lineElement).getFalseHitCount() == 0 : lineElement.getHitCount() == 0;
    }

    private int hitCounts(ElementInfo lineElement) {
        if (lineElement instanceof BranchInfo) {
            int tc = ((BranchInfo)lineElement).getTrueHitCount();
            int fc = ((BranchInfo)lineElement).getFalseHitCount();
            int hits = tc == Integer.MAX_VALUE || fc == Integer.MAX_VALUE ? Integer.MAX_VALUE : tc + fc;
            return hits < 0 ? Integer.MAX_VALUE : hits;
        }
        return lineElement.getHitCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChecksummingReader render(FileInfo finfo, List<LineRenderInfo> renderedLines, String emptyCoverageMsg, String tabString, String spaceString, SourceRenderer renderer) throws Exception {
        Logger.getInstance().debug(new StringBuffer().append("Rendering ").append(finfo.getName()).append(" with renderer ").append(renderer.getClass().getName()).toString());
        ChecksummingReader csr = SourceRenderHelper.getChecksummingReader(finfo);
        try {
            renderer.render(renderedLines, csr, finfo, this.renderingHelper, emptyCoverageMsg, tabString, spaceString);
        }
        finally {
            csr.close();
        }
        return csr;
    }

    private String extensionOf(String path) {
        return path.substring(Math.max(0, path.lastIndexOf(46)), path.length());
    }

    public static List<String> getSrcLines(FileInfo finfo) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(finfo.getSourceReader());
        ArrayList<String> srclines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            srclines.add(line);
        }
        return srclines;
    }

    private static ChecksummingReader getChecksummingReader(FileInfo finfo) throws FileNotFoundException, UnsupportedEncodingException {
        return new ChecksummingReader(finfo.getSourceReader());
    }

    public static String getRegionStartStr(SourceInfo region) {
        return _String.format("Line %d, Col %d: ", new Object[]{_Integer.valueOf(region.getStartLine()), _Integer.valueOf(region.getStartColumn())});
    }
}

