/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import cloverantlr.TokenStreamException;
import com.atlassian.clover.api.registry.SourceInfo;
import com.cenqua.clover.BitSetCoverageProvider;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupportImpl;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.JSONObjectFactory;
import com.cenqua.clover.reporters.html.source.SourceRenderHelper;
import com.cenqua.clover.reporters.json.JSONException;
import com.cenqua.clover.reporters.util.CloverChartFactory;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderFileAction
implements Callable {
    protected static ThreadLocal<List<Column>> columnsTL;
    protected static ThreadLocal<ContextSet> contextSetTL;
    private static final Comparator TEST_METRICS_COMPARATOR;
    protected final FileInfo fileInfo;
    protected final HtmlRenderingSupportImpl renderingHelper;
    protected final Current report;
    protected final VelocityContext velocity;
    protected final CloverDatabase database;
    protected final ProjectInfo fullModel;
    protected final Map<Integer, CloverChartFactory.ChartInfo> charts;
    protected List<TestCaseInfo>[] testLineInfo;

    public RenderFileAction(FileInfo fileInfo, HtmlRenderingSupportImpl renderingHelper, Current report, VelocityContext velocity, CloverDatabase database, ProjectInfo fullModel, Map<Integer, CloverChartFactory.ChartInfo> charts) {
        this.fileInfo = fileInfo;
        this.renderingHelper = renderingHelper;
        this.report = report;
        this.velocity = velocity;
        this.database = database;
        this.fullModel = fullModel;
        this.charts = charts;
    }

    public static void initThreadLocals() {
        columnsTL = new ThreadLocal();
        contextSetTL = new ThreadLocal();
    }

    public static void resetThreadLocals() {
        columnsTL = null;
        contextSetTL = null;
    }

    @Override
    public Object call() throws Exception {
        if (columnsTL.get() == null) {
            columnsTL.set(this.report.getColumns().getMethodColumnsCopy());
        }
        if (contextSetTL.get() == null) {
            contextSetTL.set(this.database.getContextSet(this.report.getFormat().getFilter()));
        }
        HtmlReportUtil.addColumnsToContext(this.velocity, columnsTL.get(), this.fileInfo, this.fileInfo.getClasses());
        this.render();
        return null;
    }

    public void render() throws Exception {
        String srcname = this.fileInfo.getName();
        String basename = new File(srcname).getName();
        String outname = RenderFileAction.createOutFileName(basename);
        File outfile = CloverUtils.createOutFile(this.fileInfo, outname, this.report.getOutFile());
        String jsonOutFilename = new StringBuffer().append(RenderFileAction.createOutFileBaseName(basename)).append("js").toString();
        this.velocity.put("basename", basename);
        this.velocity.put("currentPageURL", outname);
        this.velocity.put("jsonFilename", jsonOutFilename);
        try {
            this.insertLineInfos(this.insertSrcFileProperties(), this.testLineInfo);
        }
        catch (Exception e) {
            Logger.getInstance().error(new StringBuffer().append("Invalid Java source found or Clover failed to parse it: ").append(this.fileInfo.getPhysicalFile().getAbsolutePath()).toString());
            this.velocity.put("filename", this.fileInfo.getPhysicalFile().getAbsolutePath());
            this.velocity.put("message", e.getMessage());
            List<String> srclines = SourceRenderHelper.getSrcLines(this.fileInfo);
            this.velocity.put("srclines", srclines);
            HtmlReportUtil.mergeTemplateToFile(outfile, this.velocity, "html_res/src-file-error.vm");
            return;
        }
        this.velocity.put("chartInfo", CloverChartFactory.getChartForFile(this.fileInfo, this.charts));
        HtmlReportUtil.mergeTemplateToFile(outfile, this.velocity, "html_res/src-file.vm");
        HtmlReportUtil.mergeTemplateToFile(CloverUtils.createOutFile(this.fileInfo, jsonOutFilename, this.report.getOutFile()), this.velocity, "html_res/src-file-json.vm");
    }

    public FileInfo insertSrcFileProperties() throws TokenStreamException, JSONException {
        this.velocity.put("headerMetrics", this.fileInfo.getMetrics());
        this.velocity.put("headerMetricsRaw", this.fileInfo.getRawMetrics());
        this.velocity.put("fileInfo", this.fileInfo);
        ProjectInfo projInfo = this.fullModel;
        this.velocity.put("projInfo", projInfo);
        this.velocity.put("cloverDb", this.database);
        HtmlReportUtil.addFilteredPercentageToContext(this.velocity, this.fileInfo);
        final HashMap targetMethods = new HashMap();
        final HashMap targetElements = new HashMap();
        HashMap<TestCaseInfo, BlockMetrics> testMetrics = new HashMap<TestCaseInfo, BlockMetrics>();
        Set<TestCaseInfo> testHits = this.database.getTestHits(this.fileInfo);
        FileInfo fcopy = this.fileInfo.copy((PackageInfo)this.fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
        HashSet<TestCaseInfo> testSet = new HashSet<TestCaseInfo>();
        final List[] testLineInfo = new ArrayList[fcopy.getLineCount() + 1];
        for (final TestCaseInfo tci : testHits) {
            testSet.clear();
            testSet.add(tci);
            CoverageData data = this.database.getCoverageData();
            fcopy.setDataProvider(new BitSetCoverageProvider(data.getHitsFor(testSet, fcopy), data));
            testMetrics.put(tci, fcopy.getMetrics());
            fcopy.visitElements(new FileElementVisitor(){

                @Override
                public void visitClass(ClassInfo info) {
                }

                @Override
                public void visitMethod(MethodInfo info) {
                    if (info.getHitCount() > 0) {
                        this.updateTestLineInfo(info);
                        BitSet set = (BitSet)targetMethods.get(tci);
                        if (set == null) {
                            set = new BitSet();
                            targetMethods.put(tci, set);
                        }
                        set.set(info.getStartLine());
                    }
                }

                @Override
                public void visitStatement(StatementInfo info) {
                    this.visitNode(info);
                }

                @Override
                public void visitBranch(BranchInfo info) {
                    this.visitNode(info);
                }

                private void visitNode(ElementInfo info) {
                    if (info.getHitCount() > 0) {
                        this.updateTestLineInfo(info);
                        BitSet set = (BitSet)targetElements.get(tci);
                        if (set == null) {
                            set = new BitSet();
                            targetElements.put(tci, set);
                        }
                        set.set(info.getStartLine());
                    }
                }

                private void updateTestLineInfo(SourceInfo r) {
                    int sl = r.getStartLine();
                    ArrayList<TestCaseInfo> tests = testLineInfo[sl];
                    if (tests == null) {
                        testLineInfo[sl] = tests = new ArrayList<TestCaseInfo>();
                    }
                    if (!this.isSetForThisTest(targetElements, sl) && !this.isSetForThisTest(targetMethods, sl)) {
                        tests.add(tci);
                    }
                }

                private boolean isSetForThisTest(Map<TestCaseInfo, BitSet> m, int i) {
                    BitSet bsc = m.get(tci);
                    return bsc != null && bsc.get(i);
                }
            });
        }
        this.testLineInfo = testLineInfo;
        LinkedHashMap orderedTestMetrics = new LinkedHashMap(testMetrics.size());
        LinkedList testMetricList = new LinkedList(testMetrics.entrySet());
        Collections.sort(testMetricList, TEST_METRICS_COMPARATOR);
        List sublist = this.report.getMaxTestsPerFile() >= 0 && !testMetricList.isEmpty() && testMetricList.size() > this.report.getMaxTestsPerFile() ? testMetricList.subList(0, this.report.getMaxTestsPerFile()) : testMetricList;
        for (Map.Entry entry : sublist) {
            orderedTestMetrics.put(entry.getKey(), entry.getValue());
        }
        this.velocity.put("testMetrics", orderedTestMetrics);
        this.velocity.put("numTargetMethods", new Integer(targetMethods.size()));
        this.velocity.put("testsPerFile", new Integer(this.report.getMaxTestsPerFile()));
        this.velocity.put("jsonTestTargets", JSONObjectFactory.getJSONTestTargets(targetMethods, targetElements));
        this.velocity.put("jsonPageData", JSONObjectFactory.getJSONPageData(this.fileInfo));
        if (sublist.size() < testMetricList.size()) {
            this.velocity.put("numTestsHidden", new Integer(testMetricList.size() - sublist.size()));
        }
        return fcopy;
    }

    private void insertLineInfos(FileInfo fcopy, List[] testLineInfo) throws TokenStreamException {
        new SourceRenderHelper(this.database, this.report, this.renderingHelper).insertLineInfosForFile(fcopy, this.velocity, this.getContextSet(), "&nbsp;", testLineInfo);
    }

    protected ContextSet getContextSet() {
        return contextSetTL.get();
    }

    static String createOutFileName(String basename) {
        return new StringBuffer().append(RenderFileAction.createOutFileBaseName(basename)).append("html").toString();
    }

    protected static String createOutFileBaseName(String basename) {
        return basename.substring(0, basename.lastIndexOf(".") + 1);
    }

    static {
        TEST_METRICS_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object1) {
                BlockMetrics m = (BlockMetrics)((Map.Entry)object).getValue();
                BlockMetrics m1 = (BlockMetrics)((Map.Entry)object1).getValue();
                return (int)(1000.0f * (m1.getPcCoveredElements() - m.getPcCoveredElements()));
            }
        };
    }
}

