/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.org.apache.velocity.app.VelocityEngine;
import clover.org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.ColumnFormat;
import com.cenqua.clover.reporters.html.VelocityLogAdapter;
import com.cenqua.clover.util.Formatting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;

public class HtmlReportUtil {
    private static ThreadLocal ve = new ThreadLocal(){

        protected Object initialValue() {
            return HtmlReportUtil.newVelocityEngine();
        }
    };
    static final int EXTRA_COLS = 1;
    static /* synthetic */ Class class$clover$org$apache$velocity$runtime$resource$loader$ClasspathResourceLoader;

    public static VelocityEngine getVelocityEngine() {
        return (VelocityEngine)ve.get();
    }

    static VelocityEngine newVelocityEngine() {
        VelocityEngine engine = new VelocityEngine();
        try {
            engine.setProperty("resource.loader", "class");
            engine.setProperty("velocimacro.library", "");
            Class<?> clazz = class$clover$org$apache$velocity$runtime$resource$loader$ClasspathResourceLoader;
            if (clazz == null) {
                clazz = class$clover$org$apache$velocity$runtime$resource$loader$ClasspathResourceLoader = new ClasspathResourceLoader[0].getClass().getComponentType();
            }
            engine.setProperty("class.resource.loader.class", clazz.getName());
            engine.setProperty("class.resource.loader.cache", "true");
            engine.setProperty("class.resource.loader.modificationCheckInterval", "0");
            engine.setProperty("parser.pool.size", "1");
            engine.setProperty("runtime.log.logsystem", new VelocityLogAdapter(Logger.getInstance()));
            engine.setProperty("resource.manager.logwhenfound", "false");
            engine.setProperty("runtime.log.invalid.references", "false");
            engine.init();
        }
        catch (Exception e) {
            Logger.getInstance().error("Could not load templating engine. " + e.getMessage(), e);
            return null;
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeTemplateToFile(VelocityEngine engine, File outfile, VelocityContext context, String template) throws Exception {
        if (Logger.isDebug()) {
            Logger.getInstance().debug("rendering " + template);
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8"));
        try {
            if (engine.mergeTemplate(template, "ASCII", context, out)) {
                if (Logger.isDebug()) {
                    Logger.getInstance().debug("done " + outfile.getAbsolutePath());
                }
            } else if (Logger.isDebug()) {
                Logger.getInstance().warn("Failed to generate " + outfile);
            }
        }
        catch (Exception e) {
            Logger.getInstance().warn("Failed to generate " + outfile, e);
        }
        finally {
            out.close();
        }
    }

    public static void mergeTemplateToFile(File outfile, VelocityContext context, String template) throws Exception {
        HtmlReportUtil.mergeTemplateToFile(HtmlReportUtil.getVelocityEngine(), outfile, context, template);
    }

    public static void mergeTemplateToDir(File basePath, String templateName, VelocityContext context) throws Exception {
        File outfile = new File(basePath, templateName);
        context.put("currentPageURL", templateName);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/" + templateName);
    }

    public static void addColumnsToContext(VelocityContext context, List cols, HasMetricsNode parent, List children) {
        HasMetricsNode childInfo = children != null && children.size() > 0 ? (HasMetricsNode)children.get(0) : null;
        context.put("columns", cols);
        int colSpan = 1;
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            ColumnFormat format = column.getFormat();
            colSpan += format.getColSpan();
        }
        context.put("colSpan", new Integer(colSpan));
        context.put("headerInfo", parent);
        context.put("childHeaderInfo", childInfo);
    }

    public static void addFilteredPercentageToContext(VelocityContext context, HasMetrics model) {
        float pcFiltered = HtmlReportUtil.getPercentageFiltered(model);
        if (pcFiltered > 0.0f) {
            String percentFiltered = Formatting.getPercentStr(pcFiltered);
            context.put("percentFiltered", percentFiltered);
            context.put("showFilterToggle", HtmlReportUtil.hasFilteredMetrics(model));
        }
    }

    public static boolean hasFilteredMetrics(HasMetrics model) {
        return model.getMetrics().getNumElements() != model.getRawMetrics().getNumElements();
    }

    public static float getPercentageFiltered(HasMetrics model) {
        float rawElements = model.getRawMetrics().getNumElements();
        if (rawElements > 0.0f) {
            int numElements = model.getMetrics().getNumElements();
            return 1.0f - (float)numElements / rawElements;
        }
        return -1.0f;
    }
}

