/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.console;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.Enum_;
import com.cenqua.clover.CodeType;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.util.Path;
import java.util.Locale;
import java.util.Set;

public class ConsoleReporterConfig {
    private static final String CODE_TYPES_AS_STRING_LIST = "\"" + CodeType.APPLICATION.name().toLowerCase(Locale.US) + "\",\"" + CodeType.TEST.name().toLowerCase(Locale.US) + "\",\"" + CodeType.ALL.name().toLowerCase() + "\"";
    private static final String INVALID_CODE_TYPE_MESSAGE = "  *** ERROR: invalid code type set. Valid values: " + CODE_TYPES_AS_STRING_LIST;
    String level = "summary";
    String title;
    String initstring;
    Set packageSet;
    boolean showPackages = false;
    boolean showClasses = false;
    boolean showMethods = false;
    boolean showStatements = false;
    boolean showUnitTests = false;
    Interval span = Interval.DEFAULT_SPAN;
    Path sourcepath = null;
    CodeType codetype = CodeType.APPLICATION;

    public void setPackageSet(Set packageSet) {
        this.packageSet = packageSet;
    }

    public void setInitString(String initString) {
        this.initstring = initString;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public Interval getSpan() {
        return this.span;
    }

    public void setSpan(Interval span) {
        this.span = span;
    }

    public Path getSourcepath() {
        return this.sourcepath;
    }

    public void setSourcepath(Path sourcepath) {
        this.sourcepath = sourcepath;
    }

    public CodeType getCodetype() {
        return this.codetype;
    }

    public void setCodetype(CodeType codetype) {
        this.codetype = codetype;
    }

    public void setShowUnitTests(boolean show) {
        this.showUnitTests = show;
    }

    public boolean isShowUnitTests() {
        return this.showUnitTests;
    }

    public boolean validate() {
        boolean valid;
        boolean bl = valid = this.level != null && (this.level.equalsIgnoreCase("summary") || this.level.equalsIgnoreCase("package") || this.level.equalsIgnoreCase("class") || this.level.equalsIgnoreCase("method") || this.level.equalsIgnoreCase("statement"));
        if (!valid) {
            System.err.println("  *** ERROR: Invalid reporting level \"" + this.level + "\"");
            return false;
        }
        if (this.level.equalsIgnoreCase("package")) {
            this.showPackages = true;
        } else if (this.level.equalsIgnoreCase("class")) {
            this.showClasses = true;
        } else if (this.level.equalsIgnoreCase("method")) {
            this.showClasses = true;
            this.showMethods = true;
        } else if (this.level.equalsIgnoreCase("statement")) {
            this.showClasses = true;
            this.showMethods = true;
            this.showStatements = true;
        }
        boolean bl2 = valid = this.initstring != null && this.initstring.length() > 0;
        if (!valid) {
            System.err.println("  *** ERROR: initstring not set");
            return false;
        }
        boolean bl3 = valid = this.codetype != null;
        if (!valid) {
            System.err.println(INVALID_CODE_TYPE_MESSAGE);
            return false;
        }
        return true;
    }

    boolean processArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (Keys.LEVEL.matches(args[i])) {
                    this.level = args[++i];
                    continue;
                }
                if (Keys.INITSTRING.matches(args[i])) {
                    this.initstring = args[++i];
                    continue;
                }
                if (Keys.TITLE.matches(args[i])) {
                    this.title = args[++i];
                    continue;
                }
                if (Keys.CODETYPE.matches(args[i])) {
                    ++i;
                    try {
                        this.codetype = CodeType.valueOf(args[i].toUpperCase(Locale.US));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(INVALID_CODE_TYPE_MESSAGE);
                        return false;
                    }
                }
                if (Keys.SOURCEPATH.matches(args[i])) {
                    this.sourcepath = new Path(args[++i]);
                    continue;
                }
                if (Keys.SPAN.matches(args[i])) {
                    ++i;
                    try {
                        this.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("  *** ERROR: Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return false;
                    }
                }
                if (Keys.UNITTESTS.matches(args[i])) {
                    this.setShowUnitTests(true);
                    continue;
                }
                System.err.println("  *** ERROR: unknown parameter \"" + args[i] + "\"");
                return false;
            }
            return this.validate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("  *** ERROR: Invalid number of parameters");
            return false;
        }
    }

    static /* synthetic */ String access$000() {
        return CODE_TYPES_AS_STRING_LIST;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Keys
    extends Enum_<Keys> {
        public static final Keys CODETYPE = new Keys("CODETYPE", 0, "c", "codetype", new StringBuffer().append("<string>\tThe type of code to report on. Valid\n\t\t\t\tvalues are ").append(ConsoleReporterConfig.access$000()).append(".\n").append("\t\t\t\tDefault value is \"").append(CodeType.APPLICATION.name().toLowerCase(Locale.US)).append("\"").toString());
        public static final Keys INITSTRING = new Keys("INITSTRING", 1, "i", "initstring", "<string>\tClover initstring");
        public static final Keys LEVEL = new Keys("LEVEL", 2, "l", "level", "<string>\tThe level of detail to report. Valid\n\t\t\t\tvalues are \"summary\",\"class\",\"method\",\"statement\".\n\t\t\t\tDefault value is \"summary\".");
        public static final Keys SOURCEPATH = new Keys("SOURCEPATH", 3, "p", "sourcepath", "\tThe sourcepath that Clover should search on for source files.");
        public static final Keys SPAN = new Keys("SPAN", 4, "s", "span", "<interval>\tSpecifies how far back in time to\n\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.");
        public static final Keys TITLE = new Keys("TITLE", 5, "t", "title", "<string>\tReport title");
        public static final Keys UNITTESTS = new Keys("UNITTESTS", 6, "u", "unittests", "\tShow unit tests results summary. Should be used with codetype=all or codetype=test.");
        private String shortKey;
        private String longKey;
        private String description;
        private static final /* synthetic */ Keys[] $VALUES;
        static /* synthetic */ Class class$com$cenqua$clover$reporters$console$ConsoleReporterConfig$Keys;

        public static final Keys[] values() {
            return (Keys[])$VALUES.clone();
        }

        public static Keys valueOf(String name) {
            Class<?> clazz = class$com$cenqua$clover$reporters$console$ConsoleReporterConfig$Keys;
            if (clazz == null) {
                clazz = class$com$cenqua$clover$reporters$console$ConsoleReporterConfig$Keys = new Keys[0].getClass().getComponentType();
            }
            return (Keys)Enum_.valueOf(clazz, name);
        }

        private Keys(String shortKey, String longKey, String desc) {
            super(var1_1, (int)var2_2);
            this.shortKey = new StringBuffer().append("-").append(shortKey).toString();
            this.longKey = new StringBuffer().append("--").append(longKey).toString();
            this.description = new StringBuffer().append("\t").append(this.shortKey).append(", ").append(this.longKey).append(" ").append(desc).toString();
        }

        public String shortKey() {
            return this.shortKey;
        }

        public String longKey() {
            return this.longKey;
        }

        public String description() {
            return this.description;
        }

        public boolean matches(String arg) {
            return arg.equals(this.shortKey) || arg.equals(this.longKey);
        }

        static {
            $VALUES = new Keys[]{CODETYPE, INITSTRING, LEVEL, SOURCEPATH, SPAN, TITLE, UNITTESTS};
        }
    }
}

