/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.MethodInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetricsCollator {
    public List getLeastTestedMethods(List classes) {
        ArrayList<MethodInfo> methodsLeastTested = new ArrayList<MethodInfo>();
        int numMethods = 20;
        HasMetricsFilter methodFilter = new HasMetricsFilter(){

            public boolean accept(HasMetrics hm) {
                return hm.getMetrics().getPcCoveredElements() != 1.0f && hm.getMetrics().getNumElements() > 0;
            }
        };
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            Iterator<MethodInfo> i$ = classInfo.getMethods().iterator();
            while (i$.hasNext()) {
                MethodInfo methodInfo = i$.next();
                if (!methodFilter.accept(methodInfo)) continue;
                methodsLeastTested.add(methodInfo);
            }
        }
        ArrayList<HasMetricsSupport.HasMetricsComparator> comparators = new ArrayList<HasMetricsSupport.HasMetricsComparator>();
        comparators.add(HasMetricsSupport.CMP_PC_ASC);
        comparators.add(HasMetricsSupport.CMP_ELEMENTS_UNCOVERED_DESC);
        comparators.add(HasMetricsSupport.CMP_COMPLEXITY_DESC);
        HasMetricsSupport.HasMetricsComparatorChain cmp = new HasMetricsSupport.HasMetricsComparatorChain(comparators);
        Collections.sort(methodsLeastTested, cmp);
        int toIndex = methodsLeastTested.size() < numMethods ? methodsLeastTested.size() : numMethods;
        return methodsLeastTested.subList(0, toIndex);
    }

    public List getTopRisks(Map classMap, int risksCount) {
        int count = 0;
        ArrayList topRisks = new ArrayList(risksCount);
        Iterator iterator = classMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer key = (Integer)iterator.next();
            List list = (List)classMap.get(key);
            int size = list.size();
            if (count + size >= risksCount) {
                int diff = risksCount - count;
                topRisks.addAll(list.subList(0, diff));
                break;
            }
            topRisks.addAll(list);
            count += size;
        }
        return topRisks;
    }

    public Map rankProjectRisks(List pceOrder, List amcOrder) {
        TreeMap classMap = new TreeMap();
        int i = 0;
        Iterator iterator = pceOrder.iterator();
        while (iterator.hasNext()) {
            List<BaseClassInfo> value;
            BaseClassInfo info = (BaseClassInfo)iterator.next();
            int rank = amcOrder.indexOf(info) + ++i;
            Integer key = new Integer(rank);
            if (classMap.containsKey(key)) {
                value = (List)classMap.get(key);
            } else {
                value = new ArrayList();
                classMap.put(key, value);
            }
            value.add(info);
        }
        return classMap;
    }

    public List getTopOfList(List infos, int topNCount, HasMetricsSupport.HasMetricsComparator cmp) {
        Collections.sort(infos, cmp);
        Collections.reverse(infos);
        int last = infos.size() >= topNCount ? topNCount : infos.size();
        return infos.subList(0, last);
    }
}

