/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BaseProjectInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.FileInfoRegion;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.reporters.AverageColumn;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.ColumnFormat;
import com.cenqua.clover.reporters.CoverageColumn;
import com.cenqua.clover.reporters.ExpressionEvaluator;
import com.cenqua.clover.reporters.TotalColumn;
import com.cenqua.clover.reporters.html.HtmlRenderingSupportImpl;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Columns {
    static final String SCOPE_PACKAGE = "package";
    static final String SCOPE_CLASS = "class";
    static final String SCOPE_METHOD = "method";
    private final List<Column> projectColumns = new LinkedList<Column>();
    private final List<Column> pkgColumns = new LinkedList<Column>();
    private final List<Column> classColumns = new LinkedList<Column>();
    private final List<Column> methodColumns = new LinkedList<Column>();
    static /* synthetic */ Class class$com$cenqua$clover$reporters$Columns;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$Columns$Expression;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$Column;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$Columns$PercentageColumn;

    private static Column createColumn(String columnType) throws CloverException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz = class$com$cenqua$clover$reporters$Columns;
            if (clazz == null) {
                clazz = class$com$cenqua$clover$reporters$Columns = new Columns[0].getClass().getComponentType();
            }
            String name = stringBuffer.append(clazz.getName()).append("$").append(columnType.substring(0, 1).toUpperCase()).append(columnType.substring(1)).toString();
            Class<?> colClass = Class.forName(name);
            return (Column)colClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().debug(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            Logger.getInstance().debug(e.getMessage(), e);
        }
        throw new CloverException(new StringBuffer().append("Invalid column name: '").append(columnType).append("'").toString());
    }

    public static boolean isValidColumnName(String columnName) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz = class$com$cenqua$clover$reporters$Columns;
            if (clazz == null) {
                clazz = class$com$cenqua$clover$reporters$Columns = new Columns[0].getClass().getComponentType();
            }
            String name = stringBuffer.append(clazz.getName()).append("$").append(columnName.substring(0, 1).toUpperCase()).append(columnName.substring(1)).toString();
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static double getColumnValue(String name, String format, BlockMetrics m) throws CloverException {
        Column col = Columns.createColumn(name);
        col.setFormat(format);
        col.init(m);
        return col.getNumber().doubleValue();
    }

    private static BaseProjectInfo getProjectFor(HasMetrics owner) {
        return owner instanceof FileInfoRegion ? ((FileInfoRegion)((Object)owner)).getContainingFile().getContainingPackage().getContainingProject() : (owner instanceof BaseFileInfo ? ((BaseFileInfo)owner).getContainingPackage().getContainingProject() : (owner instanceof BasePackageInfo ? ((BasePackageInfo)owner).getContainingProject() : (owner instanceof BaseProjectInfo ? (BaseProjectInfo)owner : null)));
    }

    public void addConfiguredTotalPercentageCovered(TotalPercentageCovered column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredPercentageCoveredContribution(PercentageCoveredContribution column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredPercentageUncoveredContribution(PercentageUncoveredContribution column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredTotalBranches(TotalBranches column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredCoveredBranches(CoveredBranches column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredUncoveredBranches(UncoveredBranches column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredTotalMethods(TotalMethods column) {
        this.addPkgColumn(column);
        this.addClassColumn(column);
    }

    public void addConfiguredCoveredMethods(CoveredMethods column) {
        this.addPkgColumn(column);
        this.addClassColumn(column);
    }

    public void addConfiguredUncoveredMethods(UncoveredMethods column) {
        this.addPkgColumn(column);
        this.addClassColumn(column);
    }

    public void addConfiguredTotalStatements(TotalStatements column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredCoveredStatements(CoveredStatements column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredUncoveredStatements(UncoveredStatements column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredTotalElements(TotalElements column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredCoveredElements(CoveredElements column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredUncoveredElements(UncoveredElements column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredAvgClassesPerFile(AvgClassesPerFile column) {
        this.addPkgColumn(column);
    }

    public void addConfiguredAvgMethodsPerClass(AvgMethodsPerClass column) {
        this.addPkgColumn(column);
    }

    public void addConfiguredAvgStatementsPerMethod(AvgStatementsPerMethod column) {
        this.addGlobalMethodColumn(column, new TotalStatements(column));
    }

    public void addConfiguredTotalPackages(TotalPackages column) {
        this.projectColumns.add(column);
    }

    public void addConfiguredTotalFiles(TotalFiles column) {
        this.addPkgColumn(column);
    }

    public void addConfiguredTotalClasses(TotalClasses column) {
        this.addPkgColumn(column);
    }

    public void addConfiguredLineCount(LineCount column) {
        this.addPkgColumn(column);
    }

    public void addConfiguredNcLineCount(NcLineCount column) {
        this.addPkgColumn(column);
    }

    public void addConfiguredComplexity(Complexity column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredAvgMethodComplexity(AvgMethodComplexity column) {
        this.addGlobalMethodColumn(column, new Complexity(column));
    }

    private void addGlobalMethodColumn(Column column, Column methodColumn) {
        this.addPkgColumn(column);
        this.addClassColumn(column);
        this.addMethodColumn(methodColumn);
    }

    public void addConfiguredComplexityDensity(ComplexityDensity column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredTotalChildren(TotalChildren column) {
        this.addPkgColumn(column);
        this.addClassColumn(column);
        this.addMethodColumn(new TotalStatements(column));
    }

    public void addConfiguredComplexityCoverage(ComplexityToCoverage column) {
        this.addGlobalColumn(column);
    }

    public void addConfiguredExpression(Expression column) throws CloverException {
        ExpressionEvaluator.parse(column.expr, column.title);
        this.addGlobalColumn(column);
    }

    private void insertColumn(Column column) {
        if (column.getScope() == null || this.scopeContains(column, SCOPE_METHOD)) {
            this.addPkgColumn(column);
            this.addClassColumn(column);
            this.addMethodColumn(column);
        } else if (this.scopeContains(column, SCOPE_CLASS)) {
            this.addPkgColumn(column);
            this.addClassColumn(column);
        } else if (this.scopeContains(column, SCOPE_PACKAGE)) {
            this.addPkgColumn(column);
        }
    }

    private boolean scopeContains(Column column, String scope) {
        return column.getScope().indexOf(scope) >= 0;
    }

    public void addConfiguredSum(SUM column) {
        this.addGlobalColumn(column);
    }

    public void addFilteredElements(FilteredElements column) {
        this.addGlobalColumn(column);
    }

    private void addGlobalColumn(Column column) {
        this.insertColumn(column);
    }

    private void addClassColumn(Column column) {
        this.classColumns.add(column);
    }

    private void addPkgColumn(Column column) {
        this.pkgColumns.add(column);
    }

    private void addMethodColumn(Column column) {
        this.methodColumns.add(column);
    }

    public Set<Column> getProjectColumns() {
        HashSet<Column> allColumns = new HashSet<Column>(this.projectColumns);
        allColumns.addAll(this.pkgColumns);
        allColumns.addAll(this.classColumns);
        allColumns.addAll(this.methodColumns);
        return allColumns;
    }

    public List<Column> getPkgColumns() {
        return new LinkedList<Column>(this.pkgColumns);
    }

    public List<Column> getClassColumns() {
        return new LinkedList<Column>(this.classColumns);
    }

    public List<Column> getMethodColumns() {
        return this.methodColumns;
    }

    public List<Column> getProjectColumnsCopy() {
        return this.copyColumns(new LinkedList<Column>(this.getProjectColumns()));
    }

    public List<Column> getClassColumnsCopy() {
        return this.copyColumns(this.classColumns);
    }

    public List<Column> getMethodColumnsCopy() {
        return this.copyColumns(this.methodColumns);
    }

    public static List<Column> getAllColumns() {
        LinkedList<Column> allColumns = new LinkedList<Column>();
        Class<?> clazz = class$com$cenqua$clover$reporters$Columns;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$Columns = new Columns[0].getClass().getComponentType();
        }
        Class<?>[] classes = clazz.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> aClass = classes[i];
            Class<?> clazz2 = class$com$cenqua$clover$reporters$Column;
            if (clazz2 == null) {
                clazz2 = new Column[0].getClass().getComponentType();
            }
            if (!clazz2.isAssignableFrom(aClass)) continue;
            Class<?> clazz3 = class$com$cenqua$clover$reporters$Columns$Expression;
            if (clazz3 == null) {
                clazz3 = new Expression[0].getClass().getComponentType();
            }
            if (clazz3.isAssignableFrom(aClass)) continue;
            try {
                Column col = (Column)aClass.newInstance();
                Class<?> clazz4 = class$com$cenqua$clover$reporters$Columns$PercentageColumn;
                if (clazz4 == null) {
                    clazz4 = new PercentageColumn[0].getClass().getComponentType();
                }
                if (!clazz4.isAssignableFrom(aClass)) {
                    col.setFormat("raw");
                }
                allColumns.add(col);
                continue;
            }
            catch (InstantiationException e) {
                Logger.getInstance().warn(new StringBuffer().append("Could not add column: ").append(aClass).toString(), e);
                continue;
            }
            catch (IllegalAccessException e) {
                Logger.getInstance().warn(new StringBuffer().append("Could not add column: ").append(aClass).toString(), e);
            }
        }
        return allColumns;
    }

    private List<Column> copyColumns(List cols) {
        ArrayList<Column> columns = new ArrayList<Column>(cols.size());
        for (Column column : cols) {
            columns.add(column.copy());
        }
        return columns;
    }

    public static class FilteredElements
    extends PercentageColumn {
        public FilteredElements() {
        }

        public FilteredElements(Column col) {
            super(col);
        }

        public Column copy() {
            return new FilteredElements(this);
        }

        public void init(BlockMetrics value) {
            int totalFiltered;
            float pcFiltered;
            boolean isFiltered;
            HasMetrics hasMetrics = value.getOwner();
            BlockMetrics rawMetrics = hasMetrics.getRawMetrics();
            if (rawMetrics == null) {
                isFiltered = false;
                pcFiltered = 0.0f;
                totalFiltered = 0;
            } else {
                isFiltered = HtmlReportUtil.hasFilteredMetrics(hasMetrics);
                pcFiltered = HtmlReportUtil.getPercentageFiltered(hasMetrics);
                totalFiltered = rawMetrics.getNumElements() - hasMetrics.getMetrics().getNumElements();
            }
            this.setValues(totalFiltered, pcFiltered, isFiltered);
            this.setCustomPositiveClass("barFiltered");
            this.setCustomNegativeClass("barNonFiltered");
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Filtered");
        }

        public String getHelp() {
            return "The percentage of elements that have been filtered from this report.";
        }
    }

    public static class TotalChildren
    extends TotalColumn {
        public TotalChildren() {
        }

        public TotalChildren(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalChildren(this);
        }

        public void init(BlockMetrics value) {
            ClassMetrics metrics = (ClassMetrics)value;
            this.setValues(metrics.getNumChildren());
        }

        public String getTitle(BlockMetrics value) {
            ClassMetrics metrics = (ClassMetrics)value;
            if (metrics == null) {
                return "children";
            }
            HtmlRenderingSupportImpl support = new HtmlRenderingSupportImpl();
            String title = support.capitalize(metrics.getChildType());
            String suffix = title.endsWith("s") ? "es" : "s";
            return title + suffix;
        }
    }

    public static class ComplexityToCoverage
    extends TotalColumn {
        public ComplexityToCoverage() {
        }

        public ComplexityToCoverage(Column col) {
            super(col);
        }

        public Column copy() {
            return new ComplexityToCoverage(this);
        }

        public void init(BlockMetrics value) {
            boolean isEmpty = value.getPcCoveredElements() == 0.0f;
            this.setValues(isEmpty ? -1 : (int)((float)value.getComplexity() / value.getPcCoveredElements()));
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Complexity / Coverage");
        }
    }

    public static class ComplexityDensity
    extends AverageColumn {
        public ComplexityDensity() {
        }

        public ComplexityDensity(Column col) {
            super(col);
        }

        public Column copy() {
            return new ComplexityDensity(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getComplexityDensity());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Complexity Density");
        }

        public String getHelp() {
            return "Complexity Density is the average number of paths in your code per statement.";
        }
    }

    public static class AvgMethodComplexity
    extends AverageColumn {
        public AvgMethodComplexity() {
        }

        public AvgMethodComplexity(Column col) {
            super(col);
        }

        public Column copy() {
            return new AvgMethodComplexity(this);
        }

        public void init(BlockMetrics value) {
            ClassMetrics metrics = (ClassMetrics)value;
            this.setValues(metrics.getAvgMethodComplexity());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Average Method Complexity");
        }

        public String getHelp() {
            return "The average number of paths per method.";
        }
    }

    public static class Complexity
    extends TotalColumn {
        public Complexity() {
        }

        public Complexity(Column col) {
            super(col);
        }

        public Column copy() {
            return new Complexity(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getComplexity());
        }

        public String getTitle(BlockMetrics value) {
            return "Complexity";
        }

        public String getHelp() {
            return "Cyclomatic complexity is a measure of the number of paths in your code.";
        }
    }

    public static class NcLineCount
    extends TotalColumn {
        public NcLineCount() {
        }

        public NcLineCount(Column col) {
            super(col);
        }

        public Column copy() {
            return new NcLineCount(this);
        }

        public void init(BlockMetrics value) {
            FileMetrics metrics = (FileMetrics)value;
            this.setValues(metrics.getNcLineCount());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("NC Lines");
        }

        public String getHelp() {
            return "Total number of non-comment lines of code.";
        }
    }

    public static class LineCount
    extends TotalColumn {
        public LineCount() {
        }

        public LineCount(Column col) {
            super(col);
        }

        public Column copy() {
            return new LineCount(this);
        }

        public void init(BlockMetrics value) {
            FileMetrics metrics = (FileMetrics)value;
            this.setValues(metrics.getLineCount());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Lines");
        }

        public String getHelp() {
            return "Total number of lines.";
        }
    }

    public static class TotalClasses
    extends TotalColumn {
        public TotalClasses() {
        }

        public TotalClasses(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalClasses(this);
        }

        public void init(BlockMetrics value) {
            FileMetrics metrics = (FileMetrics)value;
            this.setValues(metrics.getNumClasses());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Classes");
        }

        public String getHelp() {
            return "The total number of classes.";
        }
    }

    public static class TotalFiles
    extends TotalColumn {
        public TotalFiles() {
        }

        public TotalFiles(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalFiles(this);
        }

        public void init(BlockMetrics value) {
            PackageMetrics metrics = (PackageMetrics)value;
            this.setValues(metrics.getNumFiles());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Files");
        }

        public String getHelp() {
            return "The total number of files in this package or project.";
        }
    }

    public static class TotalPackages
    extends TotalColumn {
        public TotalPackages() {
        }

        public TotalPackages(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalPackages(this);
        }

        public void init(BlockMetrics value) {
            if (value instanceof ProjectMetrics) {
                ProjectMetrics metrics = (ProjectMetrics)value;
                this.setValues(metrics.getNumPackages());
            } else {
                this.setValues(0);
            }
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Packages");
        }

        public String getHelp() {
            return "The total number of packages in this project.";
        }
    }

    public static class AvgStatementsPerMethod
    extends AverageColumn {
        public AvgStatementsPerMethod() {
        }

        public AvgStatementsPerMethod(Column col) {
            super(col);
        }

        public Column copy() {
            return new AvgStatementsPerMethod(this);
        }

        public void init(BlockMetrics value) {
            ClassMetrics metrics = (ClassMetrics)value;
            this.setValues(metrics.getAvgStatementsPerMethod());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Avg Statements / Method");
        }

        public String getHelp() {
            return "The average number of statements per method.";
        }
    }

    public static class AvgMethodsPerClass
    extends AverageColumn {
        public AvgMethodsPerClass() {
        }

        public AvgMethodsPerClass(Column col) {
            super(col);
        }

        public Column copy() {
            return new AvgMethodsPerClass(this);
        }

        public void init(BlockMetrics value) {
            FileMetrics metrics = (FileMetrics)value;
            this.setValues(metrics.getAvgMethodsPerClass());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Avg Methods / Class");
        }

        public String getHelp() {
            return "The average number of methods in each class.";
        }
    }

    public static class AvgClassesPerFile
    extends AverageColumn {
        public AvgClassesPerFile() {
        }

        public Column copy() {
            return new AvgClassesPerFile(this);
        }

        public AvgClassesPerFile(Column col) {
            super(col);
        }

        public void init(BlockMetrics value) {
            PackageMetrics metrics = (PackageMetrics)value;
            this.setValues(metrics.getAvgClassesPerFile());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Avg Classes / File");
        }

        public String getHelp() {
            return "The average number of classes in each file.";
        }
    }

    public static class UncoveredElements
    extends CoverageColumn {
        public UncoveredElements() {
        }

        public UncoveredElements(Column col) {
            super(col);
        }

        public Column copy() {
            return new UncoveredElements(this);
        }

        public void init(BlockMetrics value) {
            float pcvalue = value.getPcCoveredElements() < 0.0f ? -1.0f : 1.0f - value.getPcCoveredElements();
            this.setValues(value.getNumElements() - value.getNumCoveredElements(), pcvalue);
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Uncovered Elements");
        }

        public String getHelp() {
            return "The number of statements and branches that were not covered during testing.";
        }
    }

    public static class CoveredElements
    extends CoverageColumn {
        public CoveredElements() {
        }

        public CoveredElements(Column col) {
            super(col);
        }

        public Column copy() {
            return new CoveredElements(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumCoveredElements(), value.getPcCoveredElements());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Covered Elements");
        }

        public String getHelp() {
            return "The number of statements and branches that were covered during testing.";
        }
    }

    public static class TotalElements
    extends TotalColumn {
        public TotalElements() {
        }

        public TotalElements(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalElements(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumElements());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Elements");
        }

        public String getHelp() {
            return "The total amount of branches + statements.";
        }
    }

    public static class PercentageUncoveredContribution
    extends PercentageContribution {
        public PercentageUncoveredContribution() {
        }

        public PercentageUncoveredContribution(Column col) {
            super(col);
        }

        public Column copy() {
            return new PercentageUncoveredContribution(this);
        }

        public void init(BlockMetrics value) {
            HasMetrics owner = value.getOwner();
            BaseProjectInfo project = Columns.getProjectFor(owner);
            BlockMetrics projectMetrics = project == null ? null : project.getMetrics();
            this.setValues(value.getNumCoveredElements(), projectMetrics == null || (float)projectMetrics.getNumUncoveredElements() == 0.0f ? 0.0f : (float)value.getNumUncoveredElements() / (float)projectMetrics.getNumUncoveredElements(), value.isEmpty());
            this.setCustomClasses();
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Uncovered Contribution");
        }

        public String getHelp() {
            return "The amount of code that was not hit during testing as a percentage of the project\\'s total";
        }
    }

    public static class PercentageCoveredContribution
    extends PercentageContribution {
        public PercentageCoveredContribution() {
        }

        public PercentageCoveredContribution(Column col) {
            super(col);
        }

        public Column copy() {
            return new PercentageCoveredContribution(this);
        }

        public void init(BlockMetrics value) {
            HasMetrics owner = value.getOwner();
            BaseProjectInfo project = Columns.getProjectFor(owner);
            BlockMetrics projectMetrics = project == null ? null : project.getMetrics();
            this.setValues(value.getNumCoveredElements(), projectMetrics == null || (float)projectMetrics.getNumCoveredElements() == 0.0f ? 0.0f : (float)value.getNumCoveredElements() / (float)projectMetrics.getNumCoveredElements(), value.isEmpty());
            this.setCustomClasses();
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Covered Contribution");
        }

        public String getHelp() {
            return "The amount of code that was hit at least once during testing as a percentage of the project\\'s total";
        }
    }

    static abstract class PercentageContribution
    extends PercentageColumn {
        protected PercentageContribution() {
        }

        protected PercentageContribution(Column col) {
            super(col);
        }

        protected void setCustomClasses() {
            this.setCustomPositiveClass("contribBarPositive");
            this.setCustomNegativeClass("contribBarNegative");
        }
    }

    public static class TotalPercentageCovered
    extends PercentageColumn {
        public TotalPercentageCovered() {
        }

        public TotalPercentageCovered(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalPercentageCovered(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumCoveredElements(), value.getPcCoveredElements(), value.isEmpty());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("TOTAL Coverage");
        }

        public String getHelp() {
            return "The amount of code that was hit at least once during testing.";
        }
    }

    static abstract class PercentageColumn
    extends CoverageColumn {
        public PercentageColumn() {
        }

        public PercentageColumn(Column col) {
            super(col);
        }

        public void setCustomPositiveClass(String className) {
            ((Column.PcColumnData)this.getColumnData()).setCustomPositiveClass(className);
        }

        public void setCustomNegativeClass(String className) {
            ((Column.PcColumnData)this.getColumnData()).setCustomNegativeClass(className);
        }
    }

    public static class UncoveredMethods
    extends CoverageColumn {
        public UncoveredMethods() {
        }

        public UncoveredMethods(Column col) {
            super(col);
        }

        public Column copy() {
            return new UncoveredMethods(this);
        }

        public void init(BlockMetrics value) {
            ClassMetrics cm = (ClassMetrics)value;
            float pcvalue = cm.getPcCoveredMethods() < 0.0f ? -1.0f : 1.0f - cm.getPcCoveredMethods();
            this.setValues(cm.getNumMethods() - cm.getNumCoveredMethods(), pcvalue, value.isEmpty());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Uncovered Methods");
        }

        public String getHelp() {
            return "The amount of methods that were not entered during testing.";
        }
    }

    public static class CoveredMethods
    extends CoverageColumn {
        public CoveredMethods() {
        }

        public CoveredMethods(Column col) {
            super(col);
        }

        public Column copy() {
            return new CoveredMethods(this);
        }

        public void init(BlockMetrics value) {
            ClassMetrics cm = (ClassMetrics)value;
            this.setValues(cm.getNumCoveredMethods(), cm.getPcCoveredMethods(), value.isEmpty());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Covered Methods");
        }

        public String getHelp() {
            return "The amount of methods that were entered at least once during testing.";
        }
    }

    public static class TotalMethods
    extends TotalColumn {
        public TotalMethods() {
        }

        public TotalMethods(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalMethods(this);
        }

        public void init(BlockMetrics value) {
            if (value instanceof ClassMetrics) {
                ClassMetrics cm = (ClassMetrics)value;
                this.setValues(cm.getNumMethods());
            } else {
                this.setValues(1);
            }
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Methods");
        }

        public String getHelp() {
            return "The total number of methods of all scopes including both static and non-static methods.";
        }
    }

    public static class UncoveredStatements
    extends CoverageColumn {
        public UncoveredStatements() {
        }

        public UncoveredStatements(Column col) {
            super(col);
        }

        public Column copy() {
            return new UncoveredStatements(this);
        }

        public void init(BlockMetrics value) {
            float pcvalue = value.getPcCoveredStatements() < 0.0f ? -1.0f : 1.0f - value.getPcCoveredStatements();
            this.setValues(value.getNumStatements() - value.getNumCoveredStatements(), pcvalue);
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Uncovered Statements");
        }

        public String getHelp() {
            return "Statements that were not executed during testing.";
        }
    }

    public static class CoveredStatements
    extends CoverageColumn {
        public CoveredStatements() {
        }

        public CoveredStatements(Column col) {
            super(col);
        }

        public Column copy() {
            return new CoveredStatements(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumCoveredStatements(), value.getPcCoveredStatements());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Covered Statements");
        }

        public String getHelp() {
            return "Statements that were executed at least once.";
        }
    }

    public static class TotalStatements
    extends TotalColumn {
        public TotalStatements() {
        }

        public TotalStatements(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalStatements(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumStatements());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Statements");
        }

        public String getHelp() {
            return "The total number of statements.";
        }
    }

    public static class UncoveredBranches
    extends CoverageColumn {
        public UncoveredBranches() {
        }

        public UncoveredBranches(Column col) {
            super(col);
        }

        public Column copy() {
            return new UncoveredBranches(this);
        }

        public void init(BlockMetrics value) {
            float pcvalue = value.getPcCoveredBranches() < 0.0f ? -1.0f : 1.0f - value.getPcCoveredBranches();
            this.setValues(value.getNumBranches() - value.getNumCoveredBranches(), pcvalue);
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Uncovered Branches");
        }

        public String getHelp() {
            return "An uncovered branch is a branch that has not been followed during testing.";
        }
    }

    public static class CoveredBranches
    extends CoverageColumn {
        public CoveredBranches() {
        }

        public CoveredBranches(Column col) {
            super(col);
        }

        public Column copy() {
            return new CoveredBranches(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumCoveredBranches(), value.getPcCoveredBranches());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Covered Branches");
        }

        public String getHelp() {
            return "A covered branch is a branch that has been followed during testing.";
        }
    }

    public static class TotalBranches
    extends TotalColumn {
        public TotalBranches() {
        }

        public TotalBranches(Column col) {
            super(col);
        }

        public Column copy() {
            return new TotalBranches(this);
        }

        public void init(BlockMetrics value) {
            this.setValues(value.getNumBranches());
        }

        public String getTitle(BlockMetrics value) {
            return this.formatter.formatTitle("Total Branches");
        }

        public String getHelp() {
            return "A branch is any part of the code where a decision has been made. e.g. if elseif, ? :, for, while, switch.";
        }
    }

    public static class SUM
    extends Expression {
        public SUM() {
            this.addText("Complexity^2 * ((1 - %CoveredElements/100)^3) + Complexity");
            this.setTitle("SUM");
        }

        public String getHelp() {
            return "Scientifically Untested Metric";
        }
    }

    public static class Expression
    extends Column {
        static final ColumnFormat.ErrorColumnFormat ERROR_COLUMN_FORMAT = new ColumnFormat.ErrorColumnFormat("-");
        private String expr;
        private String title;

        public Expression() {
            this.formatter = new ColumnFormat.FloatColumnFormat();
        }

        public Expression(Column col) {
            super(col);
            Expression expression = (Expression)col;
            this.expr = expression.expr;
            this.formatter = col.formatter;
            this.title = col.getTitle();
        }

        public void addText(String text) {
            this.expr = text;
        }

        public void setName(String title) {
            this.title = title;
        }

        public void setTitle(String title) {
            this.setName(title);
        }

        public Column copy() {
            return new Expression(this);
        }

        public void init(BlockMetrics value) throws CloverException {
            try {
                double result = ExpressionEvaluator.eval(this.expr, value, this.getTitle(value));
                this.data = new Column.ColumnData((float)result);
            }
            catch (CloverException e) {
                Logger.getInstance().warn(e.getMessage(), e.getCause());
                throw e;
            }
            catch (ClassCastException e) {
                Logger.getInstance().warn("Expression: '" + this.expr + "' contains columns that are not unavailable at this scope.");
                Logger.getInstance().debug(e.getMessage(), e);
                this.data = new Column.ColumnData(-1.0f);
                this.formatter = ERROR_COLUMN_FORMAT;
            }
        }

        public String getTitle(BlockMetrics value) {
            return this.title == null ? this.expr : this.title;
        }

        public String getHelp() {
            return this.expr;
        }
    }
}

