/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.cenqua.clover.Logger;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.util.Formatting;
import java.util.HashMap;
import java.util.Map;

public interface ColumnFormat {
    public static final String PERCENTAGE = "%";
    public static final String PC = "pc";
    public static final String RAW = "raw";
    public static final String BAR = "bar";
    public static final String LONGBAR = "longbar";
    public static final String SHORTBAR = "shortbar";
    public static final String SORT_TYPE_NUMBER = "number";
    public static final String SORT_TYPE_ALPHA = "alpha";

    public String format(Column.ColumnData var1);

    public Number formatNumber(Column.ColumnData var1);

    public String formatTitle(String var1);

    public String sortValue(Column.ColumnData var1);

    public String sortType();

    public int getColSpan();

    public boolean isWithinThreshold(Column.ColumnData var1, float var2, float var3);

    public static class LongBarGraphColumnFormat
    extends BarGraphColumnFormat {
        int getBarSize() {
            return 200;
        }
    }

    public static class ShortBarGraphColumnFormat
    extends BarGraphColumnFormat {
        int getBarSize() {
            return 40;
        }
    }

    public static abstract class BarGraphColumnFormat
    extends PercentageColumnFormat {
        public String format(Column.ColumnData data) {
            try {
                return HtmlReporter.renderHtmlBarTable(this.toPcData(data).getPcValue(), this.getBarSize(), data.getCustomClass(), this.toPcData(data).getCustomPositiveClass(), this.toPcData(data).getCustomNegativeClass());
            }
            catch (Exception e) {
                Logger.getInstance().warn("Error rendering bar graph.", e);
                return "-";
            }
        }

        public String formatTitle(String name) {
            return name;
        }

        public int getColSpan() {
            return 2;
        }

        abstract int getBarSize();
    }

    public static class PercentageColumnFormat
    extends FloatColumnFormat {
        public String format(Column.ColumnData data) {
            return Formatting.getPercentStr(this.toPcData(data).getPcValue());
        }

        public Number formatNumber(Column.ColumnData data) {
            return new Float(this.toPcData(data).getPcValue() * 100.0f);
        }

        public String sortValue(Column.ColumnData data) {
            return Float.toString(this.toPcData(data).getPcValue());
        }

        public String formatTitle(String name) {
            return "% " + name;
        }

        public boolean isWithinThreshold(Column.ColumnData data, float min, float max) {
            float pcValue = this.toPcData(data).getPcValue() * 100.0f;
            return min <= pcValue && pcValue <= max;
        }

        Column.PcColumnData toPcData(Column.ColumnData data) {
            return (Column.PcColumnData)data;
        }
    }

    public static class FloatColumnFormat
    implements ColumnFormat {
        public String format(Column.ColumnData data) {
            return Formatting.formatFloat(data.getValue());
        }

        public Number formatNumber(Column.ColumnData data) {
            return new Float(data.getValue());
        }

        public String formatTitle(String name) {
            return name;
        }

        public String sortValue(Column.ColumnData data) {
            return Float.toString(data.getValue());
        }

        public String sortType() {
            return ColumnFormat.SORT_TYPE_NUMBER;
        }

        public int getColSpan() {
            return 1;
        }

        public boolean isWithinThreshold(Column.ColumnData data, float min, float max) {
            return min <= data.getValue() && data.getValue() <= max;
        }
    }

    public static class ErrorColumnFormat
    implements ColumnFormat {
        private final String errorMsg;

        public ErrorColumnFormat(String msg) {
            this.errorMsg = msg;
        }

        public String format(Column.ColumnData data) {
            return this.errorMsg;
        }

        public Number formatNumber(Column.ColumnData data) {
            return new Integer(-1);
        }

        public String formatTitle(String name) {
            return name;
        }

        public String sortValue(Column.ColumnData data) {
            return "-";
        }

        public String sortType() {
            return "";
        }

        public int getColSpan() {
            return 1;
        }

        public boolean isWithinThreshold(Column.ColumnData data, float min, float max) {
            return true;
        }
    }

    public static class IntColumnFormat
    extends FloatColumnFormat {
        public String format(Column.ColumnData data) {
            return Formatting.formatInt((int)data.getValue());
        }

        public Number formatNumber(Column.ColumnData data) {
            return new Integer((int)data.getValue());
        }
    }

    public static class Factory {
        private static final Map FORMATS = new HashMap();

        static ColumnFormat createFormat(String format) {
            return FORMATS.containsKey(format) ? (ColumnFormat)FORMATS.get(format) : new PercentageColumnFormat();
        }

        static {
            FORMATS.put(ColumnFormat.RAW, new FloatColumnFormat());
            FORMATS.put(ColumnFormat.BAR, new ShortBarGraphColumnFormat());
            FORMATS.put(ColumnFormat.SHORTBAR, new ShortBarGraphColumnFormat());
            FORMATS.put(ColumnFormat.LONGBAR, new LongBarGraphColumnFormat());
            FORMATS.put(ColumnFormat.PC, new PercentageColumnFormat());
            FORMATS.put(ColumnFormat.PERCENTAGE, new PercentageColumnFormat());
        }
    }
}

