/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Boolean;
import com.cenqua.clover.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class InitStringData
implements Serializable {
    private final String initString;
    private final Map<String, String> initStringMap;

    public InitStringData(String initString) {
        this.initString = initString;
        this.initStringMap = new HashMap<String, String>();
        StringTokenizer tok = new StringTokenizer(initString, ";");
        while (tok.hasMoreTokens()) {
            String keyValue = tok.nextToken();
            String[] pair = keyValue.split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Invalid key=value pair, '" + keyValue + "'  for initString: " + initString);
            }
            this.initStringMap.put(pair[0].trim(), pair[1].trim());
        }
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = this.initStringMap.get(key);
        return value == null ? defaultValue : value;
    }

    public int get(String key, int defaultValue) {
        String value = this.initStringMap.get(key);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Logger.getInstance().warn("Value for key: " + key + " not a number: " + value + " - " + e.getMessage());
            return defaultValue;
        }
    }

    public boolean get(String key, boolean defaultValue) {
        String value = this.initStringMap.get(key);
        return value == null ? defaultValue : _Boolean.parseBoolean(value);
    }

    public void set(String key, boolean value) {
        this.initStringMap.put(key, Boolean.toString(value));
    }

    public void set(String key, String value) {
        this.initStringMap.put(key, value);
    }

    public void set(String key, int value) {
        this.set(key, Integer.toString(value));
    }

    public String toString() {
        return this.initString;
    }
}

