/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.cenqua.clover.Logger;
import com.cenqua.clover.remote.Config;
import com.cenqua.clover.remote.InitStringData;
import java.io.Serializable;

public class DistributedConfig
implements Config,
Serializable {
    public static final String OFF = "OFF";
    public static final String ON = "ON";
    private final InitStringData data;
    public static final String NAME = "name";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String TIMEOUT = "timeout";
    public static final String NUM_CLIENTS = "numClients";
    public static final String RETRY_PERIOD = "retryPeriod";

    public static DistributedConfig ON() {
        return new DistributedConfig(ON);
    }

    public static DistributedConfig OFF() {
        return new DistributedConfig(OFF);
    }

    public DistributedConfig(String str) {
        Logger.getInstance().verbose("DistributedConfig: data = " + str);
        this.data = OFF.equalsIgnoreCase(str) ? null : (ON.equalsIgnoreCase(str) ? new InitStringData("") : new InitStringData(str));
    }

    public DistributedConfig() {
        this("");
    }

    public boolean isEnabled() {
        return this.data != null;
    }

    public String getName() {
        return this.data.get(NAME, "clover.tcp.server");
    }

    public void setName(String value) {
        this.data.set(NAME, value);
    }

    public int getPort() {
        return this.data.get(PORT, 1198);
    }

    public void setPort(int value) {
        this.data.set(PORT, value);
    }

    public String getHost() {
        return this.data.get(HOST, "localhost");
    }

    public void setHost(String value) {
        this.data.set(HOST, value);
    }

    public int getTimeout() {
        return this.data.get(TIMEOUT, 5000);
    }

    public void setTimeout(int value) {
        this.data.set(TIMEOUT, value);
    }

    public int getNumClients() {
        return this.data.get(NUM_CLIENTS, 0);
    }

    public void setNumClients(int value) {
        this.data.set(NUM_CLIENTS, value);
    }

    public int getRetryPeriod() {
        return this.data.get(RETRY_PERIOD, 1000);
    }

    public void setRetryPeriod(int value) {
        this.data.set(RETRY_PERIOD, value);
    }

    public String getServerLocation() {
        return this.getHost() + ":" + this.getPort();
    }

    public String toString() {
        if (!this.isEnabled()) {
            return null;
        }
        return _String.format("%s=%s;%s=%s;%s=%d;%s=%d;%s=%d;%s=%d", new Object[]{NAME, this.getName(), HOST, this.getHost(), PORT, _Integer.valueOf(this.getPort()), TIMEOUT, _Integer.valueOf(this.getTimeout()), NUM_CLIENTS, _Integer.valueOf(this.getNumClients()), RETRY_PERIOD, _Integer.valueOf(this.getRetryPeriod())});
    }

    public String getConfigString() {
        if (this.data == null) {
            return OFF;
        }
        if (this.data.toString().length() == 0) {
            return ON;
        }
        return this.data.toString();
    }
}

