/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import com.cenqua.clover.CloverProperties;
import com.cenqua.clover.Logger;
import com.cenqua.clover.remote.Config;
import com.cenqua.clover.remote.RecorderListener;
import com.cenqua.clover.remote.RecorderService;
import com.cenqua.clover.remote.RemoteFactory;
import com.cenqua.clover.remote.RpcMessage;
import com.cenqua.clover.util.Color;
import java.util.Arrays;

public class DistributedClover {
    private final RecorderService service;
    private final RecorderListener client;
    private final boolean serverMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedClover(CloverProperties cloverProperties) {
        this.serverMode = cloverProperties.getBooleanProperty("clover.server", false);
        RecorderService service = null;
        RecorderListener client = null;
        try {
            String distributedConfigString = cloverProperties.getProperty("clover.distributed.coverage");
            if (distributedConfigString == null) {
                Logger.getInstance().verbose("Distributed coverage is disabled.'");
                return;
            }
            Config config = RemoteFactory.getInstance().createConfig(distributedConfigString);
            if (!config.isEnabled()) {
                Logger.getInstance().verbose("Distributed coverage is disabled via config: " + distributedConfigString);
                return;
            }
            Logger.getInstance().info("Distributed coverage is enabled with: " + config);
            if (this.serverMode) {
                client = null;
                service = this.createServer(config);
            } else {
                service = null;
                client = this.createClient(config);
            }
        }
        catch (Exception e) {
            Logger.getInstance().error("Could not initialise Distributed Coverage collection in Clover: " + e.getMessage(), e);
            client = null;
            service = null;
        }
        finally {
            this.client = client;
            this.service = service;
        }
    }

    public void remoteFlush(RpcMessage message) {
        if (this.serverMode && this.service != null) {
            if (Logger.isDebug()) {
                Logger.getInstance().debug(message.getName() + "( " + Arrays.asList(message.getMethodArgs()) + ")");
            }
            long remstart = System.currentTimeMillis();
            this.service.sendMessage(message);
            if (Logger.isDebug()) {
                Logger.getInstance().debug(message.getName() + " remote flush took: " + (System.currentTimeMillis() - remstart) + " ms");
            }
        }
    }

    private RecorderService createServer(Config config) {
        Logger.getInstance().info(Color.make("Starting distributed coverage service.").blue().toString());
        RecorderService service = RemoteFactory.getInstance().createService(config);
        service.start();
        return service;
    }

    private RecorderListener createClient(Config config) {
        RecorderListener client = RemoteFactory.getInstance().createListener(config);
        Logger.getInstance().info(Color.make("Starting distributed coverage client: " + config).blue().toString());
        client.connect();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        DistributedClover distributedClover = this;
        synchronized (distributedClover) {
            if (this.client != null) {
                this.client.disconnect();
            }
            if (this.service != null) {
                this.service.stop();
            }
        }
    }

    boolean isServiceMode() {
        return this.service != null;
    }
}

