/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.org.apache.commons.lang.mutable.MutableLong;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import com.cenqua.clover.BaseCoverageRecording;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.GlobalCoverageRecordingTranscript;
import com.cenqua.clover.util.CoverageUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

public class FileBasedCoverageRecordingTranscript
extends BaseCoverageRecording
implements GlobalCoverageRecordingTranscript {
    protected int[] hitCounts;
    protected long coverageSum;

    public FileBasedCoverageRecordingTranscript(BaseCoverageRecording.Header header, File fileOnDisk) {
        super(header, fileOnDisk);
    }

    public long getCoverageSum() {
        return this.coverageSum;
    }

    public void read(DataInputStream in, CoverageDataSpec spec) throws IOException {
        MutableLong sum = new MutableLong(0L);
        this.hitCounts = CoverageUtils.readCoverageAndSumCoverage(in, sum);
        this.coverageSum = sum.longValue();
    }

    public int get(int slotIndex) {
        return this.hitCounts[slotIndex];
    }

    public int getCount() {
        return this.hitCounts.length;
    }

    public int addTo(int[] coverage) {
        int max = Math.min(this.hitCounts.length, coverage.length);
        for (int i = 0; i < max; ++i) {
            int n = i;
            coverage[n] = coverage[n] + this.hitCounts[i];
        }
        return max;
    }

    public String toString() {
        return "FileBasedCoverageRecordingTranscript[header=" + this.header + ", coverageSum=" + this.coverageSum + ", hitCounts.length=" + (this.hitCounts == null ? null : _Integer.valueOf(this.hitCounts.length)) + ']';
    }
}

