/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.ApplicationCoverage;
import com.cenqua.clover.BaseTCILookupStore;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.GlobalCoverageRecordingTranscript;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestCoverage;
import com.cenqua.clover.PerTestRecordingTranscript;
import com.cenqua.clover.cfg.StorageSize;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataRange;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.CloverBitSet;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageData
extends BaseTCILookupStore
implements ApplicationCoverage,
PerTestCoverage {
    public static final StorageSize DEFAULT_EST_PER_TEST_COV_SIZE = StorageSize.fromString("256m");
    public static final int DEFAULT_EST_PER_TEST_RECORDINGS = 1000;
    private final int[] hitCounts;
    private final PerTestCoverage perTestCoverage;
    private boolean empty;
    private long timestamp;
    private final long registryVersion;

    public CoverageData(Clover2Registry registry) {
        this(registry, new CoverageDataSpec());
    }

    public CoverageData(Clover2Registry registry, CoverageDataSpec spec) {
        this(registry, spec, 1000);
    }

    public CoverageData(long timestamp, int[] hitCounts, PerTestCoverage perTestCoverage) {
        this.timestamp = timestamp;
        this.hitCounts = hitCounts;
        this.perTestCoverage = perTestCoverage;
        this.registryVersion = 0L;
        this.empty = false;
    }

    private CoverageData(Clover2Registry registry, CoverageDataSpec spec, int estPerTestRecordings) {
        this.hitCounts = new int[registry.getDataLength()];
        this.registryVersion = registry.getVersion();
        this.perTestCoverage = spec.getPerTestStrategy().build(registry, spec, estPerTestRecordings);
        this.empty = true;
    }

    CoverageData(Clover2Registry registry, CoverageData other, CoverageDataSpec spec) {
        super(other.getTciLookups());
        this.timestamp = other.timestamp;
        this.hitCounts = new int[registry.getDataLength()];
        System.arraycopy(other.hitCounts, 0, this.hitCounts, 0, Math.min(other.hitCounts.length, this.hitCounts.length));
        this.registryVersion = registry.getVersion();
        this.perTestCoverage = this.registryVersion == other.registryVersion ? other.perTestCoverage : spec.getPerTestStrategy().build(registry, spec, 1000);
        this.empty = other.empty;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void resolve(Clover2Registry registry) {
        for (TestCaseInfo info : this.perTestCoverage.getTests()) {
            info.resolve(registry.getProject());
        }
    }

    public int[] getHitCounts() {
        return this.hitCounts;
    }

    @Override
    public int getHitCount(int index) {
        if (index < this.hitCounts.length) {
            return this.hitCounts[index];
        }
        return 0;
    }

    @Override
    public int getCoverageSize() {
        return this.hitCounts.length;
    }

    public BitSet getPassOnlyAndIncidentalHits() {
        BitSet passOnlyTestHits = this.perTestCoverage.getPassOnlyHits();
        BitSet allTestHits = this.perTestCoverage.getAllHits();
        BitSet allHits = CloverBitSet.fromIntArray(this.hitCounts);
        allHits.andNot(allTestHits);
        passOnlyTestHits.or(allHits);
        return passOnlyTestHits;
    }

    @Override
    public TestCaseInfo getTestById(int testId) {
        return this.perTestCoverage.getTestById(testId);
    }

    @Override
    public BitSet getPassOnlyHits() {
        return this.perTestCoverage.getPassOnlyHits();
    }

    @Override
    public BitSet getHitsFor(TestCaseInfo tci) {
        return this.perTestCoverage.getHitsFor(tci);
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis) {
        return this.perTestCoverage.getHitsFor(tcis);
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis, CoverageDataRange range) {
        return this.perTestCoverage.getHitsFor(tcis, range);
    }

    @Override
    public BitSet getUniqueHitsFor(TestCaseInfo tci) {
        return this.perTestCoverage.getUniqueHitsFor(tci);
    }

    @Override
    public BitSet getUniqueHitsFor(Set<TestCaseInfo> tcis) {
        return this.perTestCoverage.getUniqueHitsFor(tcis);
    }

    @Override
    public boolean hasPerTestData() {
        return this.perTestCoverage.hasPerTestData();
    }

    @Override
    public Set<TestCaseInfo> getTests() {
        return this.perTestCoverage.getTests();
    }

    @Override
    public Set<TestCaseInfo> getTestsCovering(CoverageDataRange range) {
        return this.perTestCoverage.getTestsCovering(range);
    }

    @Override
    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FileInfo fileInfo) {
        return this.perTestCoverage.mapTestsAndCoverageForFile(fileInfo);
    }

    @Override
    public BitSet getAllHits() {
        return this.perTestCoverage.getAllHits();
    }

    @Override
    public void addCoverage(TestCaseInfo tci, PerTestRecordingTranscript recording) {
        this.perTestCoverage.addCoverage(tci, recording);
    }

    @Override
    public void addCoverage(GlobalCoverageRecordingTranscript recording) {
        int added = recording.addTo(this.hitCounts);
        if (added != recording.getCount()) {
            Logger.getInstance().verbose(new StringBuffer().append("Truncated recording file before adding to global coverage: ").append(recording).toString());
        }
        this.empty = false;
    }

    public static Set<TestCaseInfo> tcisInHitRange(Map<TestCaseInfo, BitSet> tcisAndHits, CoverageDataRange range) {
        HashSet<TestCaseInfo> hits = new HashSet<TestCaseInfo>();
        for (Map.Entry<TestCaseInfo, BitSet> tciAndHits : tcisAndHits.entrySet()) {
            int startIdx = range.getDataIndex();
            int endIdx = range.getDataIndex() + range.getDataLength();
            int hitIdx = tciAndHits.getValue().nextSetBit(startIdx);
            if (hitIdx == -1 || hitIdx >= endIdx) continue;
            hits.add(tciAndHits.getKey());
        }
        return hits;
    }

    public void avoidObviousOverflow() {
        int max = Integer.MAX_VALUE;
        for (int i = 0; i < this.hitCounts.length; ++i) {
            if (this.hitCounts[i] >= 0) continue;
            this.hitCounts[i] = Integer.MAX_VALUE;
        }
    }

    public PerTestCoverage getPerTestCoverage() {
        return this.perTestCoverage;
    }
}

