/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.PerTestCoverage;
import com.cenqua.clover.registry.TestCaseInfo;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePerTestCoverage
implements PerTestCoverage,
Serializable {
    private static final long serialVersionUID = 8596722259646445122L;
    protected final int coverageSize;
    protected transient BitSet uniqueCoverageMask;

    public BasePerTestCoverage(int coverageSize) {
        this.coverageSize = coverageSize;
    }

    @Override
    public int getCoverageSize() {
        return this.coverageSize;
    }

    protected BitSet getUniqueCoverageMask() {
        if (this.uniqueCoverageMask == null) {
            this.initMasks();
        }
        return this.uniqueCoverageMask;
    }

    protected abstract void initMasks();

    @Override
    public BitSet getUniqueHitsFor(TestCaseInfo tci) {
        BitSet hits = this.getHitsFor(tci);
        hits = (BitSet)hits.clone();
        hits.and(this.getUniqueCoverageMask());
        return hits;
    }

    @Override
    public BitSet getUniqueHitsFor(Set<TestCaseInfo> slices) {
        if (slices.size() == 1) {
            return this.getUniqueHitsFor(slices.iterator().next());
        }
        BitSet coverage = this.getHitsFor(slices, null);
        HashSet<TestCaseInfo> otherSlices = new HashSet<TestCaseInfo>(this.getTests());
        otherSlices.removeAll(slices);
        BitSet otherCoverage = this.getHitsFor(otherSlices, null);
        coverage.andNot(otherCoverage);
        return coverage;
    }
}

