/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.services;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.Iterable_;
import com.atlassian.clover.services.ServiceNotAvailableException;
import com.cenqua.clover.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator<S>
implements Iterable_<S> {
    private final Class<S> spi;
    private final List<URL> providers;

    private ServiceLocator(Class<S> spi, List<URL> providers) {
        this.spi = spi;
        this.providers = providers;
    }

    @Override
    public Iterator<S> iterator() {
        final Iterator<URL> providerIterator = this.providers.iterator();
        return new Iterator<S>(){

            @Override
            public boolean hasNext() {
                return providerIterator.hasNext();
            }

            @Override
            public S next() {
                URL provider = (URL)providerIterator.next();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(provider.openStream()));
                    String className = reader.readLine().trim();
                    try {
                        return Class.forName(className).newInstance();
                    }
                    catch (Exception e) {
                        throw new ServiceNotAvailableException(new StringBuffer().append("Failed to instantiate service provider ").append(className).toString(), e);
                    }
                }
                catch (IOException e) {
                    throw new ServiceNotAvailableException(new StringBuffer().append("Failed to instantiate service provider for resource ").append(provider).toString(), e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLocator<S> load(Class<S> spi, ClassLoader classLoader) {
        LinkedList<URL> providers = new LinkedList<URL>();
        String serviceResource = new StringBuffer().append("/META-INF/services/").append(spi.getName()).toString();
        try {
            Enumeration<URL> resources = (classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).getResources(serviceResource);
            while (resources.hasMoreElements()) {
                providers.add(resources.nextElement());
            }
        }
        catch (Exception e) {
            Logger.getInstance().warn(new StringBuffer().append("Failed to load service resources ").append(serviceResource).toString(), e);
        }
        return new ServiceLocator<S>(spi, providers);
    }
}

