/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.TestDetector;
import com.cenqua.clover.registry.MethodSignature;
import java.lang.reflect.Modifier;

public class DefaultTestDetector
implements TestDetector {
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        if (sourceContext.areAnnotationsSupported() && typeContext.getModifiers() != null && (typeContext.getModifiers().containsAnnotation("org.testng.annotations.Test") || typeContext.getModifiers().containsAnnotation("Test")) || typeContext.getDocTags() != null && typeContext.getDocTags().containsKey("testng.test")) {
            return true;
        }
        return !(!this.strContains(typeContext.getTypeName(), "test") && !this.strEquals(typeContext.getSuperTypeName(), "TestCase") && !this.strEquals(typeContext.getSuperTypeName(), "junit.framework.TestCase") || !sourceContext.areAnnotationsSupported() && !this.strContains(typeContext.getSuperTypeName(), "test"));
    }

    private boolean strContains(String target, String str) {
        return target != null && target.toLowerCase().indexOf(str) >= 0;
    }

    private boolean strEquals(String target, String str) {
        return target != null && target.equals(str);
    }

    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        MethodSignature signature = methodContext.getSignature();
        if (methodContext != null && !Modifier.isAbstract(signature.getModifiersMask()) && Modifier.isPublic(signature.getModifiersMask()) && signature.getReturnType() != null) {
            if (sourceContext.areAnnotationsSupported() && (signature.getModifiers().containsAnnotation("org.junit.Test") || signature.getModifiers().containsAnnotation("org.testng.annotations.Test") || signature.getModifiers().containsAnnotation("Test")) && !signature.getModifiers().containsAnnotation("org.junit.Ignore") && !signature.getModifiers().containsAnnotation("Ignore") || signature.getTags().containsKey("test") || signature.getTags().containsKey("testng.test")) {
                return true;
            }
            if (signature.getName().startsWith("test") && !signature.hasParams()) {
                return true;
            }
        }
        return false;
    }
}

