/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.InstrumentationState;
import com_cenqua_clover.CloverVersionInfo;
import com_cenqua_clover.CoverageRecorder;
import java.util.Locale;

public class RecorderInstrEmitter
extends Emitter {
    private static final String INCOMPATIBLE_MSG = "[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.";
    private static final String DEFAULT_CLASSNOTFOUND_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised. Are you sure you have Clover in the runtime classpath?";
    private static final String UNEXPECTED_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised because of an unexpected error.";
    private boolean isEnum;
    private boolean reportInitErrors;
    private boolean classInstrStrategy;
    private String recorderPrefix;
    private long recorderCfg;
    private String initString;
    private long registryVersion;
    private int maxDataIndex;
    private String javaLangPrefix;
    private boolean testClass;
    private String distributedConfig;
    private String classNotFoundMsg;
    private boolean shouldEmitWarningMethod;
    static /* synthetic */ Class class$com_cenqua_clover$CoverageRecorder;

    public RecorderInstrEmitter(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void init(InstrumentationState state) {
        this.recorderCfg = RecorderInstrEmitter.getConfigBits(state.getCfg());
        this.recorderPrefix = state.getRecorderPrefix();
        this.classInstrStrategy = state.getCfg().isClassInstrStrategy();
        this.reportInitErrors = state.getCfg().isReportInitErrors();
        this.initString = state.getCfg().getInitString();
        this.distributedConfig = state.getCfg().getDistributedConfigString();
        this.registryVersion = state.getSession().getVersion();
        this.javaLangPrefix = state.getCfg().getJavaLangPrefix();
        this.testClass = state.isDetectTests();
        this.classNotFoundMsg = state.getCfg().getClassNotFoundMsg() != null ? state.getCfg().getClassNotFoundMsg() : DEFAULT_CLASSNOTFOUND_MSG;
        boolean bl = this.shouldEmitWarningMethod = !state.hasInstrumented();
        if (!state.hasInstrumented()) {
            state.setHasInstrumented(true);
        }
    }

    public String getInstr() {
        String instrString;
        if (this.classInstrStrategy || this.isEnum) {
            String recorderBase = this.recorderPrefix.substring(0, this.recorderPrefix.lastIndexOf(46));
            String recorderSuffix = this.recorderPrefix.substring(this.recorderPrefix.lastIndexOf(46) + 1);
            StringBuffer stringBuffer = new StringBuffer().append(this.testClass ? "" : "public ").append("static class ").append(recorderBase).append("{").append("public static ");
            Class<?> clazz = class$com_cenqua_clover$CoverageRecorder;
            if (clazz == null) {
                clazz = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer.append(clazz.getName()).append(" ").append(recorderSuffix).append(";").append("static{").toString();
            StringBuffer stringBuffer2 = new StringBuffer().append(instrString);
            Class<?> clazz2 = class$com_cenqua_clover$CoverageRecorder;
            if (clazz2 == null) {
                clazz2 = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer2.append(clazz2.getName()).append(" _").append(recorderSuffix).append("=null;").toString();
            if (this.reportInitErrors) {
                instrString = instrString + "try{" + (this.shouldEmitWarningMethod ? Bindings.$CloverVersionInfo$oldVersionInClasspath() + ";" : "") + "if(" + CloverVersionInfo.getBuildStamp() + "L!=" + Bindings.$CloverVersionInfo$getBuildStamp() + ")" + "{" + Bindings.$Clover$l("\"[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.\"") + ";" + Bindings.$Clover$l("\"[CLOVER] WARNING: Instr=" + CloverVersionInfo.getReleaseNum() + "#" + CloverVersionInfo.getBuildStamp() + ",Runtime=\"+" + Bindings.$CloverVersionInfo$getReleaseNum() + "+\"#\"+" + Bindings.$CloverVersionInfo$getBuildStamp()) + ";}";
            }
            instrString = instrString + recorderSuffix + "=" + Bindings.$Clover$getNullRecorder() + ";";
            instrString = instrString + "_" + recorderSuffix + "=" + Bindings.$Clover$getNullRecorder() + ";";
            instrString = instrString + "_" + recorderSuffix + "=" + Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), this.registryVersion + "L", this.recorderCfg + "L", Integer.toString(this.maxDataIndex), "new String[]{\"clover.distributed.coverage\"," + RecorderInstrEmitter.asUnicodeString(this.distributedConfig) + "}") + ";";
            if (this.reportInitErrors) {
                instrString = instrString + "}catch(" + this.javaLangPrefix + "SecurityException e){" + this.javaLangPrefix + "System.err.println(\"" + "[CLOVER] FATAL ERROR: Clover could not be initialised because it has insufficient security privileges. Please consult the Clover documentation on the security policy file changes required." + " (\"+e.getClass()+\":\"+e.getMessage()+\")\");";
                instrString = instrString + "}catch(" + this.javaLangPrefix + "NoClassDefFoundError e){" + this.javaLangPrefix + "System.err.println(\"" + this.classNotFoundMsg + " (\"+e.getClass()+\":\"+e.getMessage()+\")\");";
                instrString = instrString + "}catch(" + this.javaLangPrefix + "Throwable t){" + this.javaLangPrefix + "System.err.println(\"" + UNEXPECTED_MSG + " (\"+t.getClass()+\":\"+t.getMessage()+\")\");}";
            }
            instrString = instrString + recorderSuffix + "=" + "_" + recorderSuffix + ";";
            instrString = instrString + "}}";
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public static ");
            Class<?> clazz = class$com_cenqua_clover$CoverageRecorder;
            if (clazz == null) {
                clazz = class$com_cenqua_clover$CoverageRecorder = new CoverageRecorder[0].getClass().getComponentType();
            }
            instrString = stringBuffer.append(clazz.getName()).append(" ").append(this.recorderPrefix).append("=").append(Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), this.registryVersion + "L", this.recorderCfg + "L", Integer.toString(this.maxDataIndex), "new String[]{\"clover.distributed.coverage\"," + RecorderInstrEmitter.asUnicodeString(this.distributedConfig) + "}")).append(";").toString();
        }
        return instrString;
    }

    public static String asUnicodeString(String str) {
        if (str == null) {
            return "null";
        }
        String res = "\"";
        char[] arr$ = str.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c = arr$[i$];
            res = c == '\\' ? res + _String.format(Locale.US, "\\u%04x\\u%04x", new Object[]{_Integer.valueOf(c), _Integer.valueOf(c)}) : res + _String.format(Locale.US, "\\u%04x", new Object[]{_Integer.valueOf(c)});
        }
        res = res + "\"";
        return res;
    }

    public void setMaxDataIndex(int maxIndex) {
        this.maxDataIndex = maxIndex;
    }

    private static long getConfigBits(InstrumentationConfig cfg) {
        return CoverageRecorder.getConfigBits(cfg.getFlushPolicy(), cfg.getFlushInterval(), false, false, !cfg.isSliceRecording());
    }
}

