/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import cloverantlr.LLkParser;
import cloverantlr.NoViableAltException;
import cloverantlr.ParserSharedInputState;
import cloverantlr.RecognitionException;
import cloverantlr.SemanticException;
import cloverantlr.Token;
import cloverantlr.TokenBuffer;
import cloverantlr.TokenStream;
import cloverantlr.TokenStreamException;
import cloverantlr.collections.impl.BitSet;
import com.atlassian.clover.instr.java.ArmInstrEmitter;
import com.atlassian.clover.instr.java.AutoCloseableEmitter;
import com.atlassian.clover.instr.java.ClassEntryNode;
import com.atlassian.clover.instr.java.ClassExitNode;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.CloverTokenStreamFilter;
import com.atlassian.clover.instr.java.ContextTreeNode;
import com.atlassian.clover.instr.java.DirectedFlushEmitter;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.EndBoolInstrEmitter;
import com.atlassian.clover.instr.java.ExpressionInfo;
import com.atlassian.clover.instr.java.FileStructureInfo;
import com.atlassian.clover.instr.java.FlagDeclEmitter;
import com.atlassian.clover.instr.java.FlaggedInstrEmitter;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.JavaTokenTypes;
import com.atlassian.clover.instr.java.MethodEntryInstrEmitter;
import com.atlassian.clover.instr.java.MethodExitInstrEmitter;
import com.atlassian.clover.instr.java.MethodRegistrationNode;
import com.atlassian.clover.instr.java.RecorderInstrEmitter;
import com.atlassian.clover.instr.java.SimpleEmitter;
import com.atlassian.clover.instr.java.StartBoolInstrEmitter;
import com.atlassian.clover.instr.java.StatementInstrEmitter;
import com.atlassian.clover.instr.java.TokenListUtil;
import com.cenqua.clover.Contract;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.Annotation;
import com.cenqua.clover.registry.AnnotationValueCollection;
import com.cenqua.clover.registry.ArrayAnnotationValue;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.Modifiers;
import com.cenqua.clover.registry.Parameter;
import com.cenqua.clover.registry.StringifiedAnnotationValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaRecognizer
extends LLkParser
implements JavaTokenTypes {
    private static final Logger LOG = Logger.getInstance();
    private ContextTreeNode currentContextTreeNode;
    private boolean topLevelClass = true;
    private CloverTokenStreamFilter mFilter;
    private LinkedList classnameList = new LinkedList();
    private boolean constExpr = false;
    private InstrumentationConfig cfg;
    private FileStructureInfo fileInfo;
    private ClassEntryNode currentTopLevelClassEntry;
    private Emitter suppressWarningsInstr = null;
    private boolean existingFallthroughSuppression = false;
    private int ltCounter = 0;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "BLOCK", "MODIFIERS", "OBJBLOCK", "SLIST", "CTOR_DEF", "METHOD_DEF", "VARIABLE_DEF", "INSTANCE_INIT", "STATIC_INIT", "TYPE", "CLASS_DEF", "INTERFACE_DEF", "PACKAGE_DEF", "ARRAY_DECLARATOR", "EXTENDS_CLAUSE", "IMPLEMENTS_CLAUSE", "PARAMETERS", "PARAMETER_DEF", "LABELED_STAT", "TYPECAST", "INDEX_OP", "POST_INC", "POST_DEC", "METHOD_CALL", "EXPR", "ARRAY_INIT", "IMPORT", "UNARY_MINUS", "UNARY_PLUS", "CASE_GROUP", "ELIST", "FOR_INIT", "FOR_CONDITION", "FOR_ITERATOR", "EMPTY_STAT", "\"final\"", "\"abstract\"", "\"strictfp\"", "SUPER_CTOR_CALL", "CTOR_CALL", "\"package\"", "SEMI", "\"import\"", "\"static\"", "LBRACK", "RBRACK", "IDENT", "DOT", "LT", "COMMA", "QUESTION", "\"extends\"", "\"super\"", "GT", "SR", "BSR", "\"void\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "STAR", "\"private\"", "\"public\"", "\"protected\"", "\"transient\"", "\"native\"", "\"synchronized\"", "\"volatile\"", "\"class\"", "\"interface\"", "\"enum\"", "AT", "BAND", "LCURLY", "RCURLY", "LPAREN", "RPAREN", "\"default\"", "\"implements\"", "\"this\"", "ASSIGN", "\"throws\"", "ELLIPSIS", "\"assert\"", "COLON", "\"if\"", "\"else\"", "\"for\"", "\"while\"", "\"do\"", "\"break\"", "\"continue\"", "\"return\"", "\"switch\"", "\"throw\"", "\"case\"", "\"try\"", "\"finally\"", "\"catch\"", "BOR", "PLUS_ASSIGN", "MINUS_ASSIGN", "STAR_ASSIGN", "DIV_ASSIGN", "MOD_ASSIGN", "SR_ASSIGN", "BSR_ASSIGN", "SL_ASSIGN", "BAND_ASSIGN", "BXOR_ASSIGN", "BOR_ASSIGN", "LOR", "LAND", "BXOR", "NOT_EQUAL", "EQUAL", "LE", "GE", "\"instanceof\"", "SL", "PLUS", "MINUS", "DIV", "MOD", "INC", "DEC", "BNOT", "LNOT", "\"true\"", "\"false\"", "\"null\"", "\"new\"", "NUM_INT", "CHAR_LITERAL", "STRING_LITERAL", "NUM_FLOAT", "NUM_LONG", "NUM_DOUBLE", "WS", "SL_COMMENT", "ML_COMMENT", "ESC", "VOCAB", "INT_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL", "HEX_FLOAT_LITERAL", "DEC_DIGIT", "BIN_DIGIT", "HEX_DIGIT", "DEC_INT", "HEX_INT", "BIN_INT", "FLOAT_SUFFIX", "EXPONENT", "BINARY_EXPONENT"};
    public static final BitSet _tokenSet_0 = new BitSet(JavaRecognizer.mk_tokenSet_0());

    public JavaRecognizer(CloverTokenStreamFilter filter, InstrumentationConfig cfg, FileStructureInfo fileInfo, ContextTreeNode contextTreeRoot) {
        this(filter);
        this.mFilter = filter;
        this.cfg = cfg;
        this.fileInfo = fileInfo;
        this.currentContextTreeNode = contextTreeRoot;
    }

    private ClassEntryNode enterClass(CloverToken tok, boolean aIsInterface, boolean aIsEnum, boolean isAnnotation) {
        return this.enterClass(null, null, tok, aIsInterface, aIsEnum, isAnnotation, null);
    }

    private ClassEntryNode enterClass(Map tags, Modifiers mods, CloverToken tok, boolean aIsInterface, boolean aIsEnum, boolean isAnnotation, String superclass) {
        String classname = tok.getText();
        int startline = tok.getLine();
        int startcol = tok.getColumn();
        this.classnameList.add(classname);
        String fullname = this.getClassname(this.classnameList);
        ClassEntryNode node = new ClassEntryNode(tags, mods, fullname, this.fileInfo.getPackageName(), superclass, this.getCurrentContext(), startline, startcol, this.topLevelClass, aIsInterface, aIsEnum, isAnnotation);
        tok.addPreEmitter(node);
        if (this.topLevelClass) {
            this.currentTopLevelClassEntry = node;
        }
        return node;
    }

    private void exitClass(CloverToken t, ClassEntryNode entry) {
        Contract.pre(this.classnameList.size() > 0);
        this.classnameList.removeLast();
        t.addPreEmitter(new ClassExitNode(entry, this.getClassname(this.classnameList), t.getLine(), t.getColumn() + t.getText().length()));
    }

    private String getClassname(List classlist) {
        String fullname = "";
        String sep = "";
        Iterator names = this.classnameList.iterator();
        while (names.hasNext()) {
            fullname = fullname + sep + (String)names.next();
            sep = ".";
        }
        return fullname;
    }

    private void enterContext(int newContext) {
        this.currentContextTreeNode = this.currentContextTreeNode.enterContext(newContext);
    }

    private ContextSet getCurrentContext() {
        return this.currentContextTreeNode.getContext();
    }

    private void exitContext() {
        this.currentContextTreeNode = this.currentContextTreeNode.exitContext();
    }

    private void instrStaticRecorderMember(boolean isEnum) {
        if (this.currentTopLevelClassEntry != null && this.currentTopLevelClassEntry.getRecorderInsertPoint() != null) {
            RecorderInstrEmitter recorderInstr = new RecorderInstrEmitter(isEnum);
            this.currentTopLevelClassEntry.setRecorderInstrEmitter(recorderInstr);
            if (isEnum) {
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPreEmitter(new SimpleEmitter(";"));
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPreEmitter(recorderInstr);
            } else {
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPostEmitter(recorderInstr);
            }
        }
    }

    private void instrSuppressWarnings(CloverToken instrPoint) {
        if (this.cfg.isJava15() && !this.existingFallthroughSuppression && this.fileInfo.isSuppressFallthroughWarnings()) {
            if (this.suppressWarningsInstr == null) {
                instrPoint.addPreEmitter(new SimpleEmitter("@" + this.cfg.getJavaLangPrefix() + "SuppressWarnings({\"fallthrough\"}) "));
            }
        } else if (this.suppressWarningsInstr != null) {
            this.suppressWarningsInstr.setEnabled(false);
        }
    }

    private void setRecorderMemberInsertPoint(ClassEntryNode node, CloverToken insertPoint) {
        if (this.topLevelClass) {
            node.setRecorderInsertPoint(insertPoint);
            this.topLevelClass = false;
        }
    }

    private MethodEntryInstrEmitter instrEnterMethod(MethodSignature sig, CloverToken start, CloverToken lcurly, CloverToken skip) {
        CloverToken instrPoint = skip == null ? lcurly : skip;
        MethodRegistrationNode reg = new MethodRegistrationNode(this.getCurrentContext(), sig, start.getLine(), start.getColumn());
        lcurly.addPreEmitter(reg);
        MethodEntryInstrEmitter ret = new MethodEntryInstrEmitter(reg);
        instrPoint.addPostEmitter(ret);
        instrPoint.addPostEmitter(new DirectedFlushEmitter());
        return ret;
    }

    private MethodEntryInstrEmitter instrEnterMethod(MethodSignature sig, CloverToken start, CloverToken lcurly) {
        return this.instrEnterMethod(sig, start, lcurly, null);
    }

    private void instrExitMethod(MethodEntryInstrEmitter entryEmitter, CloverToken tok) {
        tok.addPreEmitter(new MethodExitInstrEmitter(entryEmitter, tok.getLine(), tok.getColumn() + tok.getText().length()));
    }

    private CloverToken maybeAddFlushInstr(CloverToken last) {
        last.addPostEmitter(new DirectedFlushEmitter());
        return last;
    }

    private FlagDeclEmitter declareFlagBefore(CloverToken tok) {
        FlagDeclEmitter flag = new FlagDeclEmitter();
        tok.addPreEmitter(flag);
        return flag;
    }

    private CloverToken instrInlineAfter(CloverToken instr, CloverToken start, CloverToken end) {
        if (this.cfg.isStatementInstrEnabled()) {
            instr.addPostEmitter(new StatementInstrEmitter(this.getCurrentContext(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length()));
            instr.addPostEmitter(new DirectedFlushEmitter());
            this.fileInfo.addStatementMarker(start, end);
        }
        return instr;
    }

    private CloverToken instrInlineAfter(CloverToken tok, CloverToken start, CloverToken end, FlagDeclEmitter flag) {
        if (this.cfg.isStatementInstrEnabled()) {
            tok.addPostEmitter(new FlaggedInstrEmitter(flag, new StatementInstrEmitter(this.getCurrentContext(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length())));
            this.fileInfo.addStatementMarker(start, end);
        }
        return tok;
    }

    private CloverToken instrInlineBefore(CloverToken start, CloverToken end, ContextSet context, int complexity) {
        if (this.cfg.isStatementInstrEnabled()) {
            start.addPreEmitter(new StatementInstrEmitter(context, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), complexity));
        }
        return start;
    }

    private void insertAutoCloseableClassDecl(CloverToken tryBlock) {
        if (this.cfg.isStatementInstrEnabled()) {
            tryBlock.addPreEmitter(new AutoCloseableEmitter());
        }
    }

    private void instrArmDecl(CloverToken start, CloverToken end, ContextSet context) {
        if (this.cfg.isStatementInstrEnabled()) {
            start.addPreEmitter(new ArmInstrEmitter(context, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), 1));
        }
    }

    private void addCloseBraceAfter(CloverToken tok) {
        CloverToken closeBrace = new CloverToken(83, "}");
        closeBrace.setLine(tok.getLine());
        closeBrace.setColumn(tok.getColumn());
        closeBrace.setPrev(tok);
        closeBrace.setNext(tok.getNext());
        tok.setNext(closeBrace);
    }

    private void addOpenBraceAfter(CloverToken tok) {
        CloverToken openBrace = new CloverToken(82, "{");
        openBrace.setLine(tok.getLine());
        openBrace.setColumn(tok.getColumn());
        openBrace.setPrev(tok);
        openBrace.setNext(tok.getNext());
        tok.setNext(openBrace);
    }

    private CloverToken instrBoolExpr(CloverToken begin, CloverToken end) {
        ExpressionInfo expr;
        if (this.cfg.isStatementInstrEnabled() && !(expr = ExpressionInfo.fromTokens(begin, end)).isConstant()) {
            begin.addPreEmitter(new StartBoolInstrEmitter(expr));
            end.addPreEmitter(new EndBoolInstrEmitter(this.getCurrentContext(), begin.getLine(), begin.getColumn() - 1, end.getLine(), end.getColumn() + end.getText().length(), expr));
        }
        return end;
    }

    private boolean maybeEnterDeprecated(CloverToken startOfBlock) {
        Map tags = TokenListUtil.getJDocTagsAndValuesOnBlock(startOfBlock);
        boolean deprecated = tags.containsKey("deprecated");
        if (deprecated) {
            this.enterContext(16);
        }
        return deprecated;
    }

    private void maybeExitDeprecated(boolean dep) {
        if (dep) {
            this.exitContext();
        }
    }

    protected JavaRecognizer(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public JavaRecognizer(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected JavaRecognizer(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public JavaRecognizer(TokenStream lexer) {
        this(lexer, 2);
    }

    public JavaRecognizer(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final void compilationUnit() throws RecognitionException, TokenStreamException {
        boolean synPredMatched4 = false;
        if ((this.LA(1) == 44 || this.LA(1) == 80) && this.LA(2) == 50) {
            int _m4 = this.mark();
            synPredMatched4 = true;
            ++this.inputState.guessing;
            try {
                this.packageDefinition();
            }
            catch (RecognitionException pe) {
                synPredMatched4 = false;
            }
            this.rewind(_m4);
            --this.inputState.guessing;
        }
        if (synPredMatched4) {
            this.packageDefinition();
        } else if (this.LA(1) != 1 && this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 47 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 || this.LA(2) != 1 && this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 46) {
            this.importDefinition();
        }
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80) {
            this.typeDefinition(false);
            if (this.inputState.guessing != 0) continue;
            this.topLevelClass = true;
            this.existingFallthroughSuppression = false;
        }
        this.match(1);
    }

    public final void packageDefinition() throws RecognitionException, TokenStreamException {
        String pn = "";
        Annotation ann = null;
        while (this.LA(1) == 80) {
            ann = this.annotation();
        }
        this.match(44);
        pn = this.identifier();
        this.match(45);
        if (this.inputState.guessing == 0) {
            this.fileInfo.setPackageName(pn);
        }
    }

    public final void importDefinition() throws RecognitionException, TokenStreamException {
        this.match(46);
        if (this.LA(1) == 47) {
            this.match(47);
        } else if (this.LA(1) != 50) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.identifierStar();
        this.match(45);
    }

    public final void typeDefinition(boolean nested) throws RecognitionException, TokenStreamException {
        CloverToken first = null;
        Modifiers mods = null;
        if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80) {
            if (this.inputState.guessing == 0) {
                first = (CloverToken)this.LT(1);
            }
            mods = this.modifiers2(!nested);
            this.typeDefinition2(mods, first, nested);
        } else if (this.LA(1) == 45) {
            this.match(45);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected final Annotation annotation() throws RecognitionException, TokenStreamException {
        Annotation anno = this.annotation2(false);
        return anno;
    }

    public final String identifier() throws RecognitionException, TokenStreamException {
        Token i1 = null;
        Token i2 = null;
        StringBuffer buf = new StringBuffer();
        String str = null;
        i1 = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            buf.append(i1.getText());
        }
        while (this.LA(1) == 51) {
            this.match(51);
            if (this.inputState.guessing == 0) {
                buf.append('.');
            }
            i2 = this.LT(1);
            this.match(50);
            if (this.inputState.guessing != 0) continue;
            buf.append(i2.getText());
        }
        if (this.inputState.guessing == 0) {
            str = buf.toString();
        }
        return str;
    }

    public final void identifierStar() throws RecognitionException, TokenStreamException {
        this.match(50);
        while (this.LA(1) == 51 && this.LA(2) == 50) {
            this.match(51);
            this.match(50);
        }
        if (this.LA(1) == 51) {
            this.match(51);
            this.match(69);
        } else if (this.LA(1) != 45) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final Modifiers modifiers2(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Modifiers mods = new Modifiers();
        int m = 0;
        Annotation ann = null;
        while (true) {
            if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76) {
                m = this.modifier();
                if (this.inputState.guessing != 0) continue;
                mods.setMask(mods.getMask() | m);
                continue;
            }
            if (this.LA(1) != 80 || this.LA(2) != 50) break;
            ann = this.annotation2(instrSuppressWarnings);
            if (this.inputState.guessing != 0) continue;
            mods.addAnnotation(ann);
        }
        return mods;
    }

    public final void typeDefinition2(Modifiers mods, CloverToken first, boolean nested) throws RecognitionException, TokenStreamException {
        boolean isEnum = false;
        String name = null;
        if (this.LA(1) == 77) {
            name = this.classDefinition(mods);
        } else if (this.LA(1) == 78) {
            name = this.interfaceDefinition();
        } else if (this.LA(1) == 79) {
            name = this.enumDefinition();
            if (this.inputState.guessing == 0) {
                isEnum = true;
            }
        } else if (this.LA(1) == 80) {
            name = this.annotationTypeDeclaration();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0 && !nested) {
            this.instrStaticRecorderMember(isEnum);
            this.instrSuppressWarnings(first);
        }
    }

    public final String classDefinition(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken first = (CloverToken)this.LT(0);
        Map tags = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        String superclass = null;
        ClassEntryNode classEntry = null;
        String classname = null;
        String typeParam = null;
        this.match(77);
        if (this.inputState.guessing == 0) {
            tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
            deprecated = this.maybeEnterDeprecated(first);
        }
        id = this.LT(1);
        this.match(50);
        if (this.LA(1) == 52) {
            typeParam = this.typeParameters();
        } else if (this.LA(1) != 55 && this.LA(1) != 82 && this.LA(1) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        superclass = this.superClassClause();
        this.implementsClause();
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(tags, mods, (CloverToken)id, false, false, false, superclass);
        }
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            classname = id.getText();
        }
        return classname;
    }

    public final String interfaceDefinition() throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        String typeParam = null;
        this.match(78);
        if (this.inputState.guessing == 0) {
            deprecated = this.maybeEnterDeprecated((CloverToken)this.LT(0));
        }
        id = this.LT(1);
        this.match(50);
        if (this.LA(1) == 52) {
            typeParam = this.typeParameters();
        } else if (this.LA(1) != 55 && this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass((CloverToken)id, true, false, false);
        }
        this.interfaceExtends();
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            name = id.getText();
        }
        return name;
    }

    public final String enumDefinition() throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(79);
        if (this.inputState.guessing == 0) {
            deprecated = this.maybeEnterDeprecated((CloverToken)this.LT(0));
        }
        id = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass((CloverToken)id, false, true, false);
        }
        this.implementsClause();
        endOfBlock = this.enumBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            name = id.getText();
        }
        return name;
    }

    public final String annotationTypeDeclaration() throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(80);
        this.match(78);
        id = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass((CloverToken)id, false, false, true);
        }
        endOfBlock = this.annotationTypeBody(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            name = id.getText();
        }
        return name;
    }

    public final void declaration() throws RecognitionException, TokenStreamException {
        Modifiers mods = null;
        String type = null;
        mods = this.modifiers();
        type = this.typeSpec();
        this.variableDefinitions();
    }

    public final Modifiers modifiers() throws RecognitionException, TokenStreamException {
        Modifiers mods = this.modifiers2(false);
        return mods;
    }

    public final String typeSpec() throws RecognitionException, TokenStreamException {
        String spec;
        if (this.LA(1) == 50) {
            spec = this.classTypeSpec();
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            spec = this.builtInTypeSpec();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return spec;
    }

    public final void variableDefinitions() throws RecognitionException, TokenStreamException {
        this.variableDeclarator();
        while (this.LA(1) == 53) {
            this.match(53);
            this.variableDeclarator();
        }
    }

    public final String classTypeSpec() throws RecognitionException, TokenStreamException {
        String arrayOpt = "";
        String typeSpec = this.classOrInterfaceType();
        arrayOpt = this.arraySpecOpt();
        if (this.inputState.guessing == 0) {
            typeSpec = typeSpec + arrayOpt;
        }
        return typeSpec;
    }

    public final String builtInTypeSpec() throws RecognitionException, TokenStreamException {
        String arrayOpt = "";
        String spec = this.builtInType();
        arrayOpt = this.arraySpecOpt();
        if (this.inputState.guessing == 0) {
            spec = spec + arrayOpt;
        }
        return spec;
    }

    public final String arraySpecOpt() throws RecognitionException, TokenStreamException {
        String brackets = "";
        while (this.LA(1) == 48 && this.LA(2) == 49) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0) continue;
            brackets = brackets + "[]";
        }
        return brackets;
    }

    public final String classOrInterfaceType() throws RecognitionException, TokenStreamException {
        CloverToken first = null;
        CloverToken last = null;
        String type = null;
        if (this.inputState.guessing == 0) {
            first = (CloverToken)this.LT(1);
        }
        this.match(50);
        if (this.LA(1) == 52) {
            this.typeArguments();
        } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 87 && this.LA(1) != 89 && this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 51 && this.LA(2) == 50) {
            this.match(51);
            this.match(50);
            if (this.LA(1) == 52) {
                this.typeArguments();
                continue;
            }
            if (this.LA(1) == 45 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 58 || this.LA(1) == 59 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 81 || this.LA(1) == 82 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 85 || this.LA(1) == 87 || this.LA(1) == 89 || this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119 || this.LA(1) == 120 || this.LA(1) == 121 || this.LA(1) == 122 || this.LA(1) == 123 || this.LA(1) == 124) continue;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            last = (CloverToken)this.LT(0);
            type = TokenListUtil.getNormalisedSequence(first, last);
        }
        return type;
    }

    public final void typeArguments() throws RecognitionException, TokenStreamException {
        int currentLtLevel = 0;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        this.match(52);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
        }
        if (!(this.LA(1) != 50 && this.LA(1) != 54 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 49 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 87 && this.LA(2) != 89 && this.LA(2) != 91 && this.LA(2) != 93 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124)) {
            this.singleTypeArgument();
            while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 54 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68)) {
                this.match(53);
                this.singleTypeArgument();
            }
        } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 87 && this.LA(1) != 89 && this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 || !_tokenSet_0.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) >= 57 && this.LA(1) <= 59 && (this.LA(2) == 45 || this.LA(2) == 48 || this.LA(2) == 49 || this.LA(2) == 50 || this.LA(2) == 51 || this.LA(2) == 53 || this.LA(2) == 54 || this.LA(2) == 55 || this.LA(2) == 56 || this.LA(2) == 57 || this.LA(2) == 58 || this.LA(2) == 59 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 81 || this.LA(2) == 82 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 85 || this.LA(2) == 87 || this.LA(2) == 89 || this.LA(2) == 91 || this.LA(2) == 93 || this.LA(2) == 108 || this.LA(2) == 109 || this.LA(2) == 110 || this.LA(2) == 111 || this.LA(2) == 112 || this.LA(2) == 113 || this.LA(2) == 114 || this.LA(2) == 115 || this.LA(2) == 116 || this.LA(2) == 117 || this.LA(2) == 118 || this.LA(2) == 119 || this.LA(2) == 120 || this.LA(2) == 121 || this.LA(2) == 122 || this.LA(2) == 123 || this.LA(2) == 124)) {
            this.typeArgumentsEnd();
        } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 87 && this.LA(1) != 89 && this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 || !_tokenSet_0.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void singleTypeArgument() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 50) {
            type = this.classTypeSpec();
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            type = this.builtInTypeSpec();
        } else {
            if (this.LA(1) != 54) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.match(54);
        }
        if (!(this.LA(1) != 55 && this.LA(1) != 56 || this.LA(2) != 50 && this.LA(2) != 54 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68)) {
            if (this.LA(1) == 55) {
                this.match(55);
            } else {
                if (this.LA(1) != 56) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(56);
            }
            if (this.LA(1) == 50) {
                type = this.classTypeSpec();
                return;
            } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
                type = this.builtInTypeSpec();
                return;
            } else {
                if (this.LA(1) != 54) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(54);
            }
            return;
        } else {
            if ((this.LA(1) == 45 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 58 || this.LA(1) == 59 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 81 || this.LA(1) == 82 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 85 || this.LA(1) == 87 || this.LA(1) == 89 || this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119 || this.LA(1) == 120 || this.LA(1) == 121 || this.LA(1) == 122 || this.LA(1) == 123 || this.LA(1) == 124) && _tokenSet_0.member(this.LA(2))) return;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected final void typeArgumentsEnd() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 57) {
            this.match(57);
            if (this.inputState.guessing == 0) {
                --this.ltCounter;
            }
        } else if (this.LA(1) == 58) {
            this.match(58);
            if (this.inputState.guessing == 0) {
                this.ltCounter -= 2;
            }
        } else if (this.LA(1) == 59) {
            this.match(59);
            if (this.inputState.guessing == 0) {
                this.ltCounter -= 3;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final String builtInType() throws RecognitionException, TokenStreamException {
        String type = "";
        if (this.LA(1) == 60) {
            this.match(60);
        } else if (this.LA(1) == 61) {
            this.match(61);
        } else if (this.LA(1) == 62) {
            this.match(62);
        } else if (this.LA(1) == 63) {
            this.match(63);
        } else if (this.LA(1) == 64) {
            this.match(64);
        } else if (this.LA(1) == 65) {
            this.match(65);
        } else if (this.LA(1) == 66) {
            this.match(66);
        } else if (this.LA(1) == 67) {
            this.match(67);
        } else if (this.LA(1) == 68) {
            this.match(68);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            type = this.LT(0).getText();
        }
        return type;
    }

    public final void type() throws RecognitionException, TokenStreamException {
        String spec = null;
        if (this.LA(1) == 50) {
            spec = this.classOrInterfaceType();
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            spec = this.builtInType();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final int modifier() throws RecognitionException, TokenStreamException {
        int m = 0;
        if (this.LA(1) == 70) {
            this.match(70);
            if (this.inputState.guessing == 0) {
                m = 2;
            }
        } else if (this.LA(1) == 71) {
            this.match(71);
            if (this.inputState.guessing == 0) {
                m = 1;
            }
        } else if (this.LA(1) == 72) {
            this.match(72);
            if (this.inputState.guessing == 0) {
                m = 4;
            }
        } else if (this.LA(1) == 47) {
            this.match(47);
            if (this.inputState.guessing == 0) {
                m = 8;
            }
        } else if (this.LA(1) == 73) {
            this.match(73);
            if (this.inputState.guessing == 0) {
                m = 128;
            }
        } else if (this.LA(1) == 39) {
            this.match(39);
            if (this.inputState.guessing == 0) {
                m = 16;
            }
        } else if (this.LA(1) == 40) {
            this.match(40);
            if (this.inputState.guessing == 0) {
                m = 1024;
            }
        } else if (this.LA(1) == 74) {
            this.match(74);
            if (this.inputState.guessing == 0) {
                m = 256;
            }
        } else if (this.LA(1) == 75) {
            this.match(75);
            if (this.inputState.guessing == 0) {
                m = 32;
            }
        } else if (this.LA(1) == 76) {
            this.match(76);
            if (this.inputState.guessing == 0) {
                m = 64;
            }
        } else if (this.LA(1) == 41) {
            this.match(41);
            if (this.inputState.guessing == 0) {
                m = 2048;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return m;
    }

    protected final Annotation annotation2(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Token lparen = null;
        boolean isSuppressWarnings = false;
        boolean ft = false;
        CloverToken ident = null;
        boolean hasArgs = false;
        String annotationName = null;
        Annotation anno = new Annotation();
        this.match(80);
        annotationName = this.identifier();
        if (this.inputState.guessing == 0) {
            ident = (CloverToken)this.LT(0);
            isSuppressWarnings = instrSuppressWarnings && "SuppressWarnings".equals(annotationName);
            anno.setName(annotationName);
        }
        if (this.LA(1) == 84 && this.LA(2) == 85) {
            lparen = this.LT(1);
            this.match(84);
            this.match(85);
        } else {
            boolean synPredMatched287 = false;
            if (this.LA(1) == 84 && this.LA(2) == 50) {
                int _m287 = this.mark();
                synPredMatched287 = true;
                ++this.inputState.guessing;
                try {
                    this.match(84);
                    this.match(50);
                    this.match(89);
                }
                catch (RecognitionException pe) {
                    synPredMatched287 = false;
                }
                this.rewind(_m287);
                --this.inputState.guessing;
            }
            if (synPredMatched287) {
                this.match(84);
                this.annMemberValuePair(anno, isSuppressWarnings);
                while (this.LA(1) == 53) {
                    this.match(53);
                    this.annMemberValuePair(anno, false);
                }
                this.match(85);
                if (this.inputState.guessing == 0) {
                    hasArgs = true;
                }
            } else if (this.LA(1) == 84 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 80 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(84);
                ft = this.annMemberValue2(anno, "value", isSuppressWarnings, true);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    hasArgs = true;
                }
            } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 && this.LA(1) != 83 && this.LA(1) != 85) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0 && isSuppressWarnings && !hasArgs) {
            this.suppressWarningsInstr = new SimpleEmitter("{\"fallthrough\"}");
            SimpleEmitter openParen = new SimpleEmitter("(");
            SimpleEmitter closeParen = new SimpleEmitter(")");
            CloverToken instrPoint = (CloverToken)lparen;
            if (instrPoint == null) {
                instrPoint = ident;
                this.suppressWarningsInstr.addDependent(openParen);
                this.suppressWarningsInstr.addDependent(closeParen);
                instrPoint.addPostEmitter(openParen);
            }
            instrPoint.addPostEmitter(this.suppressWarningsInstr);
            if (lparen == null) {
                instrPoint.addPostEmitter(closeParen);
            }
        }
        return anno;
    }

    public final String typeParameters() throws RecognitionException, TokenStreamException {
        int currentLtLevel = 0;
        CloverToken start = (CloverToken)this.LT(1);
        String asString = null;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        this.match(52);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
        }
        this.typeParameter();
        while (this.LA(1) == 53) {
            this.match(53);
            this.typeParameter();
        }
        if (this.LA(1) >= 57 && this.LA(1) <= 59) {
            this.typeArgumentsEnd();
        } else if (this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 82 && this.LA(1) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
        if (this.inputState.guessing == 0) {
            asString = TokenListUtil.getNormalisedSequence(start, (CloverToken)this.LT(0));
        }
        return asString;
    }

    public final String superClassClause() throws RecognitionException, TokenStreamException {
        String superclass = null;
        if (this.LA(1) == 55) {
            this.match(55);
            superclass = this.classOrInterfaceType();
        } else if (this.LA(1) != 82 && this.LA(1) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return superclass;
    }

    public final void implementsClause() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 87) {
            this.match(87);
            type = this.classOrInterfaceType();
            while (this.LA(1) == 53) {
                this.match(53);
                type = this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final CloverToken classBlock(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        Token rc = null;
        CloverToken t = null;
        ip = this.LT(1);
        this.match(82);
        if (this.inputState.guessing == 0) {
            this.setRecorderMemberInsertPoint(classEntry, (CloverToken)ip);
        }
        while (true) {
            if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 52 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80 || this.LA(1) == 82) {
                this.field(classEntry);
                continue;
            }
            if (this.LA(1) != 45) break;
            this.match(45);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)rc;
        }
        return t;
    }

    public final void interfaceExtends() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 55) {
            this.match(55);
            type = this.classOrInterfaceType();
            while (this.LA(1) == 53) {
                this.match(53);
                type = this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final CloverToken enumBlock(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        boolean topLevelSave = this.topLevelClass;
        CloverToken t = null;
        this.match(82);
        if (!(this.LA(1) != 45 && this.LA(1) != 50 && this.LA(1) != 53 && this.LA(1) != 80 && this.LA(1) != 83 || this.LA(2) != 1 && this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84)) {
            if (this.LA(1) == 50 || this.LA(1) == 80) {
                this.enumConstant();
                while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 80)) {
                    this.match(53);
                    this.enumConstant();
                }
            } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 83) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 53) {
                this.match(53);
            } else if (this.LA(1) != 45 && this.LA(1) != 83) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 45) {
                if (this.inputState.guessing == 0) {
                    topLevelSave = this.topLevelClass;
                    this.topLevelClass = false;
                }
                this.match(45);
                while (true) {
                    if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 52 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80 || this.LA(1) == 82) {
                        this.field(null);
                        continue;
                    }
                    if (this.LA(1) != 45) break;
                    this.match(45);
                }
                if (this.inputState.guessing == 0) {
                    this.topLevelClass = topLevelSave;
                }
            } else if (this.LA(1) != 83) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else if (this.LA(1) != 83 || this.LA(2) != 1 && this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        ip = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)ip;
            this.setRecorderMemberInsertPoint(classEntry, t);
        }
        return t;
    }

    public final CloverToken annotationTypeBody(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        Token endOfBlock = null;
        boolean topLevelSave = this.topLevelClass;
        CloverToken t = null;
        Modifiers mods = null;
        String type = null;
        ip = this.LT(1);
        this.match(82);
        if (this.inputState.guessing == 0) {
            this.setRecorderMemberInsertPoint(classEntry, (CloverToken)ip);
        }
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80) {
            mods = this.modifiers();
            if (this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68) {
                type = this.typeSpec();
                if (this.LA(1) == 50 && this.LA(2) == 84) {
                    this.match(50);
                    this.match(84);
                    this.match(85);
                    if (this.LA(1) == 86) {
                        this.annDefaultValue();
                    } else if (this.LA(1) != 45) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(45);
                    continue;
                }
                if (this.LA(1) == 50 && (this.LA(2) == 45 || this.LA(2) == 48 || this.LA(2) == 53 || this.LA(2) == 89)) {
                    this.variableDefinitions();
                    this.match(45);
                    continue;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) >= 77 && this.LA(1) <= 80) {
                if (this.inputState.guessing == 0) {
                    topLevelSave = this.topLevelClass;
                    this.topLevelClass = false;
                }
                this.typeDefinition2(mods, null, true);
                if (this.inputState.guessing != 0) continue;
                this.topLevelClass = topLevelSave;
                continue;
            }
            if (this.LA(1) == 45) {
                this.match(45);
                continue;
            }
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        endOfBlock = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)endOfBlock;
        }
        return t;
    }

    public final void typeParameter() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 50) {
            this.match(50);
        } else if (this.LA(1) == 54) {
            this.match(54);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 55 && this.LA(2) == 50) {
            this.match(55);
            type = this.classOrInterfaceType();
            while (this.LA(1) == 81) {
                this.match(81);
                type = this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 50 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 82 && this.LA(1) != 87 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void field(ClassEntryNode containingClass) throws RecognitionException, TokenStreamException {
        Token methodName = null;
        CloverToken first = (CloverToken)this.LT(1);
        CloverToken endSig = null;
        String typeParam = null;
        boolean deprecated = false;
        Modifiers mods = null;
        Object name = null;
        MethodSignature signature = null;
        String[] throwsTypes = null;
        String returnType = "";
        String brackets = "";
        Parameter[] parameters = null;
        Map tags = null;
        String typename = null;
        if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 52 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 84)) {
            if (this.inputState.guessing == 0) {
                tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
            }
            mods = this.modifiers();
            if (this.inputState.guessing == 0) {
                boolean bl = deprecated = tags.containsKey("deprecated") || mods.containsAnnotation("Deprecated");
                if (deprecated) {
                    this.enterContext(16);
                }
            }
            if (this.LA(1) == 77) {
                typename = this.classDefinition(mods);
            } else if (this.LA(1) == 78) {
                typename = this.interfaceDefinition();
            } else if (this.LA(1) == 79) {
                typename = this.enumDefinition();
            } else if (this.LA(1) == 80) {
                typename = this.annotationTypeDeclaration();
            } else {
                if (this.LA(1) != 50 && this.LA(1) != 52 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) throw new NoViableAltException(this.LT(1), this.getFilename());
                if (this.LA(1) == 52) {
                    typeParam = this.typeParameters();
                } else if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 50 && this.LA(2) == 84) {
                    signature = this.ctorHead(tags, mods, first);
                    if (this.inputState.guessing == 0) {
                        endSig = (CloverToken)this.LT(0);
                    }
                    this.constructorBody(signature, first, endSig);
                } else {
                    if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52) throw new NoViableAltException(this.LT(1), this.getFilename());
                    returnType = this.typeSpec();
                    if (this.LA(1) == 50 && this.LA(2) == 84) {
                        methodName = this.LT(1);
                        this.match(50);
                        this.match(84);
                        parameters = this.parameterDeclarationList();
                        this.match(85);
                        brackets = this.declaratorBrackets();
                        if (this.LA(1) == 90) {
                            throwsTypes = this.throwsClause();
                        } else if (this.LA(1) != 45 && this.LA(1) != 82) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing == 0) {
                            endSig = (CloverToken)this.LT(0);
                            signature = new MethodSignature(first, (CloverToken)methodName, endSig, tags, mods, methodName.getText(), typeParam, returnType + brackets, parameters, throwsTypes);
                        }
                        if (this.LA(1) == 82) {
                            this.outerCompoundStmt(signature, first, endSig, 4);
                        } else {
                            if (this.LA(1) != 45) throw new NoViableAltException(this.LT(1), this.getFilename());
                            this.match(45);
                        }
                    } else {
                        if (this.LA(1) != 50 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 53 && this.LA(2) != 89) throw new NoViableAltException(this.LT(1), this.getFilename());
                        this.variableDefinitions();
                        this.match(45);
                    }
                }
            }
            if (this.inputState.guessing != 0) return;
            this.maybeExitDeprecated(deprecated);
            return;
        } else if (this.LA(1) == 47 && this.LA(2) == 82) {
            if (this.inputState.guessing == 0) {
                deprecated = this.maybeEnterDeprecated(first);
                signature = new MethodSignature(null, null, null, "<clinit>, line " + first.getLine(), null, null, null, null);
            }
            this.match(47);
            this.outerCompoundStmt(signature, first, null, 1);
            if (this.inputState.guessing != 0) return;
            this.maybeExitDeprecated(deprecated);
            return;
        } else {
            if (this.LA(1) != 82) throw new NoViableAltException(this.LT(1), this.getFilename());
            if (this.inputState.guessing == 0) {
                deprecated = this.maybeEnterDeprecated(first);
                signature = new MethodSignature(null, null, null, "<init>, line " + first.getLine(), null, null, null, null);
            }
            this.outerCompoundStmt(signature, first, null, 2);
            if (this.inputState.guessing != 0) return;
            this.maybeExitDeprecated(deprecated);
        }
    }

    public final void enumConstant() throws RecognitionException, TokenStreamException {
        boolean topLevelSave = this.topLevelClass;
        CloverToken endOfBlock = null;
        Annotation ann = null;
        if (this.inputState.guessing == 0) {
            topLevelSave = this.topLevelClass;
            this.topLevelClass = false;
        }
        while (this.LA(1) == 80) {
            ann = this.annotation();
        }
        this.match(50);
        if (this.LA(1) == 84) {
            this.match(84);
            this.argList();
            this.match(85);
        } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 82 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 82) {
            endOfBlock = this.classBlock(null);
        } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            this.topLevelClass = topLevelSave;
        }
    }

    public final void argList() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.expressionList();
        } else if (this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected final void annDefaultValue() throws RecognitionException, TokenStreamException {
        boolean ft = false;
        this.match(86);
        ft = this.annMemberValue(false, false);
    }

    protected final boolean annMemberValue(boolean isSuppressWarnings, boolean makeArrayAndAdd) throws RecognitionException, TokenStreamException {
        boolean wasFallthroughLiteral = this.annMemberValue2(null, null, isSuppressWarnings, makeArrayAndAdd);
        return wasFallthroughLiteral;
    }

    public final MethodSignature ctorHead(Map tags, Modifiers mods, CloverToken first) throws RecognitionException, TokenStreamException {
        Token ctorName = null;
        MethodSignature sig = null;
        Parameter[] params = null;
        String[] throwsTypes = null;
        ctorName = this.LT(1);
        this.match(50);
        this.match(84);
        params = this.parameterDeclarationList();
        this.match(85);
        if (this.LA(1) == 90) {
            throwsTypes = this.throwsClause();
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken endSig = (CloverToken)this.LT(0);
            sig = new MethodSignature(first, (CloverToken)ctorName, endSig, tags, mods, ctorName.getText(), null, null, params, throwsTypes);
        }
        return sig;
    }

    public final void constructorBody(MethodSignature signature, CloverToken start, CloverToken endSig) throws RecognitionException, TokenStreamException {
        Token lc = null;
        Token rc = null;
        CloverToken endOfInv = null;
        if (this.inputState.guessing == 0) {
            this.enterContext(3);
        }
        lc = this.LT(1);
        this.match(82);
        boolean synPredMatched115 = false;
        if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            int _m115 = this.mark();
            synPredMatched115 = true;
            ++this.inputState.guessing;
            try {
                this.explicitConstructorInvocation();
            }
            catch (RecognitionException pe) {
                synPredMatched115 = false;
            }
            this.rewind(_m115);
            --this.inputState.guessing;
        }
        if (synPredMatched115) {
            endOfInv = this.explicitConstructorInvocation();
        } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 105 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 105 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            CloverToken tmp = this.statement(null);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            MethodEntryInstrEmitter entry = this.instrEnterMethod(signature, start, (CloverToken)lc, endOfInv);
            this.instrExitMethod(entry, (CloverToken)rc);
            this.exitContext();
            this.fileInfo.addMethodMarker(entry, start, endSig, (CloverToken)rc);
        }
    }

    public final Parameter[] parameterDeclarationList() throws RecognitionException, TokenStreamException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter param = null;
        Parameter[] params = new Parameter[]{};
        if (this.LA(1) == 39 || this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 80) {
            param = this.parameterDeclaration();
            if (this.inputState.guessing == 0) {
                parameters.add(param);
            }
            while (this.LA(1) == 53) {
                this.match(53);
                param = this.parameterDeclaration();
                if (this.inputState.guessing != 0) continue;
                parameters.add(param);
            }
        } else if (this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            params = parameters.toArray(new Parameter[parameters.size()]);
        }
        return params;
    }

    public final String declaratorBrackets() throws RecognitionException, TokenStreamException {
        String brackets = "";
        while (this.LA(1) == 48) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0) continue;
            brackets = brackets + "[]";
        }
        return brackets;
    }

    public final String[] throwsClause() throws RecognitionException, TokenStreamException {
        ArrayList<String> throwsList = new ArrayList<String>();
        String[] throwsTypes = null;
        this.match(90);
        String id = this.identifier();
        if (this.inputState.guessing == 0) {
            throwsList.add(id);
        }
        while (this.LA(1) == 53) {
            this.match(53);
            id = this.identifier();
            if (this.inputState.guessing != 0) continue;
            throwsList.add(id);
        }
        if (this.inputState.guessing == 0) {
            throwsTypes = throwsList.toArray(new String[throwsList.size()]);
        }
        return throwsTypes;
    }

    public final void outerCompoundStmt(MethodSignature sig, CloverToken start, CloverToken endSig, int context) throws RecognitionException, TokenStreamException {
        Token lc = null;
        Token rc = null;
        if (this.inputState.guessing == 0) {
            this.enterContext(context);
        }
        lc = this.LT(1);
        this.match(82);
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            CloverToken tmp = this.statement(null);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            MethodEntryInstrEmitter entry = this.instrEnterMethod(sig, start, (CloverToken)lc);
            this.instrExitMethod(entry, (CloverToken)rc);
            this.exitContext();
            if (context == 4) {
                this.fileInfo.addMethodMarker(entry, start, endSig, (CloverToken)rc);
            }
        }
    }

    public final CloverToken explicitConstructorInvocation() throws RecognitionException, TokenStreamException {
        Token pos1 = null;
        Token t1 = null;
        Token pos2 = null;
        Token lp2 = null;
        Token t2 = null;
        Token pos3 = null;
        Token lp3 = null;
        Token t3 = null;
        CloverToken t = null;
        if (this.LA(1) == 88 && this.LA(2) == 84) {
            pos1 = this.LT(1);
            this.match(88);
            this.match(84);
            this.argList();
            this.match(85);
            t1 = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter((CloverToken)t1, (CloverToken)pos1, (CloverToken)t1);
            }
        } else if (this.LA(1) == 56 && this.LA(2) == 84) {
            pos2 = this.LT(1);
            this.match(56);
            lp2 = this.LT(1);
            this.match(84);
            this.argList();
            this.match(85);
            t2 = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter((CloverToken)t2, (CloverToken)pos2, (CloverToken)t2);
            }
        } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            this.primaryExpression();
            if (this.LA(1) == 51 && this.LA(2) == 88) {
                this.match(51);
                this.match(88);
            } else if (this.LA(1) != 51 || this.LA(2) != 56) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(51);
            pos3 = this.LT(1);
            this.match(56);
            lp3 = this.LT(1);
            this.match(84);
            this.argList();
            this.match(85);
            t3 = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter((CloverToken)t3, (CloverToken)pos3, (CloverToken)t3);
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return t;
    }

    public final CloverToken statement(CloverToken owningLabel) throws RecognitionException, TokenStreamException {
        Token colon = null;
        Token semi = null;
        Token se1 = null;
        Token se2 = null;
        Token rp1 = null;
        Token el = null;
        Token rp = null;
        Token rp2 = null;
        Token d1 = null;
        Token rp3 = null;
        Token sem = null;
        Token sw = null;
        Token rc = null;
        CloverToken first = null;
        CloverToken tmp = null;
        CloverToken labelTok = null;
        boolean assertColonPart = false;
        CloverToken last = null;
        boolean labelled = owningLabel != null;
        FlagDeclEmitter flag = null;
        boolean matchable = true;
        boolean instrumentable = !labelled;
        Object instr = null;
        CloverToken flushAfter = null;
        int complexity = 0;
        int tmpCmp = 0;
        boolean wasDefault = false;
        Modifiers mods = null;
        Parameter parameter = null;
        String classname = null;
        ContextSet saveContext = this.getCurrentContext();
        if (this.inputState.guessing == 0) {
            first = (CloverToken)this.LT(1);
        }
        if (this.LA(1) == 92 && this.cfg.isJava14()) {
            this.match(92);
            if (this.inputState.guessing == 0) {
                this.enterContext(15);
                instrumentable = false;
                saveContext = this.getCurrentContext();
            }
            if (this.inputState.guessing == 0) {
                tmp = (CloverToken)this.LT(1);
            }
            this.expression();
            if (this.LA(1) == 93) {
                colon = this.LT(1);
                this.match(93);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)colon);
                    assertColonPart = true;
                }
                this.expression();
            } else if (this.LA(1) != 45) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            semi = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                if (!assertColonPart) {
                    this.instrBoolExpr(tmp, (CloverToken)semi);
                }
                this.exitContext();
            }
        } else if (this.LA(1) == 82) {
            tmp = this.compoundStatement();
            if (this.inputState.guessing == 0) {
                matchable = false;
                instrumentable = false;
            }
        } else {
            boolean synPredMatched164 = false;
            if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 80)) {
                int _m164 = this.mark();
                synPredMatched164 = true;
                ++this.inputState.guessing;
                try {
                    this.declaration();
                }
                catch (RecognitionException pe) {
                    synPredMatched164 = false;
                }
                this.rewind(_m164);
                --this.inputState.guessing;
            }
            if (synPredMatched164) {
                this.declaration();
                se1 = this.LT(1);
                this.match(45);
                if (this.inputState.guessing == 0) {
                    flushAfter = (CloverToken)se1;
                }
            } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
                this.expression();
                se2 = this.LT(1);
                this.match(45);
                if (this.inputState.guessing == 0) {
                    flushAfter = (CloverToken)se2;
                }
            } else if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 80)) {
                mods = this.modifiers();
                classname = this.classDefinition(mods);
                if (this.inputState.guessing == 0) {
                    instrumentable = false;
                }
            } else if (this.LA(1) == 50 && this.LA(2) == 93) {
                this.match(50);
                this.match(93);
                if (this.inputState.guessing == 0) {
                    labelTok = owningLabel;
                    if (!labelled) {
                        labelTok = first;
                    }
                }
                last = this.statement(labelTok);
            } else if (this.LA(1) == 94) {
                this.match(94);
                if (this.inputState.guessing == 0) {
                    this.enterContext(9);
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)this.LT(1);
                }
                this.expression();
                rp1 = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)rp1);
                    this.addOpenBraceAfter((CloverToken)rp1);
                }
                last = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(last);
                    this.exitContext();
                }
                if (this.LA(1) == 95 && (this.LA(2) == 39 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 45 || this.LA(2) == 47 || this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 70 || this.LA(2) == 71 || this.LA(2) == 72 || this.LA(2) == 73 || this.LA(2) == 74 || this.LA(2) == 75 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 80 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 92 || this.LA(2) == 94 || this.LA(2) == 96 || this.LA(2) == 97 || this.LA(2) == 98 || this.LA(2) == 99 || this.LA(2) == 100 || this.LA(2) == 101 || this.LA(2) == 102 || this.LA(2) == 103 || this.LA(2) == 105 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                    el = this.LT(1);
                    this.match(95);
                    if (this.inputState.guessing == 0) {
                        this.addOpenBraceAfter((CloverToken)el);
                        this.enterContext(10);
                        saveContext = this.getCurrentContext();
                    }
                    last = this.statement(null);
                    if (this.inputState.guessing == 0) {
                        this.addCloseBraceAfter(last);
                        this.exitContext();
                    }
                } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 88 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else if (this.LA(1) == 96) {
                this.match(96);
                if (this.inputState.guessing == 0) {
                    this.enterContext(8);
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                boolean synPredMatched168 = false;
                if (!(this.LA(1) != 39 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 80 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 80 && this.LA(2) != 91)) {
                    int _m168 = this.mark();
                    synPredMatched168 = true;
                    ++this.inputState.guessing;
                    try {
                        this.parameterDeclaration();
                        this.match(93);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched168 = false;
                    }
                    this.rewind(_m168);
                    --this.inputState.guessing;
                }
                if (synPredMatched168) {
                    parameter = this.parameterDeclaration();
                    this.match(93);
                    this.expression();
                } else if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 80 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
                    this.forInit();
                    this.match(45);
                    this.forCond();
                    this.forIter();
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                rp = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.addOpenBraceAfter((CloverToken)rp);
                }
                last = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(last);
                    this.exitContext();
                }
            } else if (this.LA(1) == 97) {
                this.match(97);
                if (this.inputState.guessing == 0) {
                    this.enterContext(6);
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)this.LT(1);
                }
                this.expression();
                rp2 = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)rp2);
                    this.addOpenBraceAfter((CloverToken)rp2);
                }
                last = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(last);
                    this.exitContext();
                }
            } else if (this.LA(1) == 98) {
                d1 = this.LT(1);
                this.match(98);
                if (this.inputState.guessing == 0) {
                    this.addOpenBraceAfter((CloverToken)d1);
                    this.enterContext(7);
                    saveContext = this.getCurrentContext();
                }
                tmp = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(tmp);
                    this.exitContext();
                }
                this.match(97);
                this.match(84);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)this.LT(1);
                }
                this.expression();
                rp3 = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)rp3);
                }
                sem = this.LT(1);
                this.match(45);
                if (this.inputState.guessing == 0) {
                    flushAfter = (CloverToken)sem;
                }
            } else if (this.LA(1) == 99) {
                this.match(99);
                if (this.LA(1) == 50) {
                    this.match(50);
                } else if (this.LA(1) != 45) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(45);
            } else if (this.LA(1) == 100) {
                this.match(100);
                if (this.LA(1) == 50) {
                    this.match(50);
                } else if (this.LA(1) != 45) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(45);
            } else if (this.LA(1) == 101) {
                this.match(101);
                if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
                    this.expression();
                } else if (this.LA(1) != 45) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(45);
            } else if (this.LA(1) == 102) {
                sw = this.LT(1);
                this.match(102);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)sw;
                    if (labelled) {
                        tmp = owningLabel;
                    }
                    flag = this.declareFlagBefore(tmp);
                    this.enterContext(5);
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                this.expression();
                this.match(85);
                this.match(82);
                while (this.LA(1) == 86 || this.LA(1) == 104) {
                    tmpCmp = this.casesGroup(flag);
                    if (this.inputState.guessing != 0) continue;
                    complexity += tmpCmp;
                }
                if (this.inputState.guessing == 0) {
                    this.exitContext();
                }
                rc = this.LT(1);
                this.match(83);
            } else {
                boolean synPredMatched177 = false;
                if (this.LA(1) == 105) {
                    int _m177 = this.mark();
                    synPredMatched177 = true;
                    ++this.inputState.guessing;
                    try {
                        this.tryCatchBlock(labelled);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched177 = false;
                    }
                    this.rewind(_m177);
                    --this.inputState.guessing;
                }
                if (synPredMatched177) {
                    last = this.tryCatchBlock(labelled);
                    if (this.inputState.guessing == 0) {
                        instrumentable = false;
                    }
                } else if (this.LA(1) == 103) {
                    this.match(103);
                    this.expression();
                    this.match(45);
                } else if (this.LA(1) == 75 && this.LA(2) == 84) {
                    this.match(75);
                    this.match(84);
                    this.expression();
                    this.match(85);
                    if (this.inputState.guessing == 0) {
                        this.enterContext(14);
                        saveContext = this.getCurrentContext();
                    }
                    last = this.compoundStatement();
                    if (this.inputState.guessing == 0) {
                        this.exitContext();
                    }
                } else if (this.LA(1) == 45) {
                    this.match(45);
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        if (this.inputState.guessing == 0) {
            if (last == null) {
                last = (CloverToken)this.LT(0);
            }
            if (instrumentable) {
                this.instrInlineBefore(first, last, saveContext, complexity);
            }
            if (flushAfter != null) {
                this.maybeAddFlushInstr(flushAfter);
            }
            if (matchable) {
                this.fileInfo.addStatementMarker(first, last);
            }
        }
        return last;
    }

    public final void primaryExpression() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 50) {
            this.match(50);
        } else if (this.LA(1) >= 141 && this.LA(1) <= 146) {
            this.constant();
        } else if (this.LA(1) == 137) {
            this.match(137);
        } else if (this.LA(1) == 138) {
            this.match(138);
        } else if (this.LA(1) == 88) {
            this.match(88);
        } else if (this.LA(1) == 139) {
            this.match(139);
        } else if (this.LA(1) == 140) {
            this.newExpression();
        } else if (this.LA(1) == 84) {
            this.match(84);
            this.assignmentExpression();
            this.match(85);
        } else if (this.LA(1) == 56) {
            this.match(56);
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            type = this.builtInType();
            while (this.LA(1) == 48) {
                this.match(48);
                this.match(49);
            }
            this.match(51);
            this.match(77);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void variableDeclarator() throws RecognitionException, TokenStreamException {
        String brackets = null;
        this.match(50);
        brackets = this.declaratorBrackets();
        this.varInitializer();
    }

    public final void varInitializer() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 89) {
            this.match(89);
            this.initializer();
        } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void initializer() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.expression();
        } else if (this.LA(1) == 82) {
            this.arrayInitializer();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void arrayInitializer() throws RecognitionException, TokenStreamException {
        this.match(82);
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.initializer();
            while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(53);
                this.initializer();
            }
        } else if (this.LA(1) != 53 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 53) {
            this.match(53);
        } else if (this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(83);
    }

    public final void expression() throws RecognitionException, TokenStreamException {
        this.assignmentExpression();
    }

    public final Parameter parameterDeclaration() throws RecognitionException, TokenStreamException {
        Token i = null;
        Object param = null;
        String brackets = "";
        String type = null;
        Parameter parameter = null;
        this.parameterModifier();
        type = this.typeSpec();
        if (this.LA(1) == 91) {
            this.match(91);
        } else if (this.LA(1) != 50) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        i = this.LT(1);
        this.match(50);
        brackets = this.declaratorBrackets();
        if (this.inputState.guessing == 0) {
            parameter = new Parameter(type + brackets, i.getText());
        }
        return parameter;
    }

    public final void parameterModifier() throws RecognitionException, TokenStreamException {
        Token f = null;
        Annotation ann = null;
        while (this.LA(1) == 80) {
            ann = this.annotation();
        }
        if (this.LA(1) == 39) {
            f = this.LT(1);
            this.match(39);
            while (this.LA(1) == 80) {
                ann = this.annotation();
            }
        } else if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final CloverToken compoundStatement() throws RecognitionException, TokenStreamException {
        Token rc = null;
        CloverToken t = null;
        this.match(82);
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            t = this.statement(null);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)rc;
        }
        return t;
    }

    public final void forInit() throws RecognitionException, TokenStreamException {
        boolean synPredMatched189 = false;
        if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 80)) {
            int _m189 = this.mark();
            synPredMatched189 = true;
            ++this.inputState.guessing;
            try {
                this.declaration();
            }
            catch (RecognitionException pe) {
                synPredMatched189 = false;
            }
            this.rewind(_m189);
            --this.inputState.guessing;
        }
        if (synPredMatched189) {
            this.declaration();
        } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            this.expressionList();
        } else if (this.LA(1) != 45) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void forCond() throws RecognitionException, TokenStreamException {
        Token se = null;
        CloverToken tmp = null;
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            if (this.inputState.guessing == 0) {
                tmp = (CloverToken)this.LT(1);
            }
            this.expression();
            se = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                this.instrBoolExpr(tmp, (CloverToken)se);
            }
        } else if (this.LA(1) == 45) {
            this.match(45);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void forIter() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.expressionList();
        } else if (this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final int casesGroup(FlagDeclEmitter flag) throws RecognitionException, TokenStreamException {
        int tmp = 0;
        int complexity = 0;
        int _cnt180 = 0;
        while (true) {
            if (!(this.LA(1) != 86 && this.LA(1) != 104 || this.LA(2) != 50 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 93 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
                tmp = this.aCase(flag);
                if (this.inputState.guessing == 0) {
                    complexity += tmp;
                }
            } else {
                if (_cnt180 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt180;
        }
        this.caseSList();
        return complexity;
    }

    public final CloverToken tryCatchBlock(boolean labelled) throws RecognitionException, TokenStreamException {
        Token tr = null;
        Token lp = null;
        Token semi = null;
        Token rp = null;
        CloverToken last = null;
        int complexity = 0;
        ContextSet saveContext = this.getCurrentContext();
        tr = this.LT(1);
        this.match(105);
        if (this.LA(1) == 84) {
            lp = this.LT(1);
            this.match(84);
            if (this.inputState.guessing == 0) {
                this.insertAutoCloseableClassDecl((CloverToken)tr);
            }
            this.declaration();
            if (this.inputState.guessing == 0) {
                ++complexity;
                this.instrArmDecl(((CloverToken)lp).getNext(), (CloverToken)this.LT(0), saveContext);
            }
            while (this.LA(1) == 45 && (this.LA(2) == 39 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 47 || this.LA(2) == 50 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 70 || this.LA(2) == 71 || this.LA(2) == 72 || this.LA(2) == 73 || this.LA(2) == 74 || this.LA(2) == 75 || this.LA(2) == 76 || this.LA(2) == 80)) {
                semi = this.LT(1);
                this.match(45);
                this.declaration();
                if (this.inputState.guessing != 0) continue;
                ++complexity;
                this.instrArmDecl(((CloverToken)semi).getNext(), (CloverToken)this.LT(0), saveContext);
            }
            if (this.LA(1) == 45) {
                this.match(45);
            } else if (this.LA(1) != 85) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            rp = this.LT(1);
            this.match(85);
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            this.enterContext(11);
            saveContext = this.getCurrentContext();
        }
        last = this.compoundStatement();
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        while (this.LA(1) == 107) {
            last = this.handler();
            if (this.inputState.guessing != 0) continue;
            ++complexity;
        }
        if (this.LA(1) == 106) {
            this.match(106);
            if (this.inputState.guessing == 0) {
                this.enterContext(13);
                saveContext = this.getCurrentContext();
            }
            last = this.compoundStatement();
            if (this.inputState.guessing == 0) {
                this.exitContext();
            }
        } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 88 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0 && !labelled) {
            this.instrInlineBefore((CloverToken)tr, last, saveContext, complexity);
        }
        return last;
    }

    public final int aCase(FlagDeclEmitter flag) throws RecognitionException, TokenStreamException {
        Token si1 = null;
        Token si2 = null;
        Token t = null;
        Token pos = null;
        int complexity = 0;
        if (this.LA(1) == 104) {
            si1 = this.LT(1);
            this.match(104);
            if (this.inputState.guessing == 0) {
                this.constExpr = true;
            }
            this.expression();
            if (this.inputState.guessing == 0) {
                this.constExpr = false;
                pos = si1;
                ++complexity;
            }
        } else if (this.LA(1) == 86) {
            si2 = this.LT(1);
            this.match(86);
            if (this.inputState.guessing == 0) {
                pos = si2;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        t = this.LT(1);
        this.match(93);
        if (this.inputState.guessing == 0) {
            this.instrInlineAfter((CloverToken)t, (CloverToken)pos, (CloverToken)t, flag);
            this.fileInfo.setSuppressFallthroughWarnings(true);
        }
        return complexity;
    }

    public final void caseSList() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            CloverToken tmp = this.statement(null);
        }
    }

    public final void expressionList() throws RecognitionException, TokenStreamException {
        this.expression();
        while (this.LA(1) == 53) {
            this.match(53);
            this.expression();
        }
    }

    public final CloverToken handler() throws RecognitionException, TokenStreamException {
        String type = null;
        CloverToken last = null;
        this.match(107);
        this.match(84);
        if (this.LA(1) == 39) {
            this.match(39);
        } else if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 80) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 80) {
            this.annotation2(false);
        }
        type = this.typeSpec();
        while (this.LA(1) == 108) {
            this.match(108);
            type = this.typeSpec();
        }
        this.match(50);
        this.match(85);
        if (this.inputState.guessing == 0) {
            this.enterContext(12);
        }
        last = this.compoundStatement();
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        return last;
    }

    public final void assignmentExpression() throws RecognitionException, TokenStreamException {
        this.conditionalExpression();
        if (this.LA(1) == 89 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119) {
            if (this.LA(1) == 89) {
                this.match(89);
            } else if (this.LA(1) == 109) {
                this.match(109);
            } else if (this.LA(1) == 110) {
                this.match(110);
            } else if (this.LA(1) == 111) {
                this.match(111);
            } else if (this.LA(1) == 112) {
                this.match(112);
            } else if (this.LA(1) == 113) {
                this.match(113);
            } else if (this.LA(1) == 114) {
                this.match(114);
            } else if (this.LA(1) == 115) {
                this.match(115);
            } else if (this.LA(1) == 116) {
                this.match(116);
            } else if (this.LA(1) == 117) {
                this.match(117);
            } else if (this.LA(1) == 118) {
                this.match(118);
            } else if (this.LA(1) == 119) {
                this.match(119);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.assignmentExpression();
        } else if (this.LA(1) != 45 && this.LA(1) != 49 && this.LA(1) != 53 && this.LA(1) != 83 && this.LA(1) != 85 && this.LA(1) != 93) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void conditionalExpression() throws RecognitionException, TokenStreamException {
        Token endOfCond = null;
        CloverToken startOfCond = null;
        if (this.inputState.guessing == 0) {
            startOfCond = (CloverToken)this.LT(1);
        }
        this.logicalOrExpression();
        if (this.LA(1) == 54) {
            endOfCond = this.LT(1);
            this.match(54);
            if (this.inputState.guessing == 0 && !this.constExpr) {
                this.instrBoolExpr(startOfCond, (CloverToken)endOfCond);
            }
            this.assignmentExpression();
            this.match(93);
            this.conditionalExpression();
        } else if (this.LA(1) != 45 && this.LA(1) != 49 && this.LA(1) != 53 && this.LA(1) != 83 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void logicalOrExpression() throws RecognitionException, TokenStreamException {
        this.logicalAndExpression();
        while (this.LA(1) == 120) {
            this.match(120);
            this.logicalAndExpression();
        }
    }

    public final void logicalAndExpression() throws RecognitionException, TokenStreamException {
        this.inclusiveOrExpression();
        while (this.LA(1) == 121) {
            this.match(121);
            this.inclusiveOrExpression();
        }
    }

    public final void inclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.exclusiveOrExpression();
        while (this.LA(1) == 108) {
            this.match(108);
            this.exclusiveOrExpression();
        }
    }

    public final void exclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.andExpression();
        while (this.LA(1) == 122) {
            this.match(122);
            this.andExpression();
        }
    }

    public final void andExpression() throws RecognitionException, TokenStreamException {
        this.equalityExpression();
        while (this.LA(1) == 81) {
            this.match(81);
            this.equalityExpression();
        }
    }

    public final void equalityExpression() throws RecognitionException, TokenStreamException {
        this.relationalExpression();
        while (this.LA(1) == 123 || this.LA(1) == 124) {
            if (this.LA(1) == 123) {
                this.match(123);
            } else if (this.LA(1) == 124) {
                this.match(124);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.relationalExpression();
        }
    }

    public final void relationalExpression() throws RecognitionException, TokenStreamException {
        String type = null;
        this.shiftExpression();
        if (this.LA(1) == 45 || this.LA(1) == 49 || this.LA(1) == 52 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 57 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 85 || this.LA(1) == 89 || this.LA(1) == 93 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119 || this.LA(1) == 120 || this.LA(1) == 121 || this.LA(1) == 122 || this.LA(1) == 123 || this.LA(1) == 124 || this.LA(1) == 125 || this.LA(1) == 126) {
            while (this.LA(1) == 52 || this.LA(1) == 57 || this.LA(1) == 125 || this.LA(1) == 126) {
                if (this.LA(1) == 52) {
                    this.match(52);
                } else if (this.LA(1) == 57) {
                    this.match(57);
                } else if (this.LA(1) == 125) {
                    this.match(125);
                } else if (this.LA(1) == 126) {
                    this.match(126);
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.shiftExpression();
            }
        } else if (this.LA(1) == 127) {
            this.match(127);
            type = this.typeSpec();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void shiftExpression() throws RecognitionException, TokenStreamException {
        this.additiveExpression();
        while (this.LA(1) == 58 || this.LA(1) == 59 || this.LA(1) == 128) {
            if (this.LA(1) == 128) {
                this.match(128);
            } else if (this.LA(1) == 58) {
                this.match(58);
            } else if (this.LA(1) == 59) {
                this.match(59);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.additiveExpression();
        }
    }

    public final void additiveExpression() throws RecognitionException, TokenStreamException {
        this.multiplicativeExpression();
        while (this.LA(1) == 129 || this.LA(1) == 130) {
            if (this.LA(1) == 129) {
                this.match(129);
            } else if (this.LA(1) == 130) {
                this.match(130);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.multiplicativeExpression();
        }
    }

    public final void multiplicativeExpression() throws RecognitionException, TokenStreamException {
        this.unaryExpression();
        while (this.LA(1) == 69 || this.LA(1) == 131 || this.LA(1) == 132) {
            if (this.LA(1) == 69) {
                this.match(69);
            } else if (this.LA(1) == 131) {
                this.match(131);
            } else if (this.LA(1) == 132) {
                this.match(132);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.unaryExpression();
        }
    }

    public final void unaryExpression() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 133) {
            this.match(133);
            this.unaryExpression();
        } else if (this.LA(1) == 134) {
            this.match(134);
            this.unaryExpression();
        } else if (this.LA(1) == 130) {
            this.match(130);
            this.unaryExpression();
        } else if (this.LA(1) == 129) {
            this.match(129);
            this.unaryExpression();
        } else if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.unaryExpressionNotPlusMinus();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void unaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 135) {
            this.match(135);
            this.unaryExpression();
            return;
        }
        if (this.LA(1) == 136) {
            this.match(136);
            this.unaryExpression();
            return;
        }
        if (this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146) throw new NoViableAltException(this.LT(1), this.getFilename());
        boolean synPredMatched257 = false;
        if (this.LA(1) == 84 && this.LA(2) >= 60 && this.LA(2) <= 68) {
            int _m257 = this.mark();
            synPredMatched257 = true;
            ++this.inputState.guessing;
            try {
                this.match(84);
                type = this.builtInTypeSpec();
                this.match(85);
                this.unaryExpression();
            }
            catch (RecognitionException pe) {
                synPredMatched257 = false;
            }
            this.rewind(_m257);
            --this.inputState.guessing;
        }
        if (synPredMatched257) {
            this.match(84);
            type = this.builtInTypeSpec();
            this.match(85);
            this.unaryExpression();
            return;
        }
        boolean synPredMatched259 = false;
        if (this.LA(1) == 84 && this.LA(2) == 50) {
            int _m259 = this.mark();
            synPredMatched259 = true;
            ++this.inputState.guessing;
            try {
                this.match(84);
                type = this.classTypeSpec();
                this.match(85);
                this.unaryExpressionNotPlusMinus();
            }
            catch (RecognitionException pe) {
                synPredMatched259 = false;
            }
            this.rewind(_m259);
            --this.inputState.guessing;
        }
        if (synPredMatched259) {
            this.match(84);
            type = this.classTypeSpec();
            this.match(85);
            this.unaryExpressionNotPlusMinus();
            return;
        } else {
            if (this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 49 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 93 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.postfixExpression();
        }
    }

    public final void postfixExpression() throws RecognitionException, TokenStreamException {
        this.primaryExpression();
        while (true) {
            if (this.LA(1) == 51) {
                this.match(51);
                if (this.LA(1) == 50 || this.LA(1) == 52) {
                    if (this.LA(1) == 52) {
                        this.typeArguments();
                    } else if (this.LA(1) != 50) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(50);
                    continue;
                }
                if (this.LA(1) == 88) {
                    this.match(88);
                    continue;
                }
                if (this.LA(1) == 77) {
                    this.match(77);
                    continue;
                }
                if (this.LA(1) == 140) {
                    this.newExpression();
                    continue;
                }
                if (this.LA(1) == 56) {
                    this.match(56);
                    continue;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 48 && this.LA(2) == 49) {
                int _cnt265 = 0;
                while (true) {
                    if (this.LA(1) != 48) {
                        if (_cnt265 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(48);
                    this.match(49);
                    ++_cnt265;
                }
                this.match(51);
                this.match(77);
                continue;
            }
            if (this.LA(1) == 48 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(48);
                this.expression();
                this.match(49);
                continue;
            }
            if (this.LA(1) != 84) break;
            this.match(84);
            this.argList();
            this.match(85);
        }
        if (this.LA(1) == 133) {
            this.match(133);
        } else if (this.LA(1) == 134) {
            this.match(134);
        } else if (this.LA(1) != 45 && this.LA(1) != 49 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 69 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 && this.LA(1) != 125 && this.LA(1) != 126 && this.LA(1) != 127 && this.LA(1) != 128 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 131 && this.LA(1) != 132) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void newExpression() throws RecognitionException, TokenStreamException {
        CloverToken endOfBlock = null;
        String typeParam = null;
        this.match(140);
        if (this.LA(1) == 52) {
            typeParam = this.typeParameters();
        } else if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.type();
        if (this.LA(1) == 84) {
            this.match(84);
            this.argList();
            this.match(85);
            if (this.LA(1) == 82) {
                endOfBlock = this.classBlock(null);
            } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 51 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 69 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 && this.LA(1) != 125 && this.LA(1) != 126 && this.LA(1) != 127 && this.LA(1) != 128 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 131 && this.LA(1) != 132 && this.LA(1) != 133 && this.LA(1) != 134) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else if (this.LA(1) == 48) {
            this.newArrayDeclarator();
            if (this.LA(1) == 82) {
                this.arrayInitializer();
            } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 51 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 69 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 && this.LA(1) != 125 && this.LA(1) != 126 && this.LA(1) != 127 && this.LA(1) != 128 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 131 && this.LA(1) != 132 && this.LA(1) != 133 && this.LA(1) != 134) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void constant() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 141) {
            this.match(141);
        } else if (this.LA(1) == 142) {
            this.match(142);
        } else if (this.LA(1) == 143) {
            this.match(143);
        } else if (this.LA(1) == 144) {
            this.match(144);
        } else if (this.LA(1) == 145) {
            this.match(145);
        } else if (this.LA(1) == 146) {
            this.match(146);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void newArrayDeclarator() throws RecognitionException, TokenStreamException {
        int _cnt281 = 0;
        while (true) {
            if (this.LA(1) == 48 && (this.LA(2) == 49 || this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(48);
                if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
                    this.expression();
                } else if (this.LA(1) != 49) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else {
                if (_cnt281 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(49);
            ++_cnt281;
        }
    }

    protected final void annMemberValuePair(Annotation anno, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        Token name = null;
        boolean ft = false;
        name = this.LT(1);
        this.match(50);
        this.match(89);
        ft = this.annMemberValue2(anno, name.getText(), isSuppressWarnings, true);
    }

    protected final boolean annMemberValue2(AnnotationValueCollection anno, String key, boolean isSuppressWarnings, boolean makeArrayAndAdd) throws RecognitionException, TokenStreamException {
        Token t = null;
        Annotation innerAnno = null;
        boolean wasFallthroughLiteral = false;
        String expr = null;
        boolean synPredMatched294 = false;
        if (this.LA(1) == 143 && (this.LA(2) == 45 || this.LA(2) == 53 || this.LA(2) == 83 || this.LA(2) == 85)) {
            int _m294 = this.mark();
            synPredMatched294 = true;
            ++this.inputState.guessing;
            try {
                this.match(143);
            }
            catch (RecognitionException pe) {
                synPredMatched294 = false;
            }
            this.rewind(_m294);
            --this.inputState.guessing;
        }
        if (synPredMatched294) {
            t = this.LT(1);
            this.match(143);
            if (this.inputState.guessing == 0) {
                wasFallthroughLiteral = "\"fallthrough\"".equalsIgnoreCase(t.getText());
                if (isSuppressWarnings && makeArrayAndAdd) {
                    if (wasFallthroughLiteral) {
                        this.existingFallthroughSuppression = true;
                    } else {
                        this.suppressWarningsInstr = new SimpleEmitter("{");
                        SimpleEmitter closeCurly = new SimpleEmitter("}");
                        SimpleEmitter comma = new SimpleEmitter(",");
                        SimpleEmitter fallthrough = new SimpleEmitter("\"fallthrough\"");
                        ((CloverToken)t).addPreEmitter(this.suppressWarningsInstr);
                        ((CloverToken)t).addPostEmitter(comma);
                        ((CloverToken)t).addPostEmitter(fallthrough);
                        ((CloverToken)t).addPostEmitter(closeCurly);
                        this.suppressWarningsInstr.addDependent(closeCurly);
                        this.suppressWarningsInstr.addDependent(comma);
                        this.suppressWarningsInstr.addDependent(fallthrough);
                    }
                }
                if (anno != null) {
                    anno.put(key, new StringifiedAnnotationValue(t.getText()));
                }
            }
        } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 88 && this.LA(2) != 108 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            expr = this.conditionalExpression2();
            if (this.inputState.guessing == 0 && anno != null) {
                anno.put(key, new StringifiedAnnotationValue(expr));
            }
        } else if (this.LA(1) == 80) {
            innerAnno = this.annotation();
            if (this.inputState.guessing == 0 && anno != null) {
                anno.put(key, innerAnno);
            }
        } else if (this.LA(1) == 82) {
            this.annMemberValueArrayInitializer(anno, key, isSuppressWarnings);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return wasFallthroughLiteral;
    }

    protected final String conditionalExpression2() throws RecognitionException, TokenStreamException {
        CloverToken start = (CloverToken)this.LT(1);
        CloverToken end = null;
        String asString = null;
        this.conditionalExpression();
        if (this.inputState.guessing == 0) {
            end = (CloverToken)this.LT(0);
            asString = TokenListUtil.getNormalisedSequence(start, end);
        }
        return asString;
    }

    protected final void annMemberValueArrayInitializer(AnnotationValueCollection anno, String key, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        ArrayAnnotationValue annoArray;
        boolean emitComma = false;
        boolean seenFallthrough = false;
        Object last = null;
        ArrayAnnotationValue arrayAnnotationValue = annoArray = anno == null ? null : new ArrayAnnotationValue();
        if (anno != null) {
            anno.put(key, annoArray);
        }
        this.match(82);
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            seenFallthrough = this.annMemberValues(annoArray, isSuppressWarnings);
            if (this.inputState.guessing == 0) {
                emitComma = true;
            }
        } else if (this.LA(1) != 53 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 53) {
            this.match(53);
            if (this.inputState.guessing == 0) {
                emitComma = false;
            }
        } else if (this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken t = (CloverToken)this.LT(0);
            if (isSuppressWarnings) {
                if (seenFallthrough) {
                    this.existingFallthroughSuppression = true;
                } else {
                    if (emitComma) {
                        this.suppressWarningsInstr = new SimpleEmitter(",");
                        t.addPostEmitter(this.suppressWarningsInstr);
                    }
                    SimpleEmitter fallthrough = new SimpleEmitter("\"fallthrough\"");
                    t.addPostEmitter(fallthrough);
                    if (this.suppressWarningsInstr == null) {
                        this.suppressWarningsInstr = fallthrough;
                    } else {
                        this.suppressWarningsInstr.addDependent(fallthrough);
                    }
                }
            }
        }
        this.match(83);
    }

    protected final boolean annMemberValues(ArrayAnnotationValue annoArray, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        boolean sawFallthrough = false;
        boolean tmp = this.annMemberValue2(annoArray, null, isSuppressWarnings, false);
        if (this.inputState.guessing == 0 && tmp) {
            sawFallthrough = true;
        }
        while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 80 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
            this.match(53);
            tmp = this.annMemberValue2(annoArray, null, isSuppressWarnings, false);
            if (this.inputState.guessing != 0 || !tmp) continue;
            sawFallthrough = true;
        }
        return sawFallthrough;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{-84112639524864L, -13194206642177L, 524287L, 0L, 0L, 0L};
        return data;
    }
}

