/*
 * Decompiled with CFR 0.152.
 */
package cloverantlr.build;

import cloverantlr.build.Tool;
import java.io.File;
import java.io.FilenameFilter;

public class ANTLR {
    public static String compiler = "javac";
    public static String jarName = "cloverantlr.jar";
    public static String root = ".";
    public static String[] srcdir = new String[]{"antlr", "cloverantlr/actions/cpp", "cloverantlr/actions/java", "cloverantlr/actions/csharp", "cloverantlr/collections", "cloverantlr/collections/impl", "cloverantlr/debug", "cloverantlr/ASdebug", "cloverantlr/debug/misc", "cloverantlr/preprocessor"};

    public ANTLR() {
        compiler = System.getProperty("cloverantlr.build.compiler", compiler);
        root = System.getProperty("cloverantlr.build.root", root);
    }

    public String getName() {
        return "ANTLR";
    }

    public void build(Tool tool) {
        if (!this.rootIsValidANTLRDir(tool)) {
            return;
        }
        tool.antlr(root + "/cloverantlr/antlr.g");
        tool.antlr(root + "/cloverantlr/tokdef.g");
        tool.antlr(root + "/cloverantlr/preprocessor/preproc.g");
        tool.antlr(root + "/cloverantlr/actions/java/action.g");
        tool.antlr(root + "/cloverantlr/actions/cpp/action.g");
        tool.antlr(root + "/cloverantlr/actions/csharp/action.g");
        for (int i = 0; i < srcdir.length; ++i) {
            String string = compiler + " -d " + root + " " + root + "/" + srcdir[i] + "/*.java";
            tool.system(string);
        }
    }

    public void jar(Tool tool) {
        if (!this.rootIsValidANTLRDir(tool)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("jar cvf " + root + "/" + jarName);
        for (int i = 0; i < srcdir.length; ++i) {
            stringBuffer.append(" " + root + "/" + srcdir[i] + "/*.class");
        }
        tool.system(stringBuffer.toString());
    }

    protected boolean rootIsValidANTLRDir(Tool tool) {
        if (root == null) {
            return false;
        }
        File file = new File(root);
        if (!file.exists()) {
            tool.error("Property antlr.build.root==" + root + " does not exist");
            return false;
        }
        if (!file.isDirectory()) {
            tool.error("Property antlr.build.root==" + root + " is not a directory");
            return false;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return file.isDirectory() && string.equals("antlr");
            }
        });
        if (stringArray == null || stringArray.length == 0) {
            tool.error("Property antlr.build.root==" + root + " does not appear to be a valid ANTLR project root (no antlr subdir)");
            return false;
        }
        File file2 = new File(root + "/antlr");
        String[] stringArray2 = file2.list();
        if (stringArray2 == null || stringArray2.length == 0) {
            tool.error("Property antlr.build.root==" + root + " does not appear to be a valid ANTLR project root (no .java files in antlr subdir");
            return false;
        }
        return true;
    }
}

