/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.ints.IntArrayList;
import clover.it.unimi.dsi.fastutil.ints.IntArrays;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectList;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntArrayFrontCodedList
extends AbstractObjectList
implements Serializable,
Cloneable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected int n;
    protected int ratio;
    protected int[] array;
    protected transient int[] p;
    private static final boolean ASSERTS = true;

    public IntArrayFrontCodedList(Iterator arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        int[] array = IntArrays.EMPTY_ARRAY;
        int[] p = IntArrays.EMPTY_ARRAY;
        int[][] a = new int[2][];
        int curSize = 0;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = (int[])arrays.next();
            int length = a[b].length;
            if (this.n % ratio == 0) {
                p = IntArrays.grow(p, this.n / ratio + 1);
                p[this.n / ratio] = curSize;
                array = IntArrays.grow(array, curSize + IntArrayFrontCodedList.count(length) + length, curSize);
                curSize += IntArrayFrontCodedList.writeInt(array, length, curSize);
                System.arraycopy(a[b], 0, array, curSize, length);
                curSize += length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = IntArrays.grow(array, curSize + IntArrayFrontCodedList.count(length -= common) + IntArrayFrontCodedList.count(common) + length, curSize);
                curSize += IntArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += IntArrayFrontCodedList.writeInt(array, common, curSize);
                System.arraycopy(a[b], common, array, curSize, length);
                curSize += length;
            }
            b = 1 - b;
            ++this.n;
        }
        this.ratio = ratio;
        this.array = IntArrays.trim(array, curSize);
        this.p = IntArrays.trim(p, (this.n + ratio - 1) / ratio);
    }

    public IntArrayFrontCodedList(Collection c, int ratio) {
        this(c.iterator(), ratio);
    }

    private static int readInt(int[] a, int pos) {
        return a[pos];
    }

    private static int readCount(int[] a, int pos) {
        return 1;
    }

    private static int count(int length) {
        return 1;
    }

    private static int writeInt(int[] a, int length, int pos) {
        a[pos] = length;
        return 1;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        int[] array = this.array;
        int delta = index % this.ratio;
        int pos = this.p[index / this.ratio];
        int length = IntArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += IntArrayFrontCodedList.count(length) + length;
        length = IntArrayFrontCodedList.readInt(array, pos);
        int common = IntArrayFrontCodedList.readInt(array, pos + IntArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = IntArrayFrontCodedList.readInt(array, pos += IntArrayFrontCodedList.count(length) + IntArrayFrontCodedList.count(common) + length);
            common = IntArrayFrontCodedList.readInt(array, pos + IntArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, int[] a, int offset, int length) {
        int startPos;
        int delta = index % this.ratio;
        int pos = startPos = this.p[index / this.ratio];
        int arrayLength = IntArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + IntArrayFrontCodedList.count(arrayLength);
            System.arraycopy(this.array, pos, a, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            int prevArrayPos = pos + IntArrayFrontCodedList.count(arrayLength) + (i != 0 ? IntArrayFrontCodedList.count(common) : 0);
            common = IntArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + arrayLength) + IntArrayFrontCodedList.count(arrayLength = IntArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            System.arraycopy(this.array, prevArrayPos, a, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            System.arraycopy(this.array, pos + IntArrayFrontCodedList.count(arrayLength) + IntArrayFrontCodedList.count(common), a, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    public Object get(int index) {
        return this.getArray(index);
    }

    public int[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        int[] a = new int[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int get(int index, int[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        IntArrays.ensureOffsetLength(a, offset, length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, int[] a) {
        return this.get(index, a, 0, a.length);
    }

    public int size() {
        return this.n;
    }

    public ObjectListIterator objectListIterator(final int start) {
        this.ensureIndex(start);
        return new AbstractObjectListIterator(){
            int[] a = IntArrays.EMPTY_ARRAY;
            int i = 0;
            int pos = 0;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == IntArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = IntArrayFrontCodedList.this.p[start / IntArrayFrontCodedList.this.ratio];
                        int j = start % IntArrayFrontCodedList.this.ratio;
                        this.i = start - j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            public boolean hasNext() {
                return this.i < IntArrayFrontCodedList.this.n;
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public int previousIndex() {
                return this.i - 1;
            }

            public int nextIndex() {
                return this.i;
            }

            public Object next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % IntArrayFrontCodedList.this.ratio == 0) {
                    this.pos = IntArrayFrontCodedList.this.p[this.i / IntArrayFrontCodedList.this.ratio];
                    length = IntArrayFrontCodedList.readInt(IntArrayFrontCodedList.this.array, this.pos);
                    this.a = IntArrays.ensureCapacity(this.a, length, 0);
                    System.arraycopy(IntArrayFrontCodedList.this.array, this.pos + IntArrayFrontCodedList.count(length), this.a, 0, length);
                    this.pos += length + IntArrayFrontCodedList.count(length);
                    this.inSync = true;
                } else if (this.inSync) {
                    length = IntArrayFrontCodedList.readInt(IntArrayFrontCodedList.this.array, this.pos);
                    int common = IntArrayFrontCodedList.readInt(IntArrayFrontCodedList.this.array, this.pos + IntArrayFrontCodedList.count(length));
                    this.a = IntArrays.ensureCapacity(this.a, length + common, common);
                    System.arraycopy(IntArrayFrontCodedList.this.array, this.pos + IntArrayFrontCodedList.count(length) + IntArrayFrontCodedList.count(common), this.a, common, length);
                    this.pos += IntArrayFrontCodedList.count(length) + IntArrayFrontCodedList.count(common) + length;
                    length += common;
                } else {
                    length = IntArrayFrontCodedList.this.length(this.i);
                    this.a = IntArrays.ensureCapacity(this.a, length, 0);
                    IntArrayFrontCodedList.this.extract(this.i, this.a, 0, length);
                }
                ++this.i;
                return IntArrays.copy(this.a, 0, length);
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return (int[])IntArrayFrontCodedList.this.get(--this.i);
            }
        };
    }

    public Object clone() {
        IntArrayFrontCodedList c;
        try {
            c = (IntArrayFrontCodedList)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.array = (int[])this.array.clone();
        c.p = (int[])this.p.clone();
        return c;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ ");
        for (int i = 0; i < this.n; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(IntArrayList.wrap(this.getArray(i)).toString());
        }
        s.append(" ]");
        return s.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int[] p = new int[(this.n + this.ratio - 1) / this.ratio];
        int[] a = this.array;
        int i = 0;
        int pos = 0;
        for (i = 0; i < this.n; ++i) {
            int length = IntArrayFrontCodedList.readInt(a, pos);
            if (i % this.ratio == 0) {
                p[i / this.ratio] = pos;
                pos += IntArrayFrontCodedList.count(length) + length;
                continue;
            }
            int common = IntArrayFrontCodedList.readInt(a, pos + IntArrayFrontCodedList.count(length));
            pos += IntArrayFrontCodedList.count(length) + IntArrayFrontCodedList.count(common) + length;
        }
        this.p = p;
    }
}

