/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import clover.it.unimi.dsi.fastutil.bytes.ByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.ByteCollections;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterators;
import clover.it.unimi.dsi.fastutil.bytes.ByteList;
import clover.it.unimi.dsi.fastutil.bytes.ByteSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ByteSets {
    private ByteSets() {
    }

    public static ByteSet singleton(byte element) {
        return new Singleton(element);
    }

    public static ByteSet singleton(Object element) {
        return new Singleton((Byte)element);
    }

    public static ByteSet synchronize(ByteSet s) {
        return new SynchronizedSet(s);
    }

    public static ByteSet synchronize(ByteSet s, Object sync) {
        return new SynchronizedSet(s, sync);
    }

    public static ByteSet unmodifiable(ByteSet s) {
        return new UnmodifiableSet(s);
    }

    public static class UnmodifiableSet
    extends ByteCollections.UnmodifiableCollection
    implements ByteSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(ByteSet s) {
            super(s);
        }

        public boolean remove(byte k) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }
    }

    public static class SynchronizedSet
    extends ByteCollections.SynchronizedCollection
    implements ByteSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(ByteSet s, Object sync) {
            super(s, sync);
        }

        protected SynchronizedSet(ByteSet s) {
            super(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(byte k) {
            Object object = this.sync;
            synchronized (object) {
                return ((ByteSet)this.collection).remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }
    }

    public static class Singleton
    extends AbstractByteSet
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final byte element;

        protected Singleton(byte element) {
            this.element = element;
        }

        public boolean add(byte k) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(byte k) {
            return k == this.element;
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(ByteCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(ByteCollection c) {
            throw new UnsupportedOperationException();
        }

        public byte[] toByteArray() {
            byte[] a = new byte[]{this.element};
            return a;
        }

        public ByteIterator byteIterator() {
            return ByteIterators.wrap(this.toByteArray());
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }
}

