/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf.crypto;

public class RC4Encryption {
    private byte[] state = new byte[256];
    private int x;
    private int y;

    public void prepareRC4Key(byte[] key) {
        this.prepareRC4Key(key, 0, key.length);
    }

    public void prepareRC4Key(byte[] key, int off, int len) {
        int index1 = 0;
        int index2 = 0;
        int k = 0;
        while (k < 256) {
            this.state[k] = (byte)k;
            ++k;
        }
        this.x = 0;
        this.y = 0;
        int k2 = 0;
        while (k2 < 256) {
            index2 = key[index1 + off] + this.state[k2] + index2 & 0xFF;
            byte tmp = this.state[k2];
            this.state[k2] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % len;
            ++k2;
        }
    }

    public void encryptRC4(byte[] dataIn, int off, int len, byte[] dataOut, int offOut) {
        int length = len + off;
        int k = off;
        while (k < length) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            dataOut[k - off + offOut] = (byte)(dataIn[k] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
            ++k;
        }
    }

    public void encryptRC4(byte[] data, int off, int len) {
        this.encryptRC4(data, off, len, data, off);
    }

    public void encryptRC4(byte[] dataIn, byte[] dataOut) {
        this.encryptRC4(dataIn, 0, dataIn.length, dataOut, 0);
    }

    public void encryptRC4(byte[] data) {
        this.encryptRC4(data, 0, data.length, data, 0);
    }
}

