/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.annotations.Since;
import clover.com.google.gson.annotations.Until;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Class;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.reflect._Field;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VersionExclusionStrategy
implements ExclusionStrategy {
    private final double version;

    public VersionExclusionStrategy(double version) {
        Preconditions.checkArgument(version >= 0.0);
        this.version = version;
    }

    @Override
    public boolean shouldSkipField(Field f) {
        return !this.isValidVersion(_Field.getAnnotations(f));
    }

    @Override
    public boolean shouldSkipClass(Class<?> clazz) {
        return !this.isValidVersion(_Class.getAnnotations(clazz));
    }

    private boolean isValidVersion(Annotation_[] annotations) {
        for (Annotation_ annotation : annotations) {
            if (this.isValidSince(annotation) && this.isValidUntil(annotation)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSince(Annotation_ annotation) {
        double annotationVersion;
        return !(annotation instanceof Since) || !((annotationVersion = ((Since)annotation).value()) > this.version);
    }

    private boolean isValidUntil(Annotation_ annotation) {
        double annotationVersion;
        return !(annotation instanceof Until) || !((annotationVersion = ((Until)annotation).value()) <= this.version);
    }
}

