/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonElementVisitor;
import clover.com.google.gson.JsonEscapingVisitor;
import clover.com.google.gson.JsonFormatter;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonPrimitive;
import clover.com.google.gson.JsonTreeNavigator;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Appendable;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class JsonPrintFormatter
implements JsonFormatter {
    private final int printMargin;
    private final int indentationSize;
    private final int rightMargin;
    private final boolean escapeHtmlChars;
    public static final int DEFAULT_PRINT_MARGIN = 80;
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_RIGHT_MARGIN = 4;

    JsonPrintFormatter() {
        this(true);
    }

    JsonPrintFormatter(boolean escapeHtmlChars) {
        this(80, 2, 4, escapeHtmlChars);
    }

    JsonPrintFormatter(int printMargin, int indentationSize, int rightMargin, boolean escapeHtmlChars) {
        this.printMargin = printMargin;
        this.indentationSize = indentationSize;
        this.rightMargin = rightMargin;
        this.escapeHtmlChars = escapeHtmlChars;
    }

    public void format(JsonElement root, Object writer, boolean serializeNulls) throws IOException {
        if (root == null) {
            return;
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        JsonEscapingVisitor visitor = new JsonEscapingVisitor((JsonElementVisitor)new PrintFormattingVisitor(jsonWriter, serializeNulls), this.escapeHtmlChars);
        JsonTreeNavigator navigator = new JsonTreeNavigator(visitor, serializeNulls);
        navigator.navigate(root);
        jsonWriter.finishLine();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrintFormattingVisitor
    implements JsonElementVisitor {
        private final Map<Integer, Boolean> firstArrayElement;
        private final Map<Integer, Boolean> firstObjectMember;
        private final JsonWriter writer;
        private final boolean serializeNulls;
        private int level = 0;

        PrintFormattingVisitor(JsonWriter writer, boolean serializeNulls) {
            this.writer = writer;
            this.serializeNulls = serializeNulls;
            this.firstArrayElement = new HashMap<Integer, Boolean>();
            this.firstObjectMember = new HashMap<Integer, Boolean>();
        }

        private void addCommaCheckingFirst(Map<Integer, Boolean> first) throws IOException {
            if (first.get(_Integer.valueOf(this.level)) != Boolean.FALSE) {
                first.put(_Integer.valueOf(this.level), false);
            } else {
                this.writer.elementSeparator();
            }
        }

        @Override
        public void startArray(JsonArray array) throws IOException {
            this.firstArrayElement.put(_Integer.valueOf(++this.level), true);
            this.writer.beginArray();
        }

        @Override
        public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(this.firstArrayElement);
            this.writer.value(member.toString());
        }

        @Override
        public void visitArrayMember(JsonArray parent, JsonArray member, boolean first) throws IOException {
            this.addCommaCheckingFirst(this.firstArrayElement);
        }

        @Override
        public void visitArrayMember(JsonArray parent, JsonObject member, boolean first) throws IOException {
            this.addCommaCheckingFirst(this.firstArrayElement);
        }

        @Override
        public void visitNullArrayMember(JsonArray parent, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(this.firstArrayElement);
        }

        @Override
        public void endArray(JsonArray array) {
            --this.level;
            this.writer.endArray();
        }

        @Override
        public void startObject(JsonObject object) throws IOException {
            this.firstObjectMember.put(_Integer.valueOf(this.level), true);
            this.writer.beginObject();
        }

        @Override
        public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(this.firstObjectMember);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
            this.writer.value(member.toString());
        }

        @Override
        public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(this.firstObjectMember);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
        }

        @Override
        public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(this.firstObjectMember);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
        }

        @Override
        public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) throws IOException {
            if (this.serializeNulls) {
                this.visitObjectMember(parent, memberName, (JsonObject)null, isFirst);
            }
        }

        @Override
        public void endObject(JsonObject object) {
            this.writer.endObject();
        }

        @Override
        public void visitPrimitive(JsonPrimitive primitive) throws IOException {
            this.writer.value(primitive.toString());
        }

        @Override
        public void visitNull() throws IOException {
            this.writer.value("null");
        }
    }

    private class JsonWriter {
        private final Object writer;
        private StringBuffer line;
        private int level;

        JsonWriter(Object writer) {
            this.writer = writer;
            this.level = 0;
            this.line = new StringBuffer();
        }

        void key(String key) throws IOException {
            this.breakLineIfThisToNextExceedsLimit(key.length() + 2);
            this.getLine().append('\"');
            this.getLine().append(key);
            this.getLine().append('\"');
        }

        void value(String value) throws IOException {
            this.breakLineIfThisToNextExceedsLimit(value.length() + 2);
            this.getLine().append(value);
        }

        void fieldSeparator() throws IOException {
            this.getLine().append(':');
            this.breakLineIfNeeded();
        }

        void elementSeparator() throws IOException {
            this.getLine().append(',');
            this.breakLineIfNeeded();
        }

        void beginObject() throws IOException {
            this.breakLineIfNeeded();
            this.getLine().append('{');
            ++this.level;
        }

        void endObject() {
            this.getLine().append('}');
            --this.level;
        }

        void beginArray() throws IOException {
            this.breakLineIfNeeded();
            this.getLine().append('[');
            ++this.level;
        }

        void endArray() {
            this.getLine().append(']');
            --this.level;
        }

        private void breakLineIfNeeded() throws IOException {
            this.breakLineIfThisToNextExceedsLimit(0);
        }

        private void breakLineIfThisToNextExceedsLimit(int nextLength) throws IOException {
            if (this.getLine().length() + nextLength > JsonPrintFormatter.this.printMargin - JsonPrintFormatter.this.rightMargin) {
                this.finishLine();
            }
        }

        private void finishLine() throws IOException {
            if (this.line != null) {
                _Appendable.append(_Appendable.append(this.writer, this.line), "\n");
            }
            this.line = null;
        }

        private StringBuffer getLine() {
            if (this.line == null) {
                this.createNewLine();
            }
            return this.line;
        }

        private void createNewLine() {
            this.line = new StringBuffer();
            for (int i = 0; i < this.level; ++i) {
                for (int j = 0; j < JsonPrintFormatter.this.indentationSize; ++j) {
                    this.line.append(' ');
                }
            }
        }
    }
}

