/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonParseException;
import clover.com.google.gson.JsonParserJavacc;
import clover.com.google.gson.ParseException;
import clover.com.google.gson.TokenMgrError;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    public JsonElement parse(String json) throws JsonParseException {
        return this.parse(new StringReader(json));
    }

    public JsonElement parse(Reader json) throws JsonParseException {
        try {
            JsonParserJavacc parser = new JsonParserJavacc(json);
            return parser.parse();
        }
        catch (TokenMgrError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        catch (ParseException e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
    }
}

