/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.FieldNamingStrategy;
import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonDeserializationContext;
import clover.com.google.gson.JsonDeserializationVisitor;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonParseException;
import clover.com.google.gson.ObjectConstructor;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.TypeInfo;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonObjectDeserializationVisitor<T>
extends JsonDeserializationVisitor<T> {
    JsonObjectDeserializationVisitor(JsonElement json, Object type, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        super(json, type, factory, objectConstructor, deserializers, context);
    }

    @Override
    protected T constructTarget() {
        return this.objectConstructor.construct(this.targetType);
    }

    @Override
    public void startVisitingObject(Object node) {
    }

    @Override
    public void visitArray(Object array, Object componentType) {
        throw new JsonParseException(new StringBuffer().append("Expecting object but found array: ").append(array).toString());
    }

    @Override
    public void visitObjectField(Field f, Object typeOfF, Object obj) {
        try {
            String fName;
            if (!this.json.isJsonObject()) {
                throw new JsonParseException(new StringBuffer().append("Expecting object found: ").append(this.json).toString());
            }
            JsonObject jsonObject = this.json.getAsJsonObject();
            JsonElement jsonChild = jsonObject.get(fName = this.getFieldName(f));
            if (jsonChild != null) {
                Object child = this.visitChildAsObject(typeOfF, jsonChild);
                f.set(obj, child);
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visitArrayField(Field f, Object typeOfF, Object obj) {
        try {
            String fName;
            if (!this.json.isJsonObject()) {
                throw new JsonParseException(new StringBuffer().append("Expecting object found: ").append(this.json).toString());
            }
            JsonObject jsonObject = this.json.getAsJsonObject();
            JsonArray jsonChild = (JsonArray)jsonObject.get(fName = this.getFieldName(f));
            if (jsonChild != null) {
                Object array = this.visitChildAsArray(typeOfF, jsonChild);
                f.set(obj, array);
            } else {
                f.set(obj, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldName(Field f) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        return namingPolicy.translateName(f);
    }

    @Override
    public boolean visitFieldUsingCustomHandler(Field f, Object actualTypeOfField, Object parent) {
        try {
            String fName = this.getFieldName(f);
            if (!this.json.isJsonObject()) {
                throw new JsonParseException(new StringBuffer().append("Expecting object found: ").append(this.json).toString());
            }
            JsonElement child = this.json.getAsJsonObject().get(fName);
            if (child == null) {
                return true;
            }
            if (child.isJsonNull()) {
                TypeInfo typeInfo = new TypeInfo(actualTypeOfField);
                if (!typeInfo.isPrimitive()) {
                    f.set(parent, null);
                }
                return true;
            }
            JsonDeserializer deserializer = (JsonDeserializer)this.deserializers.getHandlerFor(actualTypeOfField);
            if (deserializer != null) {
                Object value = deserializer.deserialize(child, actualTypeOfField, this.context);
                f.set(parent, value);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException();
        }
    }
}

