/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.AnonymousAndLocalClassExclusionStrategy;
import clover.com.google.gson.DefaultTypeAdapters;
import clover.com.google.gson.DisjunctionExclusionStrategy;
import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.ExposeAnnotationBasedExclusionStrategy;
import clover.com.google.gson.FieldNamingPolicy;
import clover.com.google.gson.FieldNamingStrategy;
import clover.com.google.gson.Gson;
import clover.com.google.gson.InnerClassExclusionStrategy;
import clover.com.google.gson.InstanceCreator;
import clover.com.google.gson.JsonCompactFormatter;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonDeserializerExceptionWrapper;
import clover.com.google.gson.JsonFormatter;
import clover.com.google.gson.JsonPrintFormatter;
import clover.com.google.gson.JsonSerializer;
import clover.com.google.gson.LongSerializationPolicy;
import clover.com.google.gson.MappedObjectConstructor;
import clover.com.google.gson.ModifierBasedExclusionStrategy;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.SerializedNameAnnotationInterceptingNamingPolicy;
import clover.com.google.gson.VersionExclusionStrategy;
import java.util.Date;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GsonBuilder {
    private static final AnonymousAndLocalClassExclusionStrategy anonAndLocalClassExclusionStrategy = new AnonymousAndLocalClassExclusionStrategy();
    private static final InnerClassExclusionStrategy innerClassExclusionStrategy = new InnerClassExclusionStrategy();
    private static final ExposeAnnotationBasedExclusionStrategy exposeAnnotationExclusionStrategy = new ExposeAnnotationBasedExclusionStrategy();
    private double ignoreVersionsAfter = -1.0;
    private ModifierBasedExclusionStrategy modifierBasedExclusionStrategy = Gson.DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY;
    private boolean serializeInnerClasses = true;
    private boolean excludeFieldsWithoutExposeAnnotation = false;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = Gson.DEFAULT_NAMING_POLICY;
    private final ParameterizedTypeHandlerMap<InstanceCreator<?>> instanceCreators = new ParameterizedTypeHandlerMap();
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers = new ParameterizedTypeHandlerMap();
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers = new ParameterizedTypeHandlerMap();
    private boolean serializeNulls = false;
    private String datePattern;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean serializeSpecialFloatingPointValues = false;
    private boolean escapeHtmlChars = true;
    private boolean prettyPrinting = false;
    private boolean generateNonExecutableJson = false;
    static /* synthetic */ Class class$java$util$Date;

    public GsonBuilder setVersion(double ignoreVersionsAfter) {
        this.ignoreVersionsAfter = ignoreVersionsAfter;
        return this;
    }

    public GsonBuilder excludeFieldsWithModifiers(int[] modifiers) {
        boolean skipSynthetics = true;
        this.modifierBasedExclusionStrategy = new ModifierBasedExclusionStrategy(skipSynthetics, modifiers);
        return this;
    }

    public GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    public GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excludeFieldsWithoutExposeAnnotation = true;
        return this;
    }

    public GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    public GsonBuilder disableInnerClassSerialization() {
        this.serializeInnerClasses = false;
        return this;
    }

    public GsonBuilder setLongSerializationPolicy(LongSerializationPolicy serializationPolicy) {
        this.longSerializationPolicy = serializationPolicy;
        return this;
    }

    public GsonBuilder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
        return this.setFieldNamingStrategy(namingConvention.getFieldNamingPolicy());
    }

    public GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = new SerializedNameAnnotationInterceptingNamingPolicy(fieldNamingStrategy);
        return this;
    }

    public GsonBuilder setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    public GsonBuilder setDateFormat(String pattern) {
        this.datePattern = pattern;
        return this;
    }

    public GsonBuilder setDateFormat(int style) {
        this.dateStyle = style;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder setDateFormat(int dateStyle, int timeStyle) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder registerTypeAdapter(Object type, Object typeAdapter) {
        Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof InstanceCreator);
        if (typeAdapter instanceof InstanceCreator) {
            this.registerInstanceCreator(type, (InstanceCreator)typeAdapter);
        }
        if (typeAdapter instanceof JsonSerializer) {
            this.registerSerializer(type, (JsonSerializer)typeAdapter);
        }
        if (typeAdapter instanceof JsonDeserializer) {
            this.registerDeserializer(type, (JsonDeserializer)typeAdapter);
        }
        return this;
    }

    private <T> GsonBuilder registerInstanceCreator(Object typeOfT, InstanceCreator<? extends T> instanceCreator) {
        this.instanceCreators.register(typeOfT, instanceCreator);
        return this;
    }

    private <T> GsonBuilder registerSerializer(Object typeOfT, JsonSerializer<T> serializer) {
        this.serializers.register(typeOfT, serializer);
        return this;
    }

    private <T> GsonBuilder registerDeserializer(Object typeOfT, JsonDeserializer<T> deserializer) {
        this.deserializers.register(typeOfT, new JsonDeserializerExceptionWrapper<T>(deserializer));
        return this;
    }

    public GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    public Gson create() {
        LinkedList<ExclusionStrategy> strategies = new LinkedList<ExclusionStrategy>();
        strategies.add(this.modifierBasedExclusionStrategy);
        strategies.add(anonAndLocalClassExclusionStrategy);
        if (!this.serializeInnerClasses) {
            strategies.add(innerClassExclusionStrategy);
        }
        if (this.ignoreVersionsAfter != -1.0) {
            strategies.add(new VersionExclusionStrategy(this.ignoreVersionsAfter));
        }
        if (this.excludeFieldsWithoutExposeAnnotation) {
            strategies.add(exposeAnnotationExclusionStrategy);
        }
        DisjunctionExclusionStrategy exclusionStrategy = new DisjunctionExclusionStrategy(strategies);
        ParameterizedTypeHandlerMap<JsonSerializer<?>> customSerializers = this.serializers.copyOf();
        ParameterizedTypeHandlerMap<JsonDeserializer<?>> customDeserializers = this.deserializers.copyOf();
        GsonBuilder.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, customSerializers, customDeserializers);
        customSerializers.registerIfAbsent(DefaultTypeAdapters.getDefaultSerializers(this.serializeSpecialFloatingPointValues, this.longSerializationPolicy));
        customDeserializers.registerIfAbsent(DefaultTypeAdapters.getDefaultDeserializers());
        ParameterizedTypeHandlerMap<InstanceCreator<?>> customInstanceCreators = this.instanceCreators.copyOf();
        customInstanceCreators.registerIfAbsent(DefaultTypeAdapters.getDefaultInstanceCreators());
        customSerializers.makeUnmodifiable();
        customDeserializers.makeUnmodifiable();
        this.instanceCreators.makeUnmodifiable();
        MappedObjectConstructor objConstructor = new MappedObjectConstructor(customInstanceCreators);
        JsonFormatter formatter = this.prettyPrinting ? new JsonPrintFormatter(this.escapeHtmlChars) : new JsonCompactFormatter(this.escapeHtmlChars);
        Gson gson = new Gson(exclusionStrategy, this.fieldNamingPolicy, objConstructor, formatter, this.serializeNulls, customSerializers, customDeserializers, this.generateNonExecutableJson);
        return gson;
    }

    private static void addTypeAdaptersForDate(String datePattern, int dateStyle, int timeStyle, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers) {
        Class<?> clazz = class$java$util$Date;
        if (clazz == null) {
            clazz = class$java$util$Date = new Date[0].getClass().getComponentType();
        }
        if (!serializers.hasSpecificHandlerFor(clazz)) {
            Class<?> clazz2 = class$java$util$Date;
            if (clazz2 == null) {
                clazz2 = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            if (!deserializers.hasSpecificHandlerFor(clazz2)) {
                DefaultTypeAdapters.DefaultDateTypeAdapter dateTypeAdapter = null;
                if (datePattern != null && !"".equals(datePattern.trim())) {
                    dateTypeAdapter = new DefaultTypeAdapters.DefaultDateTypeAdapter(datePattern);
                } else if (dateStyle != 2 && timeStyle != 2) {
                    dateTypeAdapter = new DefaultTypeAdapters.DefaultDateTypeAdapter(dateStyle, timeStyle);
                }
                if (dateTypeAdapter != null) {
                    Class<?> clazz3 = class$java$util$Date;
                    if (clazz3 == null) {
                        clazz3 = class$java$util$Date = new Date[0].getClass().getComponentType();
                    }
                    serializers.register(clazz3, dateTypeAdapter);
                    Class<?> clazz4 = class$java$util$Date;
                    if (clazz4 == null) {
                        clazz4 = class$java$util$Date = new Date[0].getClass().getComponentType();
                    }
                    deserializers.register(clazz4, dateTypeAdapter);
                }
            }
        }
    }
}

