/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.CloverReporter;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.tasks.AbstractCloverTask;
import com.cenqua.clover.tasks.AntExtension;
import com.cenqua.clover.tasks.AntPath;
import com.cenqua.clover.tasks.CloverFormatType;
import com.cenqua.clover.tasks.ColumnsEx;
import com.cenqua.clover.tasks.FilesetFileVisitor;
import com.cenqua.clover.tasks.FilesetFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class CloverReportTask
extends AbstractCloverTask {
    private boolean failOnError = true;
    private String projectName = null;
    private List reports = new ArrayList();

    public void addCurrent(CurrentEx current) {
        this.reports.add(current);
    }

    public void addHistorical(HistoricalEx historical) {
        this.reports.add(historical);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void cloverExecute() {
        String initString = null;
        try {
            Project p = this.getProject();
            CloverReportConfig[] configs = new CloverReportConfig[this.reports.size()];
            HashMap<String, CloverReportConfig> linkedReports = new HashMap<String, CloverReportConfig>();
            CloverReportConfig firstCurrentConfig = null;
            for (int i = 0; i < this.reports.size(); ++i) {
                CloverReportConfig config = (CloverReportConfig)this.reports.get(i);
                if (config instanceof AntExtension) {
                    String title;
                    AntExtension extension = (AntExtension)((Object)config);
                    extension.resolve(p);
                    List reportFilesets = extension.getFilesets();
                    if (reportFilesets.size() != 0) {
                        config.setIncludeFilter(new FilesetFilter(p, reportFilesets));
                    }
                    config.setProjectName(this.projectName);
                    if (config instanceof CurrentEx) {
                        if (initString == null) {
                            initString = this.resolveInitString();
                        }
                        config.setInitString(initString);
                        this.log("Loading coverage database from: '" + initString + "'");
                        if (firstCurrentConfig == null) {
                            firstCurrentConfig = config;
                        }
                        CloverReportTask.checkTestSourceFileSet(reportFilesets, (CurrentEx)config);
                    } else if (config instanceof HistoricalEx) {
                        HistoricalEx histEx = (HistoricalEx)config;
                        this.log("Loading historical coverage data from: '" + histEx.getHistoryDir() + "'");
                    }
                    String string = config.getTitle() == null ? extension.getTypeName() : (title = linkedReports.containsKey(config.getTitle()) ? config.getTitle() + "-" + extension.getTypeName() : config.getTitle());
                    if (linkedReports.containsKey(title)) {
                        CloverReportConfig baseConfig = (CloverReportConfig)linkedReports.get(title);
                        config.setUniqueTitle(title + "-" + baseConfig.incTitleCount());
                    } else {
                        config.setUniqueTitle(title);
                    }
                }
                configs[i] = config;
                linkedReports.put(config.getUniqueTitle(), config);
            }
            this.generateReports(firstCurrentConfig, configs, linkedReports);
        }
        catch (CloverException e) {
            if (this.failOnError) {
                throw new BuildException((Throwable)e);
            }
            this.log("Report generation failed: " + e.getMessage(), 0);
        }
    }

    static void checkTestSourceFileSet(List reportFilesets, CurrentEx current) throws CloverException {
        if (reportFilesets.size() > 0) {
            List testFiles = current.getTestSourceFiles();
            List allFiles = current.getGlobalSourceFileNames();
            Iterator iterator = testFiles.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (allFiles.contains(file.getAbsolutePath())) continue;
                throw new CloverException("'" + file.getAbsolutePath() + "' is included in " + "<testsources/>, but not in <fileset/>. " + "<testsources/> must be a subset of <fileset/>");
            }
        }
    }

    protected void generateReports(CloverReportConfig firstCurrentConfig, CloverReportConfig[] configs, Map linkedReports) throws CloverException {
        for (int i = 0; i < configs.length; ++i) {
            CloverReportConfig config = configs[i];
            TreeMap myLinkedReports = new TreeMap();
            myLinkedReports.putAll(linkedReports);
            myLinkedReports.remove(config.getUniqueTitle());
            config.setLinkedReports(myLinkedReports);
            config.setFirstCurrentConfig(firstCurrentConfig);
            CloverReporter.generateReport(config);
        }
    }

    public static class HistoricalEx
    extends Historical
    implements AntExtension {
        private CloverFormatType format;
        private List filesets = new ArrayList();
        private String typeName = "Historical";
        private String historyIncludes;

        public void addFormat(CloverFormatType format) {
            this.format = format;
        }

        public void addChart(ChartEx ex) {
            super.addChart(ex);
        }

        public void addCoverage(CoverageEx ex) {
            super.addCoverage(ex);
        }

        public void addMetrics(MetricsEx ex) {
            super.addMetrics(ex);
        }

        public void resolve(Project p) {
            String mainFileName = "historical.html";
            if (this.format != null) {
                Format actualFormat = this.format.getActualFormat(p);
                this.setFormat(actualFormat);
                if (!"HTML".equalsIgnoreCase(actualFormat.getType())) {
                    mainFileName = "";
                }
            }
            this.setMainFileName(mainFileName);
            this.setNeedsNewFrame(false);
            this.historyFiles = this.processHistoryIncludes(p);
        }

        public void addFileSet(FileSet fileset) {
            this.filesets.add(fileset);
        }

        public List getFilesets() {
            return this.filesets;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setHistoryIncludes(String includesSpec) {
            this.historyIncludes = includesSpec;
        }

        private File[] processHistoryIncludes(Project project) {
            return HistoricalEx.processHistoryIncludes(project, this.historyIncludes, this.getHistoryDir());
        }

        public static File[] processHistoryIncludes(Project project, String includes, File historyDir) {
            if (includes == null) {
                includes = "clover-*.xml.gz";
            }
            DirectoryScanner dirScanner = new DirectoryScanner();
            PatternSet patterns = new PatternSet();
            patterns.setIncludes(includes);
            Logger.getInstance().debug("Using historyIncludes of: '" + includes + "'");
            dirScanner.setBasedir(historyDir);
            dirScanner.setIncludes(patterns.getIncludePatterns(project));
            dirScanner.scan();
            String[] filePaths = dirScanner.getIncludedFiles();
            File[] files = new File[filePaths.length];
            for (int i = 0; i < filePaths.length; ++i) {
                String filePath = filePaths[i];
                files[i] = new File(dirScanner.getBasedir(), filePath);
                Logger.getInstance().debug("Including history point file: '" + files[i].getAbsolutePath() + "'");
            }
            return files;
        }
    }

    public static class MetricsEx
    extends Historical.Metrics {
        public void addConfiguredColumns(ColumnsEx cols) {
            super.addColumns(cols.resolveColumnsRef());
        }
    }

    public static class CoverageEx
    extends Historical.Coverage {
        public void addConfiguredColumns(ColumnsEx cols) {
            super.addColumns(cols.resolveColumnsRef());
        }
    }

    public static class ChartEx
    extends Historical.Chart {
        public void addConfiguredColumns(ColumnsEx cols) {
            super.addColumns(cols.resolveColumnsRef());
        }
    }

    public static class CurrentEx
    extends Current
    implements AntExtension {
        private CloverFormatType format;
        private ColumnsEx columns;
        private List filesets = new ArrayList();
        private List testResults = new ArrayList();
        private List testSources = new ArrayList();
        private Path sourcepath = null;
        private Project project = null;
        private final String typeName = "Current";

        public void addFormat(CloverFormatType format) {
            this.format = format;
        }

        public void addColumns(ColumnsEx cols) {
            this.columns = cols;
        }

        public void resolve(Project p) {
            this.project = p;
            if (this.columns != null) {
                super.setColumns(this.columns.resolveColumnsRef());
            }
            boolean needsNewFrame = true;
            String mainFileName = "index.html";
            if (this.format != null) {
                Format actualFormat = this.format.getActualFormat(p);
                this.setFormat(actualFormat);
                if (!"HTML".equalsIgnoreCase(this.getFormat().getType())) {
                    needsNewFrame = false;
                    mainFileName = "";
                }
            }
            if (this.sourcepath != null) {
                this.setSourcepath(new AntPath(this.sourcepath));
            }
            this.setMainFileName(mainFileName);
            this.setNeedsNewFrame(needsNewFrame);
            this.initFileSets();
        }

        public String getTypeName() {
            return "Current";
        }

        public void addFileSet(FileSet fileset) {
            this.filesets.add(fileset);
        }

        public List getFilesets() {
            return this.filesets;
        }

        public void addSourcepath(Path path) {
            if (this.sourcepath == null) {
                this.sourcepath = path;
            } else {
                this.sourcepath.append(path);
            }
        }

        public void addTestResults(FileSet fileset) {
            this.testResults.add(fileset);
        }

        public List getTestResults() {
            return this.testResults;
        }

        public void addTestSources(FileSet fileset) {
            this.testSources.add(fileset);
        }

        public List getTestSources() {
            return this.testSources;
        }

        public boolean validate() {
            return super.validate();
        }

        private void initFileSets() {
            FilesetFileVisitor.Util util = new FilesetFileVisitor.Util();
            FilesetFileVisitor.Util.collectFiles(this.project, this.filesets, new FilesetFileVisitor(this){
                private final /* synthetic */ CurrentEx this$0;
                {
                    this.this$0 = this$0;
                }

                public void visit(File file) {
                    this.this$0.addGlobalFileName(file.getAbsolutePath());
                }
            });
            FilesetFileVisitor.Util.collectFiles(this.project, this.testResults, new FilesetFileVisitor(this){
                private final /* synthetic */ CurrentEx this$0;
                {
                    this.this$0 = this$0;
                }

                public void visit(File file) {
                    this.this$0.addTestResultFile(file);
                }
            });
            FilesetFileVisitor.Util.collectFiles(this.project, this.testSources, true, new FilesetFileVisitor(this){
                private final /* synthetic */ CurrentEx this$0;
                {
                    this.this$0 = this$0;
                }

                public void visit(File file) {
                    this.this$0.addTestSourceFile(file);
                }
            });
        }
    }
}

