/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverDatabaseSpec;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.tasks.AbstractCloverTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class CloverMergeTask
extends AbstractCloverTask {
    private List cloverDbs = new ArrayList();
    private List cloverDbSets;

    public void addCloverDb(CloverDatabaseSpec db) {
        this.cloverDbs.add(db);
    }

    public void addCloverDbSet(CloverDbSet dbset) {
        if (this.cloverDbSets == null) {
            this.cloverDbSets = new ArrayList();
        }
        this.cloverDbSets.add(dbset);
    }

    public void cloverExecute() {
        if (this.getInitString() == null) {
            throw new BuildException("You must specify the location of the new clover database with the \"initString\" attribute");
        }
        String initString = this.resolveInitString();
        if (this.cloverDbSets != null) {
            Iterator it = this.cloverDbSets.iterator();
            while (it.hasNext()) {
                CloverDbSet dbset = (CloverDbSet)((Object)it.next());
                this.cloverDbs.addAll(dbset.getIncludedDbs());
            }
        }
        if (this.cloverDbs.size() == 0) {
            throw new BuildException("You must specify one or more coverage databases to merge using a nested  <cloverdb> or <cloverdbset> element.");
        }
        try {
            CloverDatabase.merge(this.cloverDbs, initString, new ProgressListener(){

                public void handleProgress(String desc, float pc) {
                    CloverMergeTask.this.log(desc);
                }
            });
        }
        catch (Exception e) {
            throw new BuildException("Error writing new clover db at " + initString, (Throwable)e);
        }
    }

    public static class CloverDbSet
    extends FileSet {
        private Interval span = Interval.ZERO_SECONDS;

        public Interval getSpan() {
            return this.span;
        }

        public void setSpan(Interval span) {
            this.span = span;
        }

        public List getIncludedDbs() {
            String[] files = this.getDirectoryScanner(this.getProject()).getIncludedFiles();
            LinkedList<CloverDatabaseSpec> dbs = new LinkedList<CloverDatabaseSpec>();
            String baseDir = this.getDir(this.getProject()).getAbsolutePath();
            for (int i = 0; i < files.length; ++i) {
                dbs.add(new CloverDatabaseSpec(baseDir + "/" + files[i], this.span));
            }
            return dbs;
        }
    }
}

