/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.instr.InstrumentationConfig;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class AntInstrumentationConfig
extends InstrumentationConfig {
    private final Project project;
    private boolean preserve;
    private String compilerDelegate;

    public AntInstrumentationConfig(Project project) {
        this.project = project;
        this.setProjectName(project.getName());
        this.setDefaultBaseDir(project.getBaseDir());
        this.setInitstring(project.getProperty("clover.initstring"));
    }

    public String resolveInitString() {
        if (this.getInitString() == null) {
            AntInstrumentationConfig cfg = (AntInstrumentationConfig)this.project.getReference("clover.config");
            String initString = null;
            if (cfg != null) {
                initString = cfg.getInitString();
            }
            if (initString == null) {
                initString = this.project.getProperty("clover.initstring");
                if (initString == null) {
                    try {
                        this.createDefaultInitStringDir();
                    }
                    catch (CloverException e) {
                        throw new BuildException(e.getMessage() + " Please use the \"initstring\" attribute to specify a Clover database location.");
                    }
                } else {
                    this.setInitstring(initString);
                }
            } else {
                this.setInitstring(initString);
            }
        }
        String resolvedInitString = this.getInitString();
        File initStringFile = this.project.resolveFile(this.getInitString());
        File initParent = initStringFile.getParentFile();
        if (initParent != null && initParent.exists()) {
            resolvedInitString = initStringFile.getAbsolutePath();
        }
        return resolvedInitString;
    }

    public boolean isPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public String getCompilerDelegate() {
        return this.compilerDelegate;
    }

    public void setCompilerDelegate(String compilerDelegate) {
        this.compilerDelegate = compilerDelegate;
    }

    public static class Instrumentation
    extends EnumeratedAttribute {
        public String[] getValues() {
            return InstrumentationConfig.INSTR_VALUES;
        }
    }

    public static class FlushPolicy
    extends EnumeratedAttribute {
        public String[] getValues() {
            return InstrumentationConfig.FLUSH_VALUES;
        }
    }
}

