/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import cloverantlr.TokenStreamException;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.HtmlSourceRenderer;
import com.cenqua.clover.reporters.html.RenderFileAction;
import com.cenqua.clover.reporters.html.SourceRenderHelper;
import com.cenqua.clover.reporters.json.JSONObject;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RenderJSONAction
extends RenderFileAction {
    public RenderJSONAction(FileInfo finfo, HtmlRenderingSupport helper, Current curr, VelocityContext ctx, CloverDatabase db, ProjectInfo fullModel) {
        super(finfo, helper, curr, ctx, db, fullModel, null);
    }

    public void render() throws Exception {
        String basename = new File(this.mInfo.getName()).getName();
        try {
            Map columnValues = this.collectColumnValues();
            SourceRenderHelper srh = new SourceRenderHelper(this.mDb, this.mCurrent, this.mHelper);
            FileInfo fcopy = this.mInfo.copy((PackageInfo)this.mInfo.getContainingPackage(), HasMetricsFilter.NO_OP);
            HtmlSourceRenderer.LineRenderInfo[] lineInfos = srh.gatherSrcRenderInfo(this.mContext, fcopy, this.getContextSet(), "", this.testLineInfo);
            String apiJsonOutFilename = RenderJSONAction.createOutFileBaseName(basename) + "java.js";
            File apiJsonOutfile = CloverUtils.createOutFile(fcopy, apiJsonOutFilename, this.mCurrent.getOutFile());
            Collection hitCounts = this.collectHitCounts(lineInfos);
            JSONObject json = new JSONObject();
            json.put("id", this.mHelper.getFileIdentifier(fcopy));
            json.put("stats", columnValues);
            json.put("lines", hitCounts);
            this.mContext.put("fileJson", json.toString(2));
            this.mContext.put("fileId", this.mHelper.getFileIdentifier(fcopy));
            this.mContext.put("callback", this.mCurrent.getFormat().getCallback());
            HtmlReportUtil.mergeTemplateToFile(apiJsonOutfile, this.mContext, "html_res/src-file-api-json.vm");
        }
        catch (TokenStreamException e) {
            Logger.getInstance().error("Invalid java source found: " + this.mInfo.getPhyscialFile().getAbsolutePath(), e);
        }
    }

    private Map collectColumnValues() throws CloverException {
        HashMap<String, Number> columnValues = new HashMap<String, Number>();
        List columns = (List)mColumns.get();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            BlockMetrics metrics = this.mHelper.metricsFor(this.mInfo);
            col.init(metrics);
            columnValues.put(col.getName(), col.getNumber());
            col.reset();
        }
        return columnValues;
    }

    private Collection collectHitCounts(HtmlSourceRenderer.LineRenderInfo[] lineInfos) {
        ArrayList<String> hitCounts = new ArrayList<String>();
        for (int i = 0; i < lineInfos.length; ++i) {
            HtmlSourceRenderer.LineRenderInfo lineInfo = lineInfos[i];
            hitCounts.add(lineInfo.coverageStr);
        }
        return hitCounts;
    }
}

