/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import clover.org.apache.velocity.VelocityContext;
import cloverantlr.TokenStreamException;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.JSONObjectFactory;
import com.cenqua.clover.reporters.html.SourceRenderHelper;
import com.cenqua.clover.reporters.json.JSONException;
import com.cenqua.clover.reporters.util.CloverChartFactory;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RenderFileAction
implements Callable {
    protected final FileInfo mInfo;
    protected final HtmlRenderingSupport mHelper;
    protected final Current mCurrent;
    protected final VelocityContext mContext;
    protected final CloverDatabase mDb;
    protected final ProjectInfo mFullModel;
    protected final Map mCharts;
    protected List[] testLineInfo;
    protected static ThreadLocal mColumns;
    private static ThreadLocal mContextSet;
    final Comparator TEST_METRICS_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object1) {
            BlockMetrics m = (BlockMetrics)((Map.Entry)object).getValue();
            BlockMetrics m1 = (BlockMetrics)((Map.Entry)object1).getValue();
            return (int)(1000.0f * (m1.getPcCoveredElements() - m.getPcCoveredElements()));
        }
    };

    public RenderFileAction(FileInfo finfo, HtmlRenderingSupport helper, Current curr, VelocityContext ctx, CloverDatabase db, ProjectInfo fullModel, Map charts) {
        this.mInfo = finfo;
        this.mHelper = helper;
        this.mCurrent = curr;
        this.mContext = ctx;
        this.mDb = db;
        this.mFullModel = fullModel;
        this.mCharts = charts;
    }

    public static void initThreadLocals() {
        mColumns = new ThreadLocal();
        mContextSet = new ThreadLocal();
    }

    public static void resetThreadLocals() {
        mColumns = null;
        mContextSet = null;
    }

    public Object call() throws Exception {
        if (mColumns.get() == null) {
            mColumns.set(this.mCurrent.getColumns().getMethodColumnsCopy());
        }
        if (mContextSet.get() == null) {
            mContextSet.set(this.mDb.getContextSet(this.mCurrent.getFormat().getFilter()));
        }
        HtmlReportUtil.addColumnsToContext(this.mContext, (List)mColumns.get(), this.mInfo, this.mInfo.getClasses());
        this.render();
        return null;
    }

    public void render() throws Exception {
        String srcname = this.mInfo.getName();
        String basename = new File(srcname).getName();
        String outname = RenderFileAction.createOutFileName(basename);
        File outfile = CloverUtils.createOutFile(this.mInfo, outname, this.mCurrent.getOutFile());
        String jsonOutFilename = RenderFileAction.createOutFileBaseName(basename) + "js";
        this.mContext.put("basename", basename);
        this.mContext.put("currentPageURL", outname);
        this.mContext.put("jsonFilename", jsonOutFilename);
        try {
            FileInfo fcopy = this.insertSrcFileProperties();
            this.insertLineInfos(fcopy, this.testLineInfo);
        }
        catch (TokenStreamException e) {
            Logger.getInstance().error("Invalid java source found: " + this.mInfo.getPhyscialFile().getAbsolutePath());
            this.mContext.put("filename", this.mInfo.getPhyscialFile().getAbsolutePath());
            this.mContext.put("message", e.getMessage());
            List srclines = SourceRenderHelper.getUnrenderedSrcLines(this.mInfo);
            this.mContext.put("srclines", srclines);
            HtmlReportUtil.mergeTemplateToFile(outfile, this.mContext, "html_res/src-file-error.vm");
            return;
        }
        this.mContext.put("chartInfo", CloverChartFactory.getChartForFile(this.mInfo, this.mCharts));
        HtmlReportUtil.mergeTemplateToFile(outfile, this.mContext, "html_res/src-file.vm");
        File jsonOutfile = CloverUtils.createOutFile(this.mInfo, jsonOutFilename, this.mCurrent.getOutFile());
        HtmlReportUtil.mergeTemplateToFile(jsonOutfile, this.mContext, "html_res/src-file-json.vm");
    }

    public FileInfo insertSrcFileProperties() throws TokenStreamException, JSONException {
        this.mContext.put("headerMetrics", this.mInfo.getMetrics());
        this.mContext.put("headerMetricsRaw", this.mInfo.getRawMetrics());
        this.mContext.put("fileInfo", this.mInfo);
        ProjectInfo projInfo = this.mFullModel;
        this.mContext.put("projInfo", projInfo);
        this.mContext.put("cloverDb", this.mDb);
        HtmlReportUtil.addFilteredPercentageToContext(this.mContext, this.mInfo);
        final HashMap targetMethods = new HashMap();
        final HashMap targetElements = new HashMap();
        HashMap<TestCaseInfo, BlockMetrics> testMetrics = new HashMap<TestCaseInfo, BlockMetrics>();
        Set testHits = this.mDb.getTestHits(this.mInfo);
        FileInfo fcopy = this.mInfo.copy((PackageInfo)this.mInfo.getContainingPackage(), HasMetricsFilter.NO_OP);
        HashSet<TestCaseInfo> testSet = new HashSet<TestCaseInfo>();
        final List[] testLineInfo = new ArrayList[fcopy.getLineCount() + 1];
        Iterator tests = testHits.iterator();
        while (tests.hasNext()) {
            final TestCaseInfo tci = (TestCaseInfo)tests.next();
            testSet.clear();
            testSet.add(tci);
            fcopy.setDataProvider(this.mDb.getCoverageData().getCoverageFrom(testSet, fcopy));
            testMetrics.put(tci, fcopy.getMetrics());
            fcopy.visitElements(new FileElementVisitor(){

                public void visitClass(ClassInfo info) {
                }

                public void visitMethod(MethodInfo info) {
                    if (info.getHitCount() > 0) {
                        this.updateTestLineInfo(info);
                        BitSet set = (BitSet)targetMethods.get(tci);
                        if (set == null) {
                            set = new BitSet();
                            targetMethods.put(tci, set);
                        }
                        set.set(info.getStartLine());
                    }
                }

                public void visitStatement(StatementInfo info) {
                    this.visitNode(info);
                }

                public void visitBranch(BranchInfo info) {
                    this.visitNode(info);
                }

                private void visitNode(ElementInfo info) {
                    if (info.getHitCount() > 0) {
                        this.updateTestLineInfo(info);
                        BitSet set = (BitSet)targetElements.get(tci);
                        if (set == null) {
                            set = new BitSet();
                            targetElements.put(tci, set);
                        }
                        set.set(info.getStartLine());
                    }
                }

                private void updateTestLineInfo(SourceRegion r) {
                    int sl = r.getStartLine();
                    ArrayList<TestCaseInfo> tests = testLineInfo[sl];
                    if (tests == null) {
                        testLineInfo[sl] = tests = new ArrayList<TestCaseInfo>();
                    }
                    if (!this.isSetForThisTest(targetElements, sl) && !this.isSetForThisTest(targetMethods, sl)) {
                        tests.add(tci);
                    }
                }

                private boolean isSetForThisTest(Map m, int i) {
                    BitSet bsc = (BitSet)m.get(tci);
                    return bsc != null && bsc.get(i);
                }
            });
        }
        this.testLineInfo = testLineInfo;
        LinkedHashMap orderedTestMetrics = new LinkedHashMap(testMetrics.size());
        LinkedList testMetricList = new LinkedList(testMetrics.entrySet());
        Collections.sort(testMetricList, this.TEST_METRICS_COMPARATOR);
        List sublist = this.mCurrent.getMaxTestsPerFile() >= 0 && !testMetricList.isEmpty() && testMetricList.size() > this.mCurrent.getMaxTestsPerFile() ? testMetricList.subList(0, this.mCurrent.getMaxTestsPerFile()) : testMetricList;
        Iterator iterator = sublist.iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            orderedTestMetrics.put(e.getKey(), e.getValue());
        }
        this.mContext.put("testMetrics", orderedTestMetrics);
        this.mContext.put("numTargetMethods", new Integer(targetMethods.size()));
        this.mContext.put("testsPerFile", new Integer(this.mCurrent.getMaxTestsPerFile()));
        this.mContext.put("jsonTestTargets", JSONObjectFactory.getJSONTestTargets(targetMethods, targetElements));
        this.mContext.put("jsonPageData", JSONObjectFactory.getJSONPageData(this.mInfo));
        if (sublist.size() < testMetricList.size()) {
            this.mContext.put("numTestsHidden", new Integer(testMetricList.size() - sublist.size()));
        }
        return fcopy;
    }

    private void insertLineInfos(FileInfo fcopy, List[] testLineInfo) throws TokenStreamException {
        SourceRenderHelper srh = new SourceRenderHelper(this.mDb, this.mCurrent, this.mHelper);
        srh.insertLineInfosForFile(fcopy, this.mContext, this.getContextSet(), "&nbsp;", testLineInfo);
    }

    protected ContextSet getContextSet() {
        return (ContextSet)mContextSet.get();
    }

    static String createOutFileName(String basename) {
        return RenderFileAction.createOutFileBaseName(basename) + "html";
    }

    protected static String createOutFileBaseName(String basename) {
        return basename.substring(0, basename.lastIndexOf(".") + 1);
    }
}

