/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import cloverantlr.LLkParser;
import cloverantlr.NoViableAltException;
import cloverantlr.ParserSharedInputState;
import cloverantlr.RecognitionException;
import cloverantlr.SemanticException;
import cloverantlr.Token;
import cloverantlr.TokenBuffer;
import cloverantlr.TokenStream;
import cloverantlr.TokenStreamException;
import cloverantlr.collections.impl.BitSet;
import com.cenqua.clover.Contract;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.instr.Annotation;
import com.cenqua.clover.instr.AnnotationValueCollection;
import com.cenqua.clover.instr.ArrayAnnotationValue;
import com.cenqua.clover.instr.ClassEntryNode;
import com.cenqua.clover.instr.ClassExitNode;
import com.cenqua.clover.instr.CloverToken;
import com.cenqua.clover.instr.CloverTokenStreamFilter;
import com.cenqua.clover.instr.DirectedFlushEmitter;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.EndBoolInstrEmitter;
import com.cenqua.clover.instr.ExpressionInfo;
import com.cenqua.clover.instr.FileStructureInfo;
import com.cenqua.clover.instr.FlagDeclEmitter;
import com.cenqua.clover.instr.FlaggedInstrEmitter;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.JavaTokenTypes;
import com.cenqua.clover.instr.MethodEntryInstrEmitter;
import com.cenqua.clover.instr.MethodExitInstrEmitter;
import com.cenqua.clover.instr.MethodRegistrationNode;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.RecorderInstrEmitter;
import com.cenqua.clover.instr.SimpleEmitter;
import com.cenqua.clover.instr.StatementInstrEmitter;
import com.cenqua.clover.instr.StringifiedAnnotationValue;
import com.cenqua.clover.instr.TokenListUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaRecognizer
extends LLkParser
implements JavaTokenTypes {
    private static final Logger LOG = Logger.getInstance();
    private ContextSet currentContext = new ContextSet();
    private LinkedList contextStack = new LinkedList();
    private boolean topLevelClass = true;
    private CloverTokenStreamFilter mFilter;
    private LinkedList classnameList = new LinkedList();
    private boolean constExpr = false;
    private InstrumentationConfig cfg;
    private FileStructureInfo fileInfo;
    private ClassEntryNode currentTopLevelClassEntry;
    private Emitter suppressWarningsInstr = null;
    private boolean existingFallthroughSuppression = false;
    private int ltCounter = 0;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "BLOCK", "MODIFIERS", "OBJBLOCK", "SLIST", "CTOR_DEF", "METHOD_DEF", "VARIABLE_DEF", "INSTANCE_INIT", "STATIC_INIT", "TYPE", "CLASS_DEF", "INTERFACE_DEF", "PACKAGE_DEF", "ARRAY_DECLARATOR", "EXTENDS_CLAUSE", "IMPLEMENTS_CLAUSE", "PARAMETERS", "PARAMETER_DEF", "LABELED_STAT", "TYPECAST", "INDEX_OP", "POST_INC", "POST_DEC", "METHOD_CALL", "EXPR", "ARRAY_INIT", "IMPORT", "UNARY_MINUS", "UNARY_PLUS", "CASE_GROUP", "ELIST", "FOR_INIT", "FOR_CONDITION", "FOR_ITERATOR", "EMPTY_STAT", "\"final\"", "\"abstract\"", "\"strictfp\"", "SUPER_CTOR_CALL", "CTOR_CALL", "\"package\"", "SEMI", "\"import\"", "\"static\"", "LBRACK", "RBRACK", "IDENT", "DOT", "LT", "COMMA", "QUESTION", "\"extends\"", "\"super\"", "GT", "SR", "BSR", "\"void\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "STAR", "\"private\"", "\"public\"", "\"protected\"", "\"transient\"", "\"native\"", "\"synchronized\"", "\"volatile\"", "\"class\"", "\"interface\"", "\"enum\"", "AT", "BAND", "LCURLY", "RCURLY", "LPAREN", "RPAREN", "\"default\"", "\"implements\"", "\"this\"", "ASSIGN", "\"throws\"", "ELLIPSIS", "\"assert\"", "COLON", "\"if\"", "\"else\"", "\"for\"", "\"while\"", "\"do\"", "\"break\"", "\"continue\"", "\"return\"", "\"switch\"", "\"throw\"", "\"case\"", "\"try\"", "\"finally\"", "\"catch\"", "PLUS_ASSIGN", "MINUS_ASSIGN", "STAR_ASSIGN", "DIV_ASSIGN", "MOD_ASSIGN", "SR_ASSIGN", "BSR_ASSIGN", "SL_ASSIGN", "BAND_ASSIGN", "BXOR_ASSIGN", "BOR_ASSIGN", "LOR", "LAND", "BOR", "BXOR", "NOT_EQUAL", "EQUAL", "LE", "GE", "\"instanceof\"", "SL", "PLUS", "MINUS", "DIV", "MOD", "INC", "DEC", "BNOT", "LNOT", "\"true\"", "\"false\"", "\"null\"", "\"new\"", "NUM_INT", "CHAR_LITERAL", "STRING_LITERAL", "NUM_FLOAT", "NUM_LONG", "NUM_DOUBLE", "WS", "SL_COMMENT", "ML_COMMENT", "ESC", "VOCAB", "INT_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL", "HEX_FLOAT_LITERAL", "DEC_DIGIT", "HEX_DIGIT", "DEC_INT", "HEX_INT", "FLOAT_SUFFIX", "EXPONENT", "BINARY_EXPONENT"};
    private static final long[] _tokenSet_0_data_ = new long[]{-84112639524864L, -13194206642177L, 524287L, 0L, 0L, 0L};
    public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);

    public JavaRecognizer(CloverTokenStreamFilter filter, InstrumentationConfig cfg, FileStructureInfo fileInfo) {
        this(filter);
        this.mFilter = filter;
        this.cfg = cfg;
        this.fileInfo = fileInfo;
    }

    private ClassEntryNode enterClass(CloverToken tok, boolean aIsInterface, boolean aIsEnum, boolean isAnnotation) {
        return this.enterClass(null, null, tok, aIsInterface, aIsEnum, isAnnotation, null);
    }

    private ClassEntryNode enterClass(Map tags, Modifiers mods, CloverToken tok, boolean aIsInterface, boolean aIsEnum, boolean isAnnotation, String superclass) {
        String classname = tok.getText();
        int startline = tok.getLine();
        int startcol = tok.getColumn();
        this.classnameList.add(classname);
        String fullname = this.getClassname(this.classnameList);
        ClassEntryNode node = new ClassEntryNode(tags, mods, fullname, this.fileInfo.getPackageName(), superclass, this.currentContext, startline, startcol, this.topLevelClass, aIsInterface, aIsEnum, isAnnotation);
        tok.addPreEmitter(node);
        if (this.topLevelClass) {
            this.currentTopLevelClassEntry = node;
        }
        return node;
    }

    private void exitClass(CloverToken t, ClassEntryNode entry) {
        Contract.pre(this.classnameList.size() > 0);
        this.classnameList.removeLast();
        t.addPreEmitter(new ClassExitNode(entry, this.getClassname(this.classnameList), t.getLine(), t.getColumn() + t.getText().length()));
    }

    private String getClassname(List classlist) {
        String fullname = "";
        String sep = "";
        Iterator names = this.classnameList.iterator();
        while (names.hasNext()) {
            fullname = fullname + sep + (String)names.next();
            sep = ".";
        }
        return fullname;
    }

    private void enterContext(int newContext) {
        this.contextStack.addLast(this.currentContext);
        this.currentContext = new ContextSet(this.currentContext);
        this.currentContext.set(newContext);
    }

    private void enterContext(ContextSet context) {
        this.contextStack.addLast(this.currentContext);
        this.currentContext = context;
    }

    private ContextSet getCurrentContext() {
        return this.currentContext;
    }

    private void exitContext() {
        this.currentContext = (ContextSet)this.contextStack.removeLast();
    }

    private void instrStaticRecorderMember(boolean isEnum) {
        if (this.currentTopLevelClassEntry != null && this.currentTopLevelClassEntry.getRecorderInsertPoint() != null) {
            RecorderInstrEmitter recorderInstr = new RecorderInstrEmitter(isEnum);
            this.currentTopLevelClassEntry.setRecorderInstrEmitter(recorderInstr);
            if (isEnum) {
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPreEmitter(new SimpleEmitter(";"));
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPreEmitter(recorderInstr);
            } else {
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPostEmitter(recorderInstr);
            }
        }
    }

    private void instrSuppressWarnings(CloverToken instrPoint) {
        if (this.cfg.isJava15() && !this.existingFallthroughSuppression && this.fileInfo.isSuppressFallthroughWarnings()) {
            if (this.suppressWarningsInstr == null) {
                instrPoint.addPreEmitter(new SimpleEmitter("@SuppressWarnings({\"fallthrough\"}) "));
            }
        } else if (this.suppressWarningsInstr != null) {
            this.suppressWarningsInstr.setEnabled(false);
        }
    }

    private void setRecorderMemberInsertPoint(ClassEntryNode node, CloverToken insertPoint) {
        if (this.topLevelClass) {
            node.setRecorderInsertPoint(insertPoint);
            this.topLevelClass = false;
        }
    }

    private MethodEntryInstrEmitter instrEnterMethod(MethodSignature sig, CloverToken start, CloverToken lcurly, CloverToken skip) {
        CloverToken instrPoint = skip == null ? lcurly : skip;
        MethodRegistrationNode reg = new MethodRegistrationNode(this.currentContext, sig, start.getLine(), start.getColumn());
        lcurly.addPreEmitter(reg);
        MethodEntryInstrEmitter ret = new MethodEntryInstrEmitter(reg);
        instrPoint.addPostEmitter(ret);
        instrPoint.addPostEmitter(new DirectedFlushEmitter());
        return ret;
    }

    private MethodEntryInstrEmitter instrEnterMethod(MethodSignature sig, CloverToken start, CloverToken lcurly) {
        return this.instrEnterMethod(sig, start, lcurly, null);
    }

    private void instrExitMethod(MethodEntryInstrEmitter entryEmitter, CloverToken tok) {
        tok.addPreEmitter(new MethodExitInstrEmitter(entryEmitter, tok.getLine(), tok.getColumn() + tok.getText().length()));
    }

    private CloverToken maybeAddFlushInstr(CloverToken last) {
        last.addPostEmitter(new DirectedFlushEmitter());
        return last;
    }

    private FlagDeclEmitter declareFlagBefore(CloverToken tok) {
        FlagDeclEmitter flag = new FlagDeclEmitter();
        tok.addPreEmitter(flag);
        return flag;
    }

    private CloverToken instrInlineAfter(CloverToken instr, CloverToken start, CloverToken end) {
        instr.addPostEmitter(new StatementInstrEmitter(this.currentContext, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length()));
        instr.addPostEmitter(new DirectedFlushEmitter());
        this.fileInfo.addStatementMarker(start, end);
        return instr;
    }

    private CloverToken instrInlineAfter(CloverToken tok, CloverToken start, CloverToken end, FlagDeclEmitter flag) {
        tok.addPostEmitter(new FlaggedInstrEmitter(flag, new StatementInstrEmitter(this.currentContext, start.getLine(), start.getColumn(), end.getLine(), end.getText().length())));
        this.fileInfo.addStatementMarker(start, end);
        return tok;
    }

    private CloverToken instrInlineBefore(CloverToken start, CloverToken end, int complexity) {
        start.addPreEmitter(new StatementInstrEmitter(this.currentContext, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), complexity));
        return start;
    }

    private void addCloseBraceAfter(CloverToken tok) {
        CloverToken closeBrace = new CloverToken(83, "}");
        closeBrace.setLine(tok.getLine());
        closeBrace.setColumn(tok.getColumn());
        closeBrace.setPrev(tok);
        closeBrace.setNext(tok.getNext());
        tok.setNext(closeBrace);
    }

    private void addOpenBraceAfter(CloverToken tok) {
        CloverToken openBrace = new CloverToken(82, "{");
        openBrace.setLine(tok.getLine());
        openBrace.setColumn(tok.getColumn());
        openBrace.setPrev(tok);
        openBrace.setNext(tok.getNext());
        tok.setNext(openBrace);
    }

    private CloverToken instrBoolExpr(CloverToken begin, CloverToken end) {
        ExpressionInfo expr = ExpressionInfo.fromTokens(begin, end);
        if (!expr.isConstant()) {
            begin.addPreEmitter(new SimpleEmitter("((("));
            end.addPreEmitter(new EndBoolInstrEmitter(this.currentContext, begin.getLine(), begin.getColumn() - 1, end.getLine(), end.getColumn() + end.getText().length(), expr));
        }
        return end;
    }

    private boolean maybeEnterDeprecated(CloverToken startOfBlock) {
        Map tags = TokenListUtil.getJDocTagsAndValuesOnBlock(startOfBlock);
        boolean deprecated = tags.containsKey("deprecated");
        if (deprecated) {
            this.enterContext(16);
        }
        return deprecated;
    }

    private void maybeExitDeprecated(boolean dep) {
        if (dep) {
            this.exitContext();
        }
    }

    protected JavaRecognizer(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public JavaRecognizer(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected JavaRecognizer(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public JavaRecognizer(TokenStream lexer) {
        this(lexer, 2);
    }

    public JavaRecognizer(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public void compilationUnit() throws RecognitionException, TokenStreamException {
        boolean synPredMatched4 = false;
        if ((this.LA(1) == 44 || this.LA(1) == 80) && this.LA(2) == 50) {
            int _m4 = this.mark();
            synPredMatched4 = true;
            ++this.inputState.guessing;
            try {
                this.packageDefinition();
            }
            catch (RecognitionException pe) {
                synPredMatched4 = false;
            }
            this.rewind(_m4);
            --this.inputState.guessing;
        }
        if (synPredMatched4) {
            this.packageDefinition();
        } else if (this.LA(1) != 1 && this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 47 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 || this.LA(2) != 1 && this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 46) {
            this.importDefinition();
        }
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80) {
            this.typeDefinition(false);
            if (this.inputState.guessing != 0) continue;
            this.topLevelClass = true;
            this.existingFallthroughSuppression = false;
        }
        this.match(1);
    }

    public void packageDefinition() throws RecognitionException, TokenStreamException {
        String pn = "";
        Annotation ann = null;
        while (this.LA(1) == 80) {
            ann = this.annotation();
        }
        this.match(44);
        pn = this.identifier();
        this.match(45);
        if (this.inputState.guessing == 0) {
            this.fileInfo.setPackageName(pn);
        }
    }

    public void importDefinition() throws RecognitionException, TokenStreamException {
        this.match(46);
        if (this.LA(1) == 47) {
            this.match(47);
        } else if (this.LA(1) != 50) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.identifierStar();
        this.match(45);
    }

    public void typeDefinition(boolean nested) throws RecognitionException, TokenStreamException {
        CloverToken first = null;
        Modifiers mods = null;
        if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80) {
            if (this.inputState.guessing == 0) {
                first = (CloverToken)this.LT(1);
            }
            mods = this.modifiers2(!nested);
            this.typeDefinition2(mods, first, nested);
        } else if (this.LA(1) == 45) {
            this.match(45);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected Annotation annotation() throws RecognitionException, TokenStreamException {
        Annotation anno = this.annotation2(false);
        return anno;
    }

    public String identifier() throws RecognitionException, TokenStreamException {
        Token i1 = null;
        Token i2 = null;
        StringBuffer buf = new StringBuffer();
        String str = null;
        i1 = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            buf.append(i1.getText());
        }
        while (this.LA(1) == 51) {
            this.match(51);
            if (this.inputState.guessing == 0) {
                buf.append('.');
            }
            i2 = this.LT(1);
            this.match(50);
            if (this.inputState.guessing != 0) continue;
            buf.append(i2.getText());
        }
        if (this.inputState.guessing == 0) {
            str = buf.toString();
        }
        return str;
    }

    public void identifierStar() throws RecognitionException, TokenStreamException {
        this.match(50);
        while (this.LA(1) == 51 && this.LA(2) == 50) {
            this.match(51);
            this.match(50);
        }
        if (this.LA(1) == 51) {
            this.match(51);
            this.match(69);
        } else if (this.LA(1) != 45) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public Modifiers modifiers2(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Modifiers mods = new Modifiers();
        int m = 0;
        Annotation ann = null;
        while (true) {
            if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76) {
                m = this.modifier();
                if (this.inputState.guessing != 0) continue;
                mods.setModifiers(mods.getModifiers() | m);
                continue;
            }
            if (this.LA(1) != 80 || this.LA(2) != 50) break;
            ann = this.annotation2(instrSuppressWarnings);
            if (this.inputState.guessing != 0) continue;
            mods.addAnnotation(ann);
        }
        return mods;
    }

    public void typeDefinition2(Modifiers mods, CloverToken first, boolean nested) throws RecognitionException, TokenStreamException {
        boolean isEnum = false;
        String name = null;
        if (this.LA(1) == 77) {
            name = this.classDefinition(mods);
        } else if (this.LA(1) == 78) {
            name = this.interfaceDefinition();
        } else if (this.LA(1) == 79) {
            name = this.enumDefinition();
            if (this.inputState.guessing == 0) {
                isEnum = true;
            }
        } else if (this.LA(1) == 80) {
            name = this.annotationTypeDeclaration();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0 && !nested) {
            this.instrStaticRecorderMember(isEnum);
            this.instrSuppressWarnings(first);
        }
    }

    public String classDefinition(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken first = (CloverToken)this.LT(0);
        Map tags = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        String superclass = null;
        ClassEntryNode classEntry = null;
        String classname = null;
        this.match(77);
        if (this.inputState.guessing == 0) {
            tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
            deprecated = this.maybeEnterDeprecated(first);
        }
        id = this.LT(1);
        this.match(50);
        if (this.LA(1) == 52) {
            this.typeParameters();
        } else if (this.LA(1) != 55 && this.LA(1) != 82 && this.LA(1) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        superclass = this.superClassClause();
        this.implementsClause();
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(tags, mods, (CloverToken)id, false, false, false, superclass);
        }
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            classname = id.getText();
        }
        return classname;
    }

    public String interfaceDefinition() throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(78);
        if (this.inputState.guessing == 0) {
            deprecated = this.maybeEnterDeprecated((CloverToken)this.LT(0));
        }
        id = this.LT(1);
        this.match(50);
        if (this.LA(1) == 52) {
            this.typeParameters();
        } else if (this.LA(1) != 55 && this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass((CloverToken)id, true, false, false);
        }
        this.interfaceExtends();
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            name = id.getText();
        }
        return name;
    }

    public String enumDefinition() throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(79);
        if (this.inputState.guessing == 0) {
            deprecated = this.maybeEnterDeprecated((CloverToken)this.LT(0));
        }
        id = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass((CloverToken)id, false, true, false);
        }
        this.implementsClause();
        endOfBlock = this.enumBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            name = id.getText();
        }
        return name;
    }

    public String annotationTypeDeclaration() throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(80);
        this.match(78);
        id = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass((CloverToken)id, false, false, true);
        }
        endOfBlock = this.annotationTypeBody(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            name = id.getText();
        }
        return name;
    }

    public void declaration() throws RecognitionException, TokenStreamException {
        Modifiers mods = null;
        String type = null;
        mods = this.modifiers();
        type = this.typeSpec();
        this.variableDefinitions();
    }

    public Modifiers modifiers() throws RecognitionException, TokenStreamException {
        Modifiers mods = this.modifiers2(false);
        return mods;
    }

    /*
     * WARNING - void declaration
     */
    public String typeSpec() throws RecognitionException, TokenStreamException {
        void var1_1;
        String spec;
        if (this.LA(1) == 50) {
            spec = this.classTypeSpec();
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            spec = this.builtInTypeSpec();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return var1_1;
    }

    public void variableDefinitions() throws RecognitionException, TokenStreamException {
        this.variableDeclarator();
        while (this.LA(1) == 53) {
            this.match(53);
            this.variableDeclarator();
        }
    }

    public String classTypeSpec() throws RecognitionException, TokenStreamException {
        String arrayOpt = "";
        String typeSpec = this.classOrInterfaceType();
        arrayOpt = this.arraySpecOpt();
        if (this.inputState.guessing == 0) {
            typeSpec = typeSpec + arrayOpt;
        }
        return typeSpec;
    }

    public String builtInTypeSpec() throws RecognitionException, TokenStreamException {
        String arrayOpt = "";
        String spec = this.builtInType();
        arrayOpt = this.arraySpecOpt();
        if (this.inputState.guessing == 0) {
            spec = spec + arrayOpt;
        }
        return spec;
    }

    public String arraySpecOpt() throws RecognitionException, TokenStreamException {
        String brackets = "";
        while (this.LA(1) == 48 && this.LA(2) == 49) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0) continue;
            brackets = brackets + "[]";
        }
        return brackets;
    }

    public String classOrInterfaceType() throws RecognitionException, TokenStreamException {
        CloverToken first = null;
        CloverToken last = null;
        String type = null;
        if (this.inputState.guessing == 0) {
            first = (CloverToken)this.LT(1);
        }
        this.match(50);
        if (this.LA(1) == 52) {
            this.typeArguments();
        } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 87 && this.LA(1) != 89 && this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 51 && this.LA(2) == 50) {
            this.match(51);
            this.match(50);
            if (this.LA(1) == 52) {
                this.typeArguments();
                continue;
            }
            if (this.LA(1) == 45 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 58 || this.LA(1) == 59 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 81 || this.LA(1) == 82 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 85 || this.LA(1) == 87 || this.LA(1) == 89 || this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119 || this.LA(1) == 120 || this.LA(1) == 121 || this.LA(1) == 122 || this.LA(1) == 123 || this.LA(1) == 124) continue;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            last = (CloverToken)this.LT(0);
            type = TokenListUtil.getNormalisedSequence(first, last);
        }
        return type;
    }

    public void typeArguments() throws RecognitionException, TokenStreamException {
        int currentLtLevel = 0;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        this.match(52);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
        }
        this.singleTypeArgument();
        while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 54 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68)) {
            this.match(53);
            this.singleTypeArgument();
        }
        if (this.LA(1) >= 57 && this.LA(1) <= 59 && (this.LA(2) == 45 || this.LA(2) == 48 || this.LA(2) == 49 || this.LA(2) == 50 || this.LA(2) == 51 || this.LA(2) == 53 || this.LA(2) == 54 || this.LA(2) == 55 || this.LA(2) == 56 || this.LA(2) == 57 || this.LA(2) == 58 || this.LA(2) == 59 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 81 || this.LA(2) == 82 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 85 || this.LA(2) == 87 || this.LA(2) == 89 || this.LA(2) == 91 || this.LA(2) == 93 || this.LA(2) == 108 || this.LA(2) == 109 || this.LA(2) == 110 || this.LA(2) == 111 || this.LA(2) == 112 || this.LA(2) == 113 || this.LA(2) == 114 || this.LA(2) == 115 || this.LA(2) == 116 || this.LA(2) == 117 || this.LA(2) == 118 || this.LA(2) == 119 || this.LA(2) == 120 || this.LA(2) == 121 || this.LA(2) == 122 || this.LA(2) == 123 || this.LA(2) == 124)) {
            this.typeArgumentsEnd();
        } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 87 && this.LA(1) != 89 && this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 || !_tokenSet_0.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void singleTypeArgument() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 50) {
            type = this.classTypeSpec();
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            type = this.builtInTypeSpec();
        } else {
            if (this.LA(1) != 54) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.match(54);
        }
        if (!(this.LA(1) != 55 && this.LA(1) != 56 || this.LA(2) != 50 && this.LA(2) != 54 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68)) {
            if (this.LA(1) == 55) {
                this.match(55);
            } else {
                if (this.LA(1) != 56) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(56);
            }
            if (this.LA(1) == 50) {
                type = this.classTypeSpec();
                return;
            } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
                type = this.builtInTypeSpec();
                return;
            } else {
                if (this.LA(1) != 54) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(54);
            }
            return;
        } else {
            if ((this.LA(1) == 45 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 58 || this.LA(1) == 59 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 81 || this.LA(1) == 82 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 85 || this.LA(1) == 87 || this.LA(1) == 89 || this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119 || this.LA(1) == 120 || this.LA(1) == 121 || this.LA(1) == 122 || this.LA(1) == 123 || this.LA(1) == 124) && _tokenSet_0.member(this.LA(2))) return;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected void typeArgumentsEnd() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 57) {
            this.match(57);
            if (this.inputState.guessing == 0) {
                --this.ltCounter;
            }
        } else if (this.LA(1) == 58) {
            this.match(58);
            if (this.inputState.guessing == 0) {
                this.ltCounter -= 2;
            }
        } else if (this.LA(1) == 59) {
            this.match(59);
            if (this.inputState.guessing == 0) {
                this.ltCounter -= 3;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public String builtInType() throws RecognitionException, TokenStreamException {
        String type = "";
        if (this.LA(1) == 60) {
            this.match(60);
        } else if (this.LA(1) == 61) {
            this.match(61);
        } else if (this.LA(1) == 62) {
            this.match(62);
        } else if (this.LA(1) == 63) {
            this.match(63);
        } else if (this.LA(1) == 64) {
            this.match(64);
        } else if (this.LA(1) == 65) {
            this.match(65);
        } else if (this.LA(1) == 66) {
            this.match(66);
        } else if (this.LA(1) == 67) {
            this.match(67);
        } else if (this.LA(1) == 68) {
            this.match(68);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            type = this.LT(0).getText();
        }
        return type;
    }

    public void type() throws RecognitionException, TokenStreamException {
        String spec = null;
        if (this.LA(1) == 50) {
            spec = this.classOrInterfaceType();
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            spec = this.builtInType();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public int modifier() throws RecognitionException, TokenStreamException {
        int m = 0;
        if (this.LA(1) == 70) {
            this.match(70);
            if (this.inputState.guessing == 0) {
                m = 2;
            }
        } else if (this.LA(1) == 71) {
            this.match(71);
            if (this.inputState.guessing == 0) {
                m = 1;
            }
        } else if (this.LA(1) == 72) {
            this.match(72);
            if (this.inputState.guessing == 0) {
                m = 4;
            }
        } else if (this.LA(1) == 47) {
            this.match(47);
            if (this.inputState.guessing == 0) {
                m = 8;
            }
        } else if (this.LA(1) == 73) {
            this.match(73);
            if (this.inputState.guessing == 0) {
                m = 128;
            }
        } else if (this.LA(1) == 39) {
            this.match(39);
            if (this.inputState.guessing == 0) {
                m = 16;
            }
        } else if (this.LA(1) == 40) {
            this.match(40);
            if (this.inputState.guessing == 0) {
                m = 1024;
            }
        } else if (this.LA(1) == 74) {
            this.match(74);
            if (this.inputState.guessing == 0) {
                m = 256;
            }
        } else if (this.LA(1) == 75) {
            this.match(75);
            if (this.inputState.guessing == 0) {
                m = 32;
            }
        } else if (this.LA(1) == 76) {
            this.match(76);
            if (this.inputState.guessing == 0) {
                m = 64;
            }
        } else if (this.LA(1) == 41) {
            this.match(41);
            if (this.inputState.guessing == 0) {
                m = 2048;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return m;
    }

    protected Annotation annotation2(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Token lparen = null;
        boolean isSuppressWarnings = false;
        boolean ft = false;
        CloverToken ident = null;
        boolean hasArgs = false;
        String annotationName = null;
        Annotation anno = new Annotation();
        this.match(80);
        annotationName = this.identifier();
        if (this.inputState.guessing == 0) {
            ident = (CloverToken)this.LT(0);
            isSuppressWarnings = instrSuppressWarnings && "SuppressWarnings".equals(annotationName);
            anno.setName(annotationName);
        }
        if (this.LA(1) == 84 && this.LA(2) == 85) {
            lparen = this.LT(1);
            this.match(84);
            this.match(85);
        } else {
            boolean synPredMatched274 = false;
            if (this.LA(1) == 84 && this.LA(2) == 50) {
                int _m274 = this.mark();
                synPredMatched274 = true;
                ++this.inputState.guessing;
                try {
                    this.match(84);
                    this.match(50);
                    this.match(89);
                }
                catch (RecognitionException pe) {
                    synPredMatched274 = false;
                }
                this.rewind(_m274);
                --this.inputState.guessing;
            }
            if (synPredMatched274) {
                this.match(84);
                this.annMemberValuePair(anno, isSuppressWarnings);
                while (this.LA(1) == 53) {
                    this.match(53);
                    this.annMemberValuePair(anno, false);
                }
                this.match(85);
                if (this.inputState.guessing == 0) {
                    hasArgs = true;
                }
            } else if (this.LA(1) == 84 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 80 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(84);
                ft = this.annMemberValue2(anno, "value", isSuppressWarnings, true);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    hasArgs = true;
                }
            } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 && this.LA(1) != 83 && this.LA(1) != 85) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0 && isSuppressWarnings && !hasArgs) {
            this.suppressWarningsInstr = new SimpleEmitter("{\"fallthrough\"}");
            SimpleEmitter openParen = new SimpleEmitter("(");
            SimpleEmitter closeParen = new SimpleEmitter(")");
            CloverToken instrPoint = (CloverToken)lparen;
            if (instrPoint == null) {
                instrPoint = ident;
                this.suppressWarningsInstr.addDependent(openParen);
                this.suppressWarningsInstr.addDependent(closeParen);
                instrPoint.addPostEmitter(openParen);
            }
            instrPoint.addPostEmitter(this.suppressWarningsInstr);
            if (lparen == null) {
                instrPoint.addPostEmitter(closeParen);
            }
        }
        return anno;
    }

    public void typeParameters() throws RecognitionException, TokenStreamException {
        int currentLtLevel = 0;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        this.match(52);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
        }
        this.typeParameter();
        while (this.LA(1) == 53) {
            this.match(53);
            this.typeParameter();
        }
        if (this.LA(1) >= 57 && this.LA(1) <= 59) {
            this.typeArgumentsEnd();
        } else if (this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 82 && this.LA(1) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
    }

    public String superClassClause() throws RecognitionException, TokenStreamException {
        String superclass = null;
        if (this.LA(1) == 55) {
            this.match(55);
            superclass = this.classOrInterfaceType();
        } else if (this.LA(1) != 82 && this.LA(1) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return superclass;
    }

    public void implementsClause() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 87) {
            this.match(87);
            type = this.classOrInterfaceType();
            while (this.LA(1) == 53) {
                this.match(53);
                type = this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public CloverToken classBlock(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        Token rc = null;
        CloverToken t = null;
        ip = this.LT(1);
        this.match(82);
        if (this.inputState.guessing == 0) {
            this.setRecorderMemberInsertPoint(classEntry, (CloverToken)ip);
        }
        while (true) {
            if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 52 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80 || this.LA(1) == 82) {
                this.field(classEntry);
                continue;
            }
            if (this.LA(1) != 45) break;
            this.match(45);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)rc;
        }
        return t;
    }

    public void interfaceExtends() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 55) {
            this.match(55);
            type = this.classOrInterfaceType();
            while (this.LA(1) == 53) {
                this.match(53);
                type = this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public CloverToken enumBlock(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        boolean topLevelSave = this.topLevelClass;
        CloverToken t = null;
        this.match(82);
        if (!(this.LA(1) != 45 && this.LA(1) != 50 && this.LA(1) != 53 && this.LA(1) != 80 && this.LA(1) != 83 || this.LA(2) != 1 && this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84)) {
            if (this.LA(1) == 50 || this.LA(1) == 80) {
                this.enumConstant();
                while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 80)) {
                    this.match(53);
                    this.enumConstant();
                }
            } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 83) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 53) {
                this.match(53);
            } else if (this.LA(1) != 45 && this.LA(1) != 83) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 45) {
                if (this.inputState.guessing == 0) {
                    topLevelSave = this.topLevelClass;
                    this.topLevelClass = false;
                }
                this.match(45);
                while (true) {
                    if (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 52 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80 || this.LA(1) == 82) {
                        this.field(null);
                        continue;
                    }
                    if (this.LA(1) != 45) break;
                    this.match(45);
                }
                if (this.inputState.guessing == 0) {
                    this.topLevelClass = topLevelSave;
                }
            } else if (this.LA(1) != 83) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else if (this.LA(1) != 83 || this.LA(2) != 1 && this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        ip = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)ip;
            this.setRecorderMemberInsertPoint(classEntry, t);
        }
        return t;
    }

    public CloverToken annotationTypeBody(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        Token endOfBlock = null;
        boolean topLevelSave = this.topLevelClass;
        CloverToken t = null;
        Modifiers mods = null;
        String type = null;
        ip = this.LT(1);
        this.match(82);
        if (this.inputState.guessing == 0) {
            this.setRecorderMemberInsertPoint(classEntry, (CloverToken)ip);
        }
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80) {
            mods = this.modifiers();
            if (this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68) {
                type = this.typeSpec();
                if (this.LA(1) == 50 && this.LA(2) == 84) {
                    this.match(50);
                    this.match(84);
                    this.match(85);
                    if (this.LA(1) == 86) {
                        this.annDefaultValue();
                    } else if (this.LA(1) != 45) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(45);
                    continue;
                }
                if (this.LA(1) == 50 && (this.LA(2) == 45 || this.LA(2) == 48 || this.LA(2) == 53 || this.LA(2) == 89)) {
                    this.variableDefinitions();
                    this.match(45);
                    continue;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) >= 77 && this.LA(1) <= 80) {
                if (this.inputState.guessing == 0) {
                    topLevelSave = this.topLevelClass;
                    this.topLevelClass = false;
                }
                this.typeDefinition2(mods, null, true);
                if (this.inputState.guessing != 0) continue;
                this.topLevelClass = topLevelSave;
                continue;
            }
            if (this.LA(1) == 45) {
                this.match(45);
                continue;
            }
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        endOfBlock = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)endOfBlock;
        }
        return t;
    }

    public void typeParameter() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 50) {
            this.match(50);
        } else if (this.LA(1) == 54) {
            this.match(54);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 55 && this.LA(2) == 50) {
            this.match(55);
            type = this.classOrInterfaceType();
            while (this.LA(1) == 81) {
                this.match(81);
                type = this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 50 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 82 && this.LA(1) != 87 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 87) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void field(ClassEntryNode containingClass) throws RecognitionException, TokenStreamException {
        Token methodName = null;
        CloverToken first = (CloverToken)this.LT(1);
        CloverToken endSig = null;
        boolean deprecated = false;
        Modifiers mods = null;
        Object name = null;
        MethodSignature signature = null;
        String[] throwsTypes = null;
        String returnType = "";
        String brackets = "";
        String[] paramTypes = null;
        Map tags = null;
        String typename = null;
        if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 52 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 84)) {
            if (this.inputState.guessing == 0) {
                tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
            }
            mods = this.modifiers();
            if (this.inputState.guessing == 0) {
                boolean bl = deprecated = tags.containsKey("deprecated") || mods.containsAnnotation("Deprecated");
                if (deprecated) {
                    this.enterContext(16);
                }
            }
            if (this.LA(1) == 77) {
                typename = this.classDefinition(mods);
            } else if (this.LA(1) == 78) {
                typename = this.interfaceDefinition();
            } else if (this.LA(1) == 79) {
                typename = this.enumDefinition();
            } else if (this.LA(1) == 80) {
                typename = this.annotationTypeDeclaration();
            } else {
                if (this.LA(1) != 50 && this.LA(1) != 52 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) throw new NoViableAltException(this.LT(1), this.getFilename());
                if (this.LA(1) == 52) {
                    this.typeParameters();
                } else if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 50 && this.LA(2) == 84) {
                    signature = this.ctorHead(tags, mods, first);
                    if (this.inputState.guessing == 0) {
                        endSig = (CloverToken)this.LT(0);
                    }
                    this.constructorBody(signature, first, endSig);
                } else {
                    if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52) throw new NoViableAltException(this.LT(1), this.getFilename());
                    returnType = this.typeSpec();
                    if (this.LA(1) == 50 && this.LA(2) == 84) {
                        methodName = this.LT(1);
                        this.match(50);
                        this.match(84);
                        paramTypes = this.parameterDeclarationList();
                        this.match(85);
                        brackets = this.declaratorBrackets();
                        if (this.LA(1) == 90) {
                            throwsTypes = this.throwsClause();
                        } else if (this.LA(1) != 45 && this.LA(1) != 82) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing == 0) {
                            endSig = (CloverToken)this.LT(0);
                            signature = new MethodSignature(first, (CloverToken)methodName, endSig, tags, mods, methodName.getText(), returnType + brackets, paramTypes, throwsTypes);
                        }
                        if (this.LA(1) == 82) {
                            this.outerCompoundStmt(signature, first, endSig, 4);
                        } else {
                            if (this.LA(1) != 45) throw new NoViableAltException(this.LT(1), this.getFilename());
                            this.match(45);
                        }
                    } else {
                        if (this.LA(1) != 50 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 53 && this.LA(2) != 89) throw new NoViableAltException(this.LT(1), this.getFilename());
                        this.variableDefinitions();
                        this.match(45);
                    }
                }
            }
            if (this.inputState.guessing != 0) return;
            this.maybeExitDeprecated(deprecated);
            return;
        } else if (this.LA(1) == 47 && this.LA(2) == 82) {
            if (this.inputState.guessing == 0) {
                deprecated = this.maybeEnterDeprecated(first);
                signature = new MethodSignature(null, null, null, "<clinit>, line " + first.getLine(), null, null, null);
            }
            this.match(47);
            this.outerCompoundStmt(signature, first, null, 1);
            if (this.inputState.guessing != 0) return;
            this.maybeExitDeprecated(deprecated);
            return;
        } else {
            if (this.LA(1) != 82) throw new NoViableAltException(this.LT(1), this.getFilename());
            if (this.inputState.guessing == 0) {
                deprecated = this.maybeEnterDeprecated(first);
                signature = new MethodSignature(null, null, null, "<init>, line " + first.getLine(), null, null, null);
            }
            this.outerCompoundStmt(signature, first, null, 2);
            if (this.inputState.guessing != 0) return;
            this.maybeExitDeprecated(deprecated);
        }
    }

    public void enumConstant() throws RecognitionException, TokenStreamException {
        boolean topLevelSave = this.topLevelClass;
        CloverToken endOfBlock = null;
        Annotation ann = null;
        if (this.inputState.guessing == 0) {
            topLevelSave = this.topLevelClass;
            this.topLevelClass = false;
        }
        while (this.LA(1) == 80) {
            ann = this.annotation();
        }
        this.match(50);
        if (this.LA(1) == 84) {
            this.match(84);
            this.argList();
            this.match(85);
        } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 82 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 82) {
            endOfBlock = this.classBlock(null);
        } else if (this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            this.topLevelClass = topLevelSave;
        }
    }

    public void argList() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.expressionList();
        } else if (this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected void annDefaultValue() throws RecognitionException, TokenStreamException {
        boolean ft = false;
        this.match(86);
        ft = this.annMemberValue(false, false);
    }

    protected boolean annMemberValue(boolean isSuppressWarnings, boolean makeArrayAndAdd) throws RecognitionException, TokenStreamException {
        boolean wasFallthroughLiteral = this.annMemberValue2(null, null, isSuppressWarnings, makeArrayAndAdd);
        return wasFallthroughLiteral;
    }

    public MethodSignature ctorHead(Map tags, Modifiers mods, CloverToken first) throws RecognitionException, TokenStreamException {
        Token ctorName = null;
        MethodSignature sig = null;
        String[] paramsTypes = null;
        String[] throwsTypes = null;
        ctorName = this.LT(1);
        this.match(50);
        this.match(84);
        paramsTypes = this.parameterDeclarationList();
        this.match(85);
        if (this.LA(1) == 90) {
            throwsTypes = this.throwsClause();
        } else if (this.LA(1) != 82) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken endSig = (CloverToken)this.LT(0);
            sig = new MethodSignature(first, (CloverToken)ctorName, endSig, tags, mods, ctorName.getText(), null, paramsTypes, throwsTypes);
        }
        return sig;
    }

    public void constructorBody(MethodSignature signature, CloverToken start, CloverToken endSig) throws RecognitionException, TokenStreamException {
        Token lc = null;
        Token rc = null;
        CloverToken endOfInv = null;
        if (this.inputState.guessing == 0) {
            this.enterContext(3);
        }
        lc = this.LT(1);
        this.match(82);
        boolean synPredMatched114 = false;
        if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            int _m114 = this.mark();
            synPredMatched114 = true;
            ++this.inputState.guessing;
            try {
                this.explicitConstructorInvocation();
            }
            catch (RecognitionException pe) {
                synPredMatched114 = false;
            }
            this.rewind(_m114);
            --this.inputState.guessing;
        }
        if (synPredMatched114) {
            endOfInv = this.explicitConstructorInvocation();
        } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 105 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 105 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            CloverToken tmp = this.statement(null);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            MethodEntryInstrEmitter entry = this.instrEnterMethod(signature, start, (CloverToken)lc, endOfInv);
            this.instrExitMethod(entry, (CloverToken)rc);
            this.exitContext();
            this.fileInfo.addMethodMarker(entry, start, endSig, (CloverToken)rc);
        }
    }

    public String[] parameterDeclarationList() throws RecognitionException, TokenStreamException {
        ArrayList<String> paramTypes = new ArrayList<String>();
        String type = null;
        String[] params = new String[]{};
        if (this.LA(1) == 39 || this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 80) {
            type = this.parameterDeclaration();
            if (this.inputState.guessing == 0) {
                paramTypes.add(type);
            }
            while (this.LA(1) == 53) {
                this.match(53);
                type = this.parameterDeclaration();
                if (this.inputState.guessing != 0) continue;
                paramTypes.add(type);
            }
        } else if (this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            params = paramTypes.toArray(new String[paramTypes.size()]);
        }
        return params;
    }

    public String declaratorBrackets() throws RecognitionException, TokenStreamException {
        String brackets = "";
        while (this.LA(1) == 48) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0) continue;
            brackets = brackets + "[]";
        }
        return brackets;
    }

    public String[] throwsClause() throws RecognitionException, TokenStreamException {
        ArrayList<String> throwsList = new ArrayList<String>();
        String[] throwsTypes = null;
        this.match(90);
        String id = this.identifier();
        if (this.inputState.guessing == 0) {
            throwsList.add(id);
        }
        while (this.LA(1) == 53) {
            this.match(53);
            id = this.identifier();
            if (this.inputState.guessing != 0) continue;
            throwsList.add(id);
        }
        if (this.inputState.guessing == 0) {
            throwsTypes = throwsList.toArray(new String[throwsList.size()]);
        }
        return throwsTypes;
    }

    public void outerCompoundStmt(MethodSignature sig, CloverToken start, CloverToken endSig, int context) throws RecognitionException, TokenStreamException {
        Token lc = null;
        Token rc = null;
        if (this.inputState.guessing == 0) {
            this.enterContext(context);
        }
        lc = this.LT(1);
        this.match(82);
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            CloverToken tmp = this.statement(null);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            MethodEntryInstrEmitter entry = this.instrEnterMethod(sig, start, (CloverToken)lc);
            this.instrExitMethod(entry, (CloverToken)rc);
            this.exitContext();
            if (context == 4) {
                this.fileInfo.addMethodMarker(entry, start, endSig, (CloverToken)rc);
            }
        }
    }

    public CloverToken explicitConstructorInvocation() throws RecognitionException, TokenStreamException {
        Token pos1 = null;
        Token t1 = null;
        Token pos2 = null;
        Token lp2 = null;
        Token t2 = null;
        Token pos3 = null;
        Token lp3 = null;
        Token t3 = null;
        CloverToken t = null;
        if (this.LA(1) == 88 && this.LA(2) == 84) {
            pos1 = this.LT(1);
            this.match(88);
            this.match(84);
            this.argList();
            this.match(85);
            t1 = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter((CloverToken)t1, (CloverToken)pos1, (CloverToken)t1);
            }
        } else if (this.LA(1) == 56 && this.LA(2) == 84) {
            pos2 = this.LT(1);
            this.match(56);
            lp2 = this.LT(1);
            this.match(84);
            this.argList();
            this.match(85);
            t2 = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter((CloverToken)t2, (CloverToken)pos2, (CloverToken)t2);
            }
        } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            this.primaryExpression();
            if (this.LA(1) == 51 && this.LA(2) == 88) {
                this.match(51);
                this.match(88);
            } else if (this.LA(1) != 51 || this.LA(2) != 56) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(51);
            pos3 = this.LT(1);
            this.match(56);
            lp3 = this.LT(1);
            this.match(84);
            this.argList();
            this.match(85);
            t3 = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter((CloverToken)t3, (CloverToken)pos3, (CloverToken)t3);
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return t;
    }

    public CloverToken statement(CloverToken owningLabel) throws RecognitionException, TokenStreamException {
        Token colon = null;
        Token semi = null;
        Token se1 = null;
        Token se2 = null;
        Token rp1 = null;
        Token el = null;
        Token rp = null;
        Token rp2 = null;
        Token d1 = null;
        Token rp3 = null;
        Token sem = null;
        Token sw = null;
        Token rc = null;
        CloverToken first = null;
        CloverToken tmp = null;
        CloverToken labelTok = null;
        boolean assertColonPart = false;
        CloverToken last = null;
        boolean labelled = owningLabel != null;
        FlagDeclEmitter flag = null;
        boolean matchable = true;
        boolean instrumentable = !labelled;
        Object instr = null;
        CloverToken flushAfter = null;
        int complexity = 0;
        int tmpCmp = 0;
        boolean wasDefault = false;
        Modifiers mods = null;
        String paramType = null;
        String classname = null;
        ContextSet saveContext = this.getCurrentContext();
        if (this.inputState.guessing == 0) {
            first = (CloverToken)this.LT(1);
        }
        if (this.LA(1) == 92 && this.cfg.isJava14()) {
            this.match(92);
            if (this.inputState.guessing == 0) {
                this.enterContext(15);
                instrumentable = false;
                saveContext = this.getCurrentContext();
            }
            if (this.inputState.guessing == 0) {
                tmp = (CloverToken)this.LT(1);
            }
            this.expression();
            if (this.LA(1) == 93) {
                colon = this.LT(1);
                this.match(93);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)colon);
                    assertColonPart = true;
                }
                this.expression();
            } else if (this.LA(1) != 45) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            semi = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                if (!assertColonPart) {
                    this.instrBoolExpr(tmp, (CloverToken)semi);
                }
                this.exitContext();
            }
        } else if (this.LA(1) == 82) {
            tmp = this.compoundStatement();
            if (this.inputState.guessing == 0) {
                matchable = false;
                instrumentable = false;
            }
        } else {
            boolean synPredMatched163 = false;
            if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 80)) {
                int _m163 = this.mark();
                synPredMatched163 = true;
                ++this.inputState.guessing;
                try {
                    this.declaration();
                }
                catch (RecognitionException pe) {
                    synPredMatched163 = false;
                }
                this.rewind(_m163);
                --this.inputState.guessing;
            }
            if (synPredMatched163) {
                this.declaration();
                se1 = this.LT(1);
                this.match(45);
                if (this.inputState.guessing == 0) {
                    flushAfter = (CloverToken)se1;
                }
            } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
                this.expression();
                se2 = this.LT(1);
                this.match(45);
                if (this.inputState.guessing == 0) {
                    flushAfter = (CloverToken)se2;
                }
            } else if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 80)) {
                mods = this.modifiers();
                classname = this.classDefinition(mods);
                if (this.inputState.guessing == 0) {
                    instrumentable = false;
                }
            } else if (this.LA(1) == 50 && this.LA(2) == 93) {
                this.match(50);
                this.match(93);
                if (this.inputState.guessing == 0) {
                    labelTok = owningLabel;
                    if (!labelled) {
                        labelTok = first;
                    }
                }
                last = this.statement(labelTok);
            } else if (this.LA(1) == 94) {
                this.match(94);
                if (this.inputState.guessing == 0) {
                    this.enterContext(9);
                    saveContext = this.getCurrentContext();
                    complexity = 1;
                }
                this.match(84);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)this.LT(1);
                }
                this.expression();
                rp1 = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)rp1);
                    this.addOpenBraceAfter((CloverToken)rp1);
                }
                last = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(last);
                    this.exitContext();
                }
                if (this.LA(1) == 95 && (this.LA(2) == 39 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 45 || this.LA(2) == 47 || this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 70 || this.LA(2) == 71 || this.LA(2) == 72 || this.LA(2) == 73 || this.LA(2) == 74 || this.LA(2) == 75 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 80 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 92 || this.LA(2) == 94 || this.LA(2) == 96 || this.LA(2) == 97 || this.LA(2) == 98 || this.LA(2) == 99 || this.LA(2) == 100 || this.LA(2) == 101 || this.LA(2) == 102 || this.LA(2) == 103 || this.LA(2) == 105 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                    el = this.LT(1);
                    this.match(95);
                    if (this.inputState.guessing == 0) {
                        this.addOpenBraceAfter((CloverToken)el);
                        this.enterContext(10);
                        saveContext = this.getCurrentContext();
                    }
                    last = this.statement(null);
                    if (this.inputState.guessing == 0) {
                        this.addCloseBraceAfter(last);
                        this.exitContext();
                    }
                } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 88 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else if (this.LA(1) == 96) {
                this.match(96);
                if (this.inputState.guessing == 0) {
                    this.enterContext(8);
                    complexity = 1;
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                boolean synPredMatched167 = false;
                if (!(this.LA(1) != 39 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 80 || this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 80 && this.LA(2) != 91)) {
                    int _m167 = this.mark();
                    synPredMatched167 = true;
                    ++this.inputState.guessing;
                    try {
                        this.parameterDeclaration();
                        this.match(93);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched167 = false;
                    }
                    this.rewind(_m167);
                    --this.inputState.guessing;
                }
                if (synPredMatched167) {
                    paramType = this.parameterDeclaration();
                    this.match(93);
                    this.expression();
                } else if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 80 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
                    this.forInit();
                    this.match(45);
                    this.forCond();
                    this.forIter();
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                rp = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.addOpenBraceAfter((CloverToken)rp);
                }
                last = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(last);
                    this.exitContext();
                }
            } else if (this.LA(1) == 97) {
                this.match(97);
                if (this.inputState.guessing == 0) {
                    this.enterContext(6);
                    complexity = 1;
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)this.LT(1);
                }
                this.expression();
                rp2 = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)rp2);
                    this.addOpenBraceAfter((CloverToken)rp2);
                }
                last = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(last);
                    this.exitContext();
                }
            } else if (this.LA(1) == 98) {
                d1 = this.LT(1);
                this.match(98);
                if (this.inputState.guessing == 0) {
                    this.addOpenBraceAfter((CloverToken)d1);
                    this.enterContext(7);
                    complexity = 1;
                    saveContext = this.getCurrentContext();
                }
                tmp = this.statement(null);
                if (this.inputState.guessing == 0) {
                    this.addCloseBraceAfter(tmp);
                    this.exitContext();
                }
                this.match(97);
                this.match(84);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)this.LT(1);
                }
                this.expression();
                rp3 = this.LT(1);
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, (CloverToken)rp3);
                }
                sem = this.LT(1);
                this.match(45);
                if (this.inputState.guessing == 0) {
                    flushAfter = (CloverToken)sem;
                }
            } else if (this.LA(1) == 99) {
                this.match(99);
                if (this.LA(1) == 50) {
                    this.match(50);
                } else if (this.LA(1) != 45) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(45);
            } else if (this.LA(1) == 100) {
                this.match(100);
                if (this.LA(1) == 50) {
                    this.match(50);
                } else if (this.LA(1) != 45) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(45);
            } else if (this.LA(1) == 101) {
                this.match(101);
                if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
                    this.expression();
                } else if (this.LA(1) != 45) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(45);
            } else if (this.LA(1) == 102) {
                sw = this.LT(1);
                this.match(102);
                if (this.inputState.guessing == 0) {
                    tmp = (CloverToken)sw;
                    if (labelled) {
                        tmp = owningLabel;
                    }
                    flag = this.declareFlagBefore(tmp);
                    this.enterContext(5);
                    saveContext = this.getCurrentContext();
                }
                this.match(84);
                this.expression();
                this.match(85);
                this.match(82);
                while (this.LA(1) == 86 || this.LA(1) == 104) {
                    tmpCmp = this.casesGroup(flag);
                    if (this.inputState.guessing != 0) continue;
                    complexity += tmpCmp;
                }
                if (this.inputState.guessing == 0) {
                    this.exitContext();
                }
                rc = this.LT(1);
                this.match(83);
            } else if (this.LA(1) == 105) {
                last = this.tryBlock(labelled);
                if (this.inputState.guessing == 0) {
                    instrumentable = false;
                }
            } else if (this.LA(1) == 103) {
                this.match(103);
                this.expression();
                this.match(45);
            } else if (this.LA(1) == 75 && this.LA(2) == 84) {
                this.match(75);
                this.match(84);
                this.expression();
                this.match(85);
                if (this.inputState.guessing == 0) {
                    this.enterContext(14);
                    saveContext = this.getCurrentContext();
                }
                last = this.compoundStatement();
                if (this.inputState.guessing == 0) {
                    this.exitContext();
                }
            } else if (this.LA(1) == 45) {
                this.match(45);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            if (last == null) {
                last = (CloverToken)this.LT(0);
            }
            if (instrumentable) {
                this.enterContext(saveContext);
                this.instrInlineBefore(first, last, complexity);
                this.exitContext();
            }
            if (flushAfter != null) {
                this.maybeAddFlushInstr(flushAfter);
            }
            if (matchable) {
                this.fileInfo.addStatementMarker(first, last);
            }
        }
        return last;
    }

    public void primaryExpression() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 50) {
            this.match(50);
        } else if (this.LA(1) >= 141 && this.LA(1) <= 146) {
            this.constant();
        } else if (this.LA(1) == 137) {
            this.match(137);
        } else if (this.LA(1) == 138) {
            this.match(138);
        } else if (this.LA(1) == 88) {
            this.match(88);
        } else if (this.LA(1) == 139) {
            this.match(139);
        } else if (this.LA(1) == 140) {
            this.newExpression();
        } else if (this.LA(1) == 84) {
            this.match(84);
            this.assignmentExpression();
            this.match(85);
        } else if (this.LA(1) == 56) {
            this.match(56);
        } else if (this.LA(1) >= 60 && this.LA(1) <= 68) {
            type = this.builtInType();
            while (this.LA(1) == 48) {
                this.match(48);
                this.match(49);
            }
            this.match(51);
            this.match(77);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void variableDeclarator() throws RecognitionException, TokenStreamException {
        String brackets = null;
        this.match(50);
        brackets = this.declaratorBrackets();
        this.varInitializer();
    }

    public void varInitializer() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 89) {
            this.match(89);
            this.initializer();
        } else if (this.LA(1) != 45 && this.LA(1) != 53) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void initializer() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.expression();
        } else if (this.LA(1) == 82) {
            this.arrayInitializer();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void arrayInitializer() throws RecognitionException, TokenStreamException {
        this.match(82);
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.initializer();
            while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(53);
                this.initializer();
            }
        } else if (this.LA(1) != 53 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 53) {
            this.match(53);
        } else if (this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(83);
    }

    public void expression() throws RecognitionException, TokenStreamException {
        this.assignmentExpression();
    }

    public String parameterDeclaration() throws RecognitionException, TokenStreamException {
        String type = null;
        String brackets = "";
        String paramType = null;
        this.parameterModifier();
        type = this.typeSpec();
        if (this.LA(1) == 91) {
            this.match(91);
        } else if (this.LA(1) != 50) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(50);
        brackets = this.declaratorBrackets();
        if (this.inputState.guessing == 0) {
            paramType = type + brackets;
        }
        return paramType;
    }

    public void parameterModifier() throws RecognitionException, TokenStreamException {
        Token f = null;
        Annotation ann = null;
        while (this.LA(1) == 80) {
            ann = this.annotation();
        }
        if (this.LA(1) == 39) {
            f = this.LT(1);
            this.match(39);
            while (this.LA(1) == 80) {
                ann = this.annotation();
            }
        } else if (this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public CloverToken compoundStatement() throws RecognitionException, TokenStreamException {
        Token rc = null;
        CloverToken t = null;
        this.match(82);
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            t = this.statement(null);
        }
        rc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            t = (CloverToken)rc;
        }
        return t;
    }

    public void forInit() throws RecognitionException, TokenStreamException {
        boolean synPredMatched186 = false;
        if (!(this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 80 || this.LA(2) != 39 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 80)) {
            int _m186 = this.mark();
            synPredMatched186 = true;
            ++this.inputState.guessing;
            try {
                this.declaration();
            }
            catch (RecognitionException pe) {
                synPredMatched186 = false;
            }
            this.rewind(_m186);
            --this.inputState.guessing;
        }
        if (synPredMatched186) {
            this.declaration();
        } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            this.expressionList();
        } else if (this.LA(1) != 45) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void forCond() throws RecognitionException, TokenStreamException {
        Token se = null;
        CloverToken tmp = null;
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            if (this.inputState.guessing == 0) {
                tmp = (CloverToken)this.LT(1);
            }
            this.expression();
            se = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                this.instrBoolExpr(tmp, (CloverToken)se);
            }
        } else if (this.LA(1) == 45) {
            this.match(45);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void forIter() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.expressionList();
        } else if (this.LA(1) != 85) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public int casesGroup(FlagDeclEmitter flag) throws RecognitionException, TokenStreamException {
        int tmp = 0;
        int complexity = 0;
        int _cnt177 = 0;
        while (true) {
            if (!(this.LA(1) != 86 && this.LA(1) != 104 || this.LA(2) != 50 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 84 && this.LA(2) != 88 && this.LA(2) != 93 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
                tmp = this.aCase(flag);
                if (this.inputState.guessing == 0) {
                    complexity += tmp;
                }
            } else {
                if (_cnt177 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt177;
        }
        this.caseSList();
        return complexity;
    }

    public CloverToken tryBlock(boolean labelled) throws RecognitionException, TokenStreamException {
        Token tr = null;
        CloverToken last = null;
        int complexity = 0;
        ContextSet saveContext = this.getCurrentContext();
        tr = this.LT(1);
        this.match(105);
        if (this.inputState.guessing == 0) {
            this.enterContext(11);
            saveContext = this.getCurrentContext();
        }
        last = this.compoundStatement();
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        while (this.LA(1) == 107) {
            last = this.handler();
            if (this.inputState.guessing != 0) continue;
            ++complexity;
        }
        if (this.LA(1) == 106) {
            this.match(106);
            if (this.inputState.guessing == 0) {
                this.enterContext(13);
                saveContext = this.getCurrentContext();
            }
            last = this.compoundStatement();
            if (this.inputState.guessing == 0) {
                this.exitContext();
            }
        } else if (this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 88 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0 && !labelled) {
            this.enterContext(saveContext);
            this.instrInlineBefore((CloverToken)tr, last, complexity);
            this.exitContext();
        }
        return last;
    }

    public int aCase(FlagDeclEmitter flag) throws RecognitionException, TokenStreamException {
        Token si1 = null;
        Token si2 = null;
        Token t = null;
        Token pos = null;
        int complexity = 0;
        if (this.LA(1) == 104) {
            si1 = this.LT(1);
            this.match(104);
            if (this.inputState.guessing == 0) {
                this.constExpr = true;
            }
            this.expression();
            if (this.inputState.guessing == 0) {
                this.constExpr = false;
                pos = si1;
                ++complexity;
            }
        } else if (this.LA(1) == 86) {
            si2 = this.LT(1);
            this.match(86);
            if (this.inputState.guessing == 0) {
                pos = si2;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        t = this.LT(1);
        this.match(93);
        if (this.inputState.guessing == 0) {
            this.instrInlineAfter((CloverToken)t, (CloverToken)pos, (CloverToken)t, flag);
            this.fileInfo.setSuppressFallthroughWarnings(true);
        }
        return complexity;
    }

    public void caseSList() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 39 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 45 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 105 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            CloverToken tmp = this.statement(null);
        }
    }

    public void expressionList() throws RecognitionException, TokenStreamException {
        this.expression();
        while (this.LA(1) == 53) {
            this.match(53);
            this.expression();
        }
    }

    public CloverToken handler() throws RecognitionException, TokenStreamException {
        String paramType = null;
        CloverToken last = null;
        this.match(107);
        this.match(84);
        paramType = this.parameterDeclaration();
        this.match(85);
        if (this.inputState.guessing == 0) {
            this.enterContext(12);
        }
        last = this.compoundStatement();
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        return last;
    }

    public void assignmentExpression() throws RecognitionException, TokenStreamException {
        this.conditionalExpression();
        if (this.LA(1) == 89 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118) {
            if (this.LA(1) == 89) {
                this.match(89);
            } else if (this.LA(1) == 108) {
                this.match(108);
            } else if (this.LA(1) == 109) {
                this.match(109);
            } else if (this.LA(1) == 110) {
                this.match(110);
            } else if (this.LA(1) == 111) {
                this.match(111);
            } else if (this.LA(1) == 112) {
                this.match(112);
            } else if (this.LA(1) == 113) {
                this.match(113);
            } else if (this.LA(1) == 114) {
                this.match(114);
            } else if (this.LA(1) == 115) {
                this.match(115);
            } else if (this.LA(1) == 116) {
                this.match(116);
            } else if (this.LA(1) == 117) {
                this.match(117);
            } else if (this.LA(1) == 118) {
                this.match(118);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.assignmentExpression();
        } else if (this.LA(1) != 45 && this.LA(1) != 49 && this.LA(1) != 53 && this.LA(1) != 83 && this.LA(1) != 85 && this.LA(1) != 93) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void conditionalExpression() throws RecognitionException, TokenStreamException {
        Token endOfCond = null;
        CloverToken startOfCond = null;
        if (this.inputState.guessing == 0) {
            startOfCond = (CloverToken)this.LT(1);
        }
        this.logicalOrExpression();
        if (this.LA(1) == 54) {
            endOfCond = this.LT(1);
            this.match(54);
            if (this.inputState.guessing == 0 && !this.constExpr) {
                this.instrBoolExpr(startOfCond, (CloverToken)endOfCond);
            }
            this.assignmentExpression();
            this.match(93);
            this.conditionalExpression();
        } else if (this.LA(1) != 45 && this.LA(1) != 49 && this.LA(1) != 53 && this.LA(1) != 83 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void logicalOrExpression() throws RecognitionException, TokenStreamException {
        this.logicalAndExpression();
        while (this.LA(1) == 119) {
            this.match(119);
            this.logicalAndExpression();
        }
    }

    public void logicalAndExpression() throws RecognitionException, TokenStreamException {
        this.inclusiveOrExpression();
        while (this.LA(1) == 120) {
            this.match(120);
            this.inclusiveOrExpression();
        }
    }

    public void inclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.exclusiveOrExpression();
        while (this.LA(1) == 121) {
            this.match(121);
            this.exclusiveOrExpression();
        }
    }

    public void exclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.andExpression();
        while (this.LA(1) == 122) {
            this.match(122);
            this.andExpression();
        }
    }

    public void andExpression() throws RecognitionException, TokenStreamException {
        this.equalityExpression();
        while (this.LA(1) == 81) {
            this.match(81);
            this.equalityExpression();
        }
    }

    public void equalityExpression() throws RecognitionException, TokenStreamException {
        this.relationalExpression();
        while (this.LA(1) == 123 || this.LA(1) == 124) {
            if (this.LA(1) == 123) {
                this.match(123);
            } else if (this.LA(1) == 124) {
                this.match(124);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.relationalExpression();
        }
    }

    public void relationalExpression() throws RecognitionException, TokenStreamException {
        String type = null;
        this.shiftExpression();
        if (this.LA(1) == 45 || this.LA(1) == 49 || this.LA(1) == 52 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 57 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 85 || this.LA(1) == 89 || this.LA(1) == 93 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 110 || this.LA(1) == 111 || this.LA(1) == 112 || this.LA(1) == 113 || this.LA(1) == 114 || this.LA(1) == 115 || this.LA(1) == 116 || this.LA(1) == 117 || this.LA(1) == 118 || this.LA(1) == 119 || this.LA(1) == 120 || this.LA(1) == 121 || this.LA(1) == 122 || this.LA(1) == 123 || this.LA(1) == 124 || this.LA(1) == 125 || this.LA(1) == 126) {
            while (this.LA(1) == 52 || this.LA(1) == 57 || this.LA(1) == 125 || this.LA(1) == 126) {
                if (this.LA(1) == 52) {
                    this.match(52);
                } else if (this.LA(1) == 57) {
                    this.match(57);
                } else if (this.LA(1) == 125) {
                    this.match(125);
                } else if (this.LA(1) == 126) {
                    this.match(126);
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.shiftExpression();
            }
        } else if (this.LA(1) == 127) {
            this.match(127);
            type = this.typeSpec();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void shiftExpression() throws RecognitionException, TokenStreamException {
        this.additiveExpression();
        while (this.LA(1) == 58 || this.LA(1) == 59 || this.LA(1) == 128) {
            if (this.LA(1) == 128) {
                this.match(128);
            } else if (this.LA(1) == 58) {
                this.match(58);
            } else if (this.LA(1) == 59) {
                this.match(59);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.additiveExpression();
        }
    }

    public void additiveExpression() throws RecognitionException, TokenStreamException {
        this.multiplicativeExpression();
        while (this.LA(1) == 129 || this.LA(1) == 130) {
            if (this.LA(1) == 129) {
                this.match(129);
            } else if (this.LA(1) == 130) {
                this.match(130);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.multiplicativeExpression();
        }
    }

    public void multiplicativeExpression() throws RecognitionException, TokenStreamException {
        this.unaryExpression();
        while (this.LA(1) == 69 || this.LA(1) == 131 || this.LA(1) == 132) {
            if (this.LA(1) == 69) {
                this.match(69);
            } else if (this.LA(1) == 131) {
                this.match(131);
            } else if (this.LA(1) == 132) {
                this.match(132);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.unaryExpression();
        }
    }

    public void unaryExpression() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 133) {
            this.match(133);
            this.unaryExpression();
        } else if (this.LA(1) == 134) {
            this.match(134);
            this.unaryExpression();
        } else if (this.LA(1) == 130) {
            this.match(130);
            this.unaryExpression();
        } else if (this.LA(1) == 129) {
            this.match(129);
            this.unaryExpression();
        } else if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            this.unaryExpressionNotPlusMinus();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
        String type = null;
        if (this.LA(1) == 135) {
            this.match(135);
            this.unaryExpression();
            return;
        }
        if (this.LA(1) == 136) {
            this.match(136);
            this.unaryExpression();
            return;
        }
        if (this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146) throw new NoViableAltException(this.LT(1), this.getFilename());
        boolean synPredMatched245 = false;
        if (this.LA(1) == 84 && this.LA(2) >= 60 && this.LA(2) <= 68) {
            int _m245 = this.mark();
            synPredMatched245 = true;
            ++this.inputState.guessing;
            try {
                this.match(84);
                type = this.builtInTypeSpec();
                this.match(85);
                this.unaryExpression();
            }
            catch (RecognitionException pe) {
                synPredMatched245 = false;
            }
            this.rewind(_m245);
            --this.inputState.guessing;
        }
        if (synPredMatched245) {
            this.match(84);
            type = this.builtInTypeSpec();
            this.match(85);
            this.unaryExpression();
            return;
        }
        boolean synPredMatched247 = false;
        if (this.LA(1) == 84 && this.LA(2) == 50) {
            int _m247 = this.mark();
            synPredMatched247 = true;
            ++this.inputState.guessing;
            try {
                this.match(84);
                type = this.classTypeSpec();
                this.match(85);
                this.unaryExpressionNotPlusMinus();
            }
            catch (RecognitionException pe) {
                synPredMatched247 = false;
            }
            this.rewind(_m247);
            --this.inputState.guessing;
        }
        if (synPredMatched247) {
            this.match(84);
            type = this.classTypeSpec();
            this.match(85);
            this.unaryExpressionNotPlusMinus();
            return;
        } else {
            if (this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 49 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 93 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 112 && this.LA(2) != 113 && this.LA(2) != 114 && this.LA(2) != 115 && this.LA(2) != 116 && this.LA(2) != 117 && this.LA(2) != 118 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.postfixExpression();
        }
    }

    public void postfixExpression() throws RecognitionException, TokenStreamException {
        this.primaryExpression();
        while (true) {
            if (this.LA(1) == 51) {
                this.match(51);
                if (this.LA(1) == 50 || this.LA(1) == 52) {
                    if (this.LA(1) == 52) {
                        this.typeArguments();
                    } else if (this.LA(1) != 50) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(50);
                    continue;
                }
                if (this.LA(1) == 88) {
                    this.match(88);
                    continue;
                }
                if (this.LA(1) == 77) {
                    this.match(77);
                    continue;
                }
                if (this.LA(1) == 140) {
                    this.newExpression();
                    continue;
                }
                if (this.LA(1) == 56) {
                    this.match(56);
                    continue;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 48 && this.LA(2) == 49) {
                int _cnt253 = 0;
                while (true) {
                    if (this.LA(1) != 48) {
                        if (_cnt253 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(48);
                    this.match(49);
                    ++_cnt253;
                }
                this.match(51);
                this.match(77);
                continue;
            }
            if (this.LA(1) == 48 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(48);
                this.expression();
                this.match(49);
                continue;
            }
            if (this.LA(1) != 84) break;
            this.match(84);
            this.argList();
            this.match(85);
        }
        if (this.LA(1) == 133) {
            this.match(133);
        } else if (this.LA(1) == 134) {
            this.match(134);
        } else if (this.LA(1) != 45 && this.LA(1) != 49 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 69 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 && this.LA(1) != 125 && this.LA(1) != 126 && this.LA(1) != 127 && this.LA(1) != 128 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 131 && this.LA(1) != 132) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void newExpression() throws RecognitionException, TokenStreamException {
        CloverToken endOfBlock = null;
        this.match(140);
        this.type();
        if (this.LA(1) == 84) {
            this.match(84);
            this.argList();
            this.match(85);
            if (this.LA(1) == 82) {
                endOfBlock = this.classBlock(null);
            } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 51 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 69 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 && this.LA(1) != 125 && this.LA(1) != 126 && this.LA(1) != 127 && this.LA(1) != 128 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 131 && this.LA(1) != 132 && this.LA(1) != 133 && this.LA(1) != 134) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else if (this.LA(1) == 48) {
            this.newArrayDeclarator();
            if (this.LA(1) == 82) {
                this.arrayInitializer();
            } else if (this.LA(1) != 45 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 51 && this.LA(1) != 52 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 57 && this.LA(1) != 58 && this.LA(1) != 59 && this.LA(1) != 69 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 89 && this.LA(1) != 93 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 110 && this.LA(1) != 111 && this.LA(1) != 112 && this.LA(1) != 113 && this.LA(1) != 114 && this.LA(1) != 115 && this.LA(1) != 116 && this.LA(1) != 117 && this.LA(1) != 118 && this.LA(1) != 119 && this.LA(1) != 120 && this.LA(1) != 121 && this.LA(1) != 122 && this.LA(1) != 123 && this.LA(1) != 124 && this.LA(1) != 125 && this.LA(1) != 126 && this.LA(1) != 127 && this.LA(1) != 128 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 131 && this.LA(1) != 132 && this.LA(1) != 133 && this.LA(1) != 134) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void constant() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 141) {
            this.match(141);
        } else if (this.LA(1) == 142) {
            this.match(142);
        } else if (this.LA(1) == 143) {
            this.match(143);
        } else if (this.LA(1) == 144) {
            this.match(144);
        } else if (this.LA(1) == 145) {
            this.match(145);
        } else if (this.LA(1) == 146) {
            this.match(146);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public void newArrayDeclarator() throws RecognitionException, TokenStreamException {
        int _cnt268 = 0;
        while (true) {
            if (this.LA(1) == 48 && (this.LA(2) == 49 || this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
                this.match(48);
                if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
                    this.expression();
                } else if (this.LA(1) != 49) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else {
                if (_cnt268 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(49);
            ++_cnt268;
        }
    }

    protected void annMemberValuePair(Annotation anno, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        Token name = null;
        boolean ft = false;
        name = this.LT(1);
        this.match(50);
        this.match(89);
        ft = this.annMemberValue2(anno, name.getText(), isSuppressWarnings, true);
    }

    protected boolean annMemberValue2(AnnotationValueCollection anno, Object key, boolean isSuppressWarnings, boolean makeArrayAndAdd) throws RecognitionException, TokenStreamException {
        Token t = null;
        Annotation innerAnno = null;
        boolean wasFallthroughLiteral = false;
        String expr = null;
        boolean synPredMatched281 = false;
        if (this.LA(1) == 143 && (this.LA(2) == 45 || this.LA(2) == 53 || this.LA(2) == 83 || this.LA(2) == 85)) {
            int _m281 = this.mark();
            synPredMatched281 = true;
            ++this.inputState.guessing;
            try {
                this.match(143);
            }
            catch (RecognitionException pe) {
                synPredMatched281 = false;
            }
            this.rewind(_m281);
            --this.inputState.guessing;
        }
        if (synPredMatched281) {
            t = this.LT(1);
            this.match(143);
            if (this.inputState.guessing == 0) {
                wasFallthroughLiteral = "\"fallthrough\"".equalsIgnoreCase(t.getText());
                if (isSuppressWarnings && makeArrayAndAdd) {
                    if (wasFallthroughLiteral) {
                        this.existingFallthroughSuppression = true;
                    } else {
                        this.suppressWarningsInstr = new SimpleEmitter("{");
                        SimpleEmitter closeCurly = new SimpleEmitter("}");
                        SimpleEmitter comma = new SimpleEmitter(",");
                        SimpleEmitter fallthrough = new SimpleEmitter("\"fallthrough\"");
                        ((CloverToken)t).addPreEmitter(this.suppressWarningsInstr);
                        ((CloverToken)t).addPostEmitter(comma);
                        ((CloverToken)t).addPostEmitter(fallthrough);
                        ((CloverToken)t).addPostEmitter(closeCurly);
                        this.suppressWarningsInstr.addDependent(closeCurly);
                        this.suppressWarningsInstr.addDependent(comma);
                        this.suppressWarningsInstr.addDependent(fallthrough);
                    }
                }
                if (anno != null) {
                    anno.put(key, new StringifiedAnnotationValue(t.getText()));
                }
            }
        } else if (!(this.LA(1) != 50 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 84 && this.LA(1) != 88 && this.LA(1) != 129 && this.LA(1) != 130 && this.LA(1) != 133 && this.LA(1) != 134 && this.LA(1) != 135 && this.LA(1) != 136 && this.LA(1) != 137 && this.LA(1) != 138 && this.LA(1) != 139 && this.LA(1) != 140 && this.LA(1) != 141 && this.LA(1) != 142 && this.LA(1) != 143 && this.LA(1) != 144 && this.LA(1) != 145 && this.LA(1) != 146 || this.LA(2) != 45 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 52 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 58 && this.LA(2) != 59 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 88 && this.LA(2) != 119 && this.LA(2) != 120 && this.LA(2) != 121 && this.LA(2) != 122 && this.LA(2) != 123 && this.LA(2) != 124 && this.LA(2) != 125 && this.LA(2) != 126 && this.LA(2) != 127 && this.LA(2) != 128 && this.LA(2) != 129 && this.LA(2) != 130 && this.LA(2) != 131 && this.LA(2) != 132 && this.LA(2) != 133 && this.LA(2) != 134 && this.LA(2) != 135 && this.LA(2) != 136 && this.LA(2) != 137 && this.LA(2) != 138 && this.LA(2) != 139 && this.LA(2) != 140 && this.LA(2) != 141 && this.LA(2) != 142 && this.LA(2) != 143 && this.LA(2) != 144 && this.LA(2) != 145 && this.LA(2) != 146)) {
            expr = this.conditionalExpression2();
            if (this.inputState.guessing == 0 && anno != null) {
                anno.put(key, new StringifiedAnnotationValue(expr));
            }
        } else if (this.LA(1) == 80) {
            innerAnno = this.annotation();
            if (this.inputState.guessing == 0 && anno != null) {
                anno.put(key, innerAnno);
            }
        } else if (this.LA(1) == 82) {
            this.annMemberValueArrayInitializer(anno, key, isSuppressWarnings);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return wasFallthroughLiteral;
    }

    protected String conditionalExpression2() throws RecognitionException, TokenStreamException {
        CloverToken start = (CloverToken)this.LT(1);
        CloverToken end = null;
        String asString = null;
        this.conditionalExpression();
        if (this.inputState.guessing == 0) {
            end = (CloverToken)this.LT(0);
            asString = TokenListUtil.getNormalisedSequence(start, end);
        }
        return asString;
    }

    protected void annMemberValueArrayInitializer(AnnotationValueCollection anno, Object key, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        ArrayAnnotationValue annoArray;
        boolean emitComma = false;
        boolean seenFallthrough = false;
        Object last = null;
        ArrayAnnotationValue arrayAnnotationValue = annoArray = anno == null ? null : new ArrayAnnotationValue();
        if (anno != null) {
            anno.put(key, annoArray);
        }
        this.match(82);
        if (this.LA(1) == 50 || this.LA(1) == 56 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 84 || this.LA(1) == 88 || this.LA(1) == 129 || this.LA(1) == 130 || this.LA(1) == 133 || this.LA(1) == 134 || this.LA(1) == 135 || this.LA(1) == 136 || this.LA(1) == 137 || this.LA(1) == 138 || this.LA(1) == 139 || this.LA(1) == 140 || this.LA(1) == 141 || this.LA(1) == 142 || this.LA(1) == 143 || this.LA(1) == 144 || this.LA(1) == 145 || this.LA(1) == 146) {
            seenFallthrough = this.annMemberValues(annoArray, isSuppressWarnings);
            if (this.inputState.guessing == 0) {
                emitComma = true;
            }
        } else if (this.LA(1) != 53 && this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 53) {
            this.match(53);
            if (this.inputState.guessing == 0) {
                emitComma = false;
            }
        } else if (this.LA(1) != 83) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken t = (CloverToken)this.LT(0);
            if (isSuppressWarnings) {
                if (seenFallthrough) {
                    this.existingFallthroughSuppression = true;
                } else {
                    if (emitComma) {
                        this.suppressWarningsInstr = new SimpleEmitter(",");
                        t.addPostEmitter(this.suppressWarningsInstr);
                    }
                    SimpleEmitter fallthrough = new SimpleEmitter("\"fallthrough\"");
                    t.addPostEmitter(fallthrough);
                    if (this.suppressWarningsInstr == null) {
                        this.suppressWarningsInstr = fallthrough;
                    } else {
                        this.suppressWarningsInstr.addDependent(fallthrough);
                    }
                }
            }
        }
        this.match(83);
    }

    protected boolean annMemberValues(ArrayAnnotationValue annoArray, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        boolean sawFallthrough = false;
        boolean tmp = this.annMemberValue2(annoArray, null, isSuppressWarnings, false);
        if (this.inputState.guessing == 0 && tmp) {
            sawFallthrough = true;
        }
        while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 56 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 64 || this.LA(2) == 65 || this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 68 || this.LA(2) == 80 || this.LA(2) == 82 || this.LA(2) == 84 || this.LA(2) == 88 || this.LA(2) == 129 || this.LA(2) == 130 || this.LA(2) == 133 || this.LA(2) == 134 || this.LA(2) == 135 || this.LA(2) == 136 || this.LA(2) == 137 || this.LA(2) == 138 || this.LA(2) == 139 || this.LA(2) == 140 || this.LA(2) == 141 || this.LA(2) == 142 || this.LA(2) == 143 || this.LA(2) == 144 || this.LA(2) == 145 || this.LA(2) == 146)) {
            this.match(53);
            tmp = this.annMemberValue2(annoArray, null, isSuppressWarnings, false);
            if (this.inputState.guessing != 0 || !tmp) continue;
            sawFallthrough = true;
        }
        return sawFallthrough;
    }
}

