/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CoverageData;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.CoverageRecording;
import com.cenqua.clover.CoverageSliceVisitor;
import com.cenqua.clover.Logger;
import com.cenqua.clover.RecordingFile;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.TestCaseInfo;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CoverageDataCollator {
    private Clover2Registry registry;
    private RecordingFile.RecordingFileFilter filter;
    private long tsOldestRecordingUsed = 0L;
    private long tsNewestRecordingUsed = 0L;

    public CoverageDataCollator(Clover2Registry registry) {
        this.registry = registry;
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec) {
        CoverageData coverageData = new CoverageData(this.registry.getModel().getDataLength());
        long from = this.registry.getVersion() - spec.getSpan();
        long to = Long.MAX_VALUE;
        if (this.filter == null || this.filter.getFrom() != from || this.filter.getTo() != to) {
            this.filter = new RecordingFile.RecordingFileFilter(this.registry.getRegistryFile().getName(), from, to);
        }
        this.filter.processDir(this.getCurrentDirIfNull(this.registry.getRegistryFile().getParentFile()));
        this.collateRecordingFiles(coverageData, spec);
        this.collateSlicePairs(coverageData, spec);
        return coverageData;
    }

    private File getCurrentDirIfNull(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        return dir;
    }

    public boolean isOutOfDate() {
        RecordingFile.RecordingFileFilter latestFilter = new RecordingFile.RecordingFileFilter(this.registry.getRegistryFile().getName(), this.filter.getFrom(), this.filter.getTo());
        latestFilter.processDir(this.getCurrentDirIfNull(this.registry.getRegistryFile().getParentFile()));
        return !((Object)this.filter.getMatchingRecordingFiles()).equals(latestFilter.getMatchingRecordingFiles());
    }

    public long getTsOldestRecordingUsed() {
        return this.tsOldestRecordingUsed;
    }

    public long getTsNewestRecordingUsed() {
        return this.tsNewestRecordingUsed;
    }

    private void collateRecordingFiles(final CoverageData coverageData, CoverageDataSpec spec) {
        int recordingsUsed = 0;
        this.tsNewestRecordingUsed = 0L;
        this.tsOldestRecordingUsed = Long.MAX_VALUE;
        final boolean[] used = new boolean[]{false};
        Iterator it = this.filter.getMatchingRecordingFiles().iterator();
        while (it.hasNext()) {
            RecordingFile recordingFile = (RecordingFile)it.next();
            try {
                final CoverageRecording rec = recordingFile.readData(spec);
                this.registry.getModel().visitFiles(new FileInfoVisitor(){

                    public void visitFileInfo(BaseFileInfo f) {
                        FileInfo file = (FileInfo)f;
                        if (file.supportsVersion(rec.dbVersion)) {
                            CoverageDataCollator.this.addToReceptorRange(coverageData.getCoverage(), rec, file);
                            used[0] = true;
                        }
                    }
                });
                if (!used[0]) continue;
                ++recordingsUsed;
                if (recordingFile.getTimestamp() < this.tsOldestRecordingUsed) {
                    this.tsOldestRecordingUsed = recordingFile.getTimestamp();
                }
                if (rec.writeTS <= this.tsNewestRecordingUsed) continue;
                this.tsNewestRecordingUsed = rec.writeTS;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        coverageData.setTimestamp(this.tsNewestRecordingUsed);
        coverageData.setNumRecordings(recordingsUsed);
    }

    private void collateSlicePairs(CoverageData coverageData, CoverageDataSpec spec) {
        long ts1 = System.currentTimeMillis();
        CoverageSliceVisitor visitor = new CoverageSliceVisitor(this.registry.getModel(), coverageData);
        int numPairs = 0;
        Iterator it = this.filter.getSlicePairs().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            TestCaseInfo tci = null;
            List pairsForId = (List)e.getValue();
            Iterator pairs = pairsForId.iterator();
            while (pairs.hasNext()) {
                ++numPairs;
                RecordingFile.SliceFilePair pair = (RecordingFile.SliceFilePair)pairs.next();
                try {
                    CoverageRecording start = pair.start.readData(spec);
                    CoverageRecording end = pair.end.readData(spec);
                    if (tci == null) {
                        tci = TestCaseInfo.Factory.getInstanceForSlice(start, end);
                        coverageData.addTestCase(tci);
                    }
                    visitor.addSliceCoverageForSupportingFiles(tci, start, end);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        long ts2 = System.currentTimeMillis();
        Logger.getInstance().debug("processed " + numPairs + " slices in " + (ts2 - ts1) + "ms (" + (numPairs != 0 ? "" + (ts2 - ts1) / (long)numPairs + "ms" : "-") + " per pair)");
    }

    private void addToReceptorRange(int[] data, CoverageRecording rec, CoverageDataReceptor receptor) {
        for (int i = receptor.getDataIndex(); i < receptor.getDataIndex() + receptor.getDataLength(); ++i) {
            int n = i;
            data[n] = data[n] + rec.elements[i];
        }
    }
}

